/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class ApplicationAccessWLS {
    private static final Logger LOGGER = Logger.getLogger(ApplicationAccessWLS.class.getName());
    private static final String CIC_MANAGER_CLASS_NAME = "weblogic.invocation.ComponentInvocationContextManager";
    private static final String CIC_CLASS_NAME = "weblogic.invocation.ComponentInvocationContext";
    private final Map<ClassLoader, String> appNames = Collections.synchronizedMap(new WeakHashMap());
    private Object applicationAccessInstance;
    private Method getApplicationNameMethod;
    private Method getApplicationVersionMethod;
    private Object cicManagerInstance;
    private Method getCurrentCicMethod;
    private Method getApplicationIdMethod;

    public ApplicationAccessWLS() {
        if (this.initUsingCic()) {
            LOGGER.fine("ApplicationAccessWLS initialized using ComponentInvocationContext.");
            return;
        }
        this.cicManagerInstance = null;
        if (this.initUsingApplicationAccess()) {
            LOGGER.fine("ApplicationAccessWLS initialized using ApplicationAccess.");
            return;
        }
        this.applicationAccessInstance = null;
        LOGGER.fine("Failed to initialize ApplicationAccessWLS.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationName(ClassLoader classLoader) {
        if (this.appNames.containsKey(classLoader)) {
            return this.appNames.get(classLoader);
        }
        Map<ClassLoader, String> map = this.appNames;
        synchronized (map) {
            if (this.appNames.containsKey(classLoader)) {
                return this.appNames.get(classLoader);
            }
            String appName = this.getApplicationNameInternal(classLoader);
            this.appNames.put(classLoader, appName);
            return appName;
        }
    }

    private String getApplicationNameInternal(ClassLoader classLoader) {
        if (this.cicManagerInstance != null) {
            try {
                return this.getAppNameUsingCic();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "ApplicationAccessWLS.getApplicationName error in getAppNameUsingCic.", e);
                return null;
            }
        }
        if (this.applicationAccessInstance != null) {
            try {
                return this.getAppNameUsingApplicationAccess(classLoader);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "ApplicationAccessWLS.getApplicationName error in getAppNameUsingApplicationAccess.", e);
                return null;
            }
        }
        LOGGER.fine("ApplicationAccessWLS: null applicationName returned.");
        return null;
    }

    protected boolean initUsingCic() {
        if (ApplicationAccessWLS.class.getClassLoader().getResource("META-INF/services/weblogic.invocation.ComponentInvocationContextManager") == null) {
            return false;
        }
        try {
            Class cicManagerClass = PrivilegedAccessHelper.getClassForName((String)CIC_MANAGER_CLASS_NAME);
            Method getInstance = PrivilegedAccessHelper.getDeclaredMethod((Class)cicManagerClass, (String)"getInstance", (Class[])new Class[0]);
            this.cicManagerInstance = PrivilegedAccessHelper.invokeMethod((Method)getInstance, (Object)cicManagerClass);
            this.getCurrentCicMethod = PrivilegedAccessHelper.getMethod((Class)cicManagerClass, (String)"getCurrentComponentInvocationContext", (Class[])new Class[0], (boolean)true);
            Class cicClass = PrivilegedAccessHelper.getClassForName((String)CIC_CLASS_NAME);
            this.getApplicationIdMethod = PrivilegedAccessHelper.getDeclaredMethod((Class)cicClass, (String)"getApplicationId", (Class[])new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.log(Level.FINE, "Error initializing ApplicationAccessWLS using ComponentInvocationContext.", e);
            return false;
        }
    }

    protected boolean initUsingApplicationAccess() {
        try {
            Class applicationAccessClass = PrivilegedAccessHelper.getClassForName((String)"weblogic.application.ApplicationAccess");
            Method getApplicationAccessMethod = PrivilegedAccessHelper.getDeclaredMethod((Class)applicationAccessClass, (String)"getApplicationAccess", (Class[])new Class[0]);
            this.applicationAccessInstance = PrivilegedAccessHelper.invokeMethod((Method)getApplicationAccessMethod, (Object)applicationAccessClass);
            Class[] methodParameterTypes = new Class[]{ClassLoader.class};
            this.getApplicationNameMethod = PrivilegedAccessHelper.getMethod((Class)applicationAccessClass, (String)"getApplicationName", (Class[])methodParameterTypes, (boolean)true);
            this.getApplicationVersionMethod = PrivilegedAccessHelper.getMethod((Class)applicationAccessClass, (String)"getApplicationVersion", (Class[])methodParameterTypes, (boolean)true);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.log(Level.FINE, "Error initializing ApplicationAccessWLS using ApplicationAccess.", ex);
            return false;
        }
    }

    private String getAppNameUsingCic() throws InvocationTargetException, IllegalAccessException {
        Object cicInstance = PrivilegedAccessHelper.invokeMethod((Method)this.getCurrentCicMethod, (Object)this.cicManagerInstance);
        return (String)PrivilegedAccessHelper.invokeMethod((Method)this.getApplicationIdMethod, (Object)cicInstance);
    }

    private String getAppNameUsingApplicationAccess(ClassLoader classLoader) throws InvocationTargetException, IllegalAccessException {
        String appVersion;
        Object[] parameters = new Object[]{classLoader};
        String appName = (String)PrivilegedAccessHelper.invokeMethod((Method)this.getApplicationNameMethod, (Object)this.applicationAccessInstance, (Object[])parameters);
        if (appName != null && (appVersion = (String)PrivilegedAccessHelper.invokeMethod((Method)this.getApplicationVersionMethod, (Object)this.applicationAccessInstance, (Object[])parameters)) != null) {
            return appName + "#" + appVersion;
        }
        return appName;
    }
}

