/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class UnitOfWorkConformAcrossIndirectionTest
extends TestCase {
    protected int expected = 2;
    protected UnitOfWork uow;
    protected Vector result;
    protected Employee readObjectResult;
    protected ReadAllQuery query = null;
    protected ReadObjectQuery readObjectQuery;

    public UnitOfWorkConformAcrossIndirectionTest() {
        this.setDescription("Test that simple expressions can be conformed across indirection.");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow.release();
    }

    protected void setup() {
        this.beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee example = (Employee)manager.getObject(Employee.class, "0001");
        Employee example2 = (Employee)manager.getObject(Employee.class, "0002");
        this.uow.readAllObjects(Employee.class);
        Employee clone = (Employee)this.uow.readObject((Object)example2);
        clone.getAddress().setCity(example.getAddress().getCity());
        clone.getAddress().setProvince("Jeju");
        this.query = new ReadAllQuery(Employee.class);
        this.query.conformResultsInUnitOfWork();
        this.query.setSelectionCriteria(new ExpressionBuilder(Employee.class).get("address").get("city").equal((Object)example.getAddress().getCity()));
        this.readObjectQuery = new ReadObjectQuery(Employee.class);
        this.readObjectQuery.conformResultsInUnitOfWork();
        this.readObjectQuery.setSelectionCriteria(new ExpressionBuilder(Employee.class).get("address").get("province").equal((Object)"Jeju"));
    }

    public void test() {
        this.result = (Vector)this.uow.executeQuery((DatabaseQuery)this.query);
        this.readObjectResult = (Employee)this.uow.executeQuery((DatabaseQuery)this.readObjectQuery);
    }

    protected void verify() {
        if (this.result.size() != this.expected) {
            throw new TestErrorException("Expecting: " + this.expected + " retrieved: " + this.result.size());
        }
        if (this.readObjectResult == null) {
            throw new TestErrorException("Fix was not ported to read object queries aswell.");
        }
    }
}

