/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class DirectMapMappingTest
extends AutoVerifyTestCase {
    DatabaseMapping directMap;
    DatabaseMapping directMapForBatchRead;

    public DirectMapMappingTest() {
        this.setDescription("Test if DirectMapMapping is written out and read in properly");
    }

    public void test() {
        this.directMap = this.getSession().getDescriptor(DirectMapMappings.class).getMappingForAttributeName("directMap");
        this.directMapForBatchRead = this.getSession().getDescriptor(DirectMapMappings.class).getMappingForAttributeName("directMapForBatchRead");
    }

    protected void verify() {
        if (this.directMap == null || this.directMapForBatchRead == null) {
            throw new TestErrorException("DirectMapMapping does not exist after written out and read in from xml");
        }
        if (!(this.directMap instanceof DirectMapMapping) || !(this.directMapForBatchRead instanceof DirectMapMapping)) {
            throw new TestErrorException("DirectMapMapping has been changed to another class after written out and read in from xml");
        }
        if (((DirectMapMapping)this.directMap).getKeyConverter() == null || !(((DirectMapMapping)this.directMap).getKeyConverter() instanceof TypeConversionConverter) || ((TypeConversionConverter)((DirectMapMapping)this.directMap).getKeyConverter()).getObjectClass() != Integer.class) {
            throw new TestErrorException("DirectMapMapping returned a wrong key converter after written out and read in from xml");
        }
        if (((DirectMapMapping)this.directMap).getDirectKeyField() == null || ((DirectMapMapping)this.directMap).getDirectKeyField().getClass() != DatabaseField.class || !((DirectMapMapping)this.directMap).getDirectKeyField().getName().equals("KEY_FIELD")) {
            throw new TestErrorException("DirectMapMapping returned a wrong directKeyField after written out and read in from xml");
        }
    }
}

