/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.api.avro.GenericBinding;
import oracle.kv.impl.api.avro.JsonBinding;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.codehaus.jackson.JsonNode;

class SchemaChecker {
    private static final String CANNOT_READ_WITH_OLD_SCHEMA = " Data written with the new schema will not be readable with the old schema.";
    private static final String CANNOT_READ_WITH_NEW_SCHEMA = " Data written with the old schema will not be readable with the new schema.";
    private static final String CANNOT_READ_WITH_EITHER_SCHEMA = " Data written with one schema will not be readable with the other schema.";

    SchemaChecker() {
    }

    static boolean equalSerialization(Schema s1, Schema s2) {
        return SchemaChecker.schemasEqualWithDefault(s1, s2, new HashSet<SchemaPair>(100), false);
    }

    static boolean equalSerializationWithDefault(Schema s1, Schema s2, boolean allowNullDefault) {
        return SchemaChecker.schemasEqualWithDefault(s1, s2, new HashSet<SchemaPair>(100), allowNullDefault);
    }

    private static boolean schemasEqual(Schema s1, Schema s2, Set<SchemaPair> visitedSet) {
        return SchemaChecker.schemasEqualWithDefault(s1, s2, visitedSet, false);
    }

    private static boolean schemasEqualWithDefault(Schema s1, Schema s2, Set<SchemaPair> visitedSet, boolean allowNullDefault) {
        if (s1 == s2) {
            return true;
        }
        if (SchemaChecker.alreadyVisited(new SchemaPair(s1, s2), visitedSet)) {
            return true;
        }
        Schema.Type type = s1.getType();
        if (type != s2.getType()) {
            return false;
        }
        if (type == Schema.Type.RECORD || type == Schema.Type.ENUM || type == Schema.Type.FIXED) {
            String n1 = s1.getFullName();
            String n2 = s2.getFullName();
            if (n1 == null ? n2 != null : !n1.equals(n2)) {
                return false;
            }
        }
        switch (type) {
            case RECORD: {
                List<Schema.Field> f1 = s1.getFields();
                List<Schema.Field> f2 = s2.getFields();
                int nFields = f1.size();
                if (nFields != f2.size()) {
                    return false;
                }
                for (int i = 0; i < nFields; ++i) {
                    if (SchemaChecker.fieldsEqual(f1.get(i), f2.get(i), visitedSet, allowNullDefault)) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                List<Schema> t1 = s1.getTypes();
                List<Schema> t2 = s2.getTypes();
                int nTypes = t1.size();
                if (nTypes != t2.size()) {
                    return false;
                }
                for (int i = 0; i < nTypes; ++i) {
                    if (SchemaChecker.schemasEqual(t1.get(i), t2.get(i), visitedSet)) continue;
                    return false;
                }
                return true;
            }
            case ARRAY: {
                return SchemaChecker.schemasEqual(s1.getElementType(), s2.getElementType(), visitedSet);
            }
            case MAP: {
                return SchemaChecker.schemasEqual(s1.getValueType(), s2.getValueType(), visitedSet);
            }
            case ENUM: {
                return s1.getEnumSymbols().equals(s2.getEnumSymbols());
            }
            case FIXED: {
                return s1.getFixedSize() == s2.getFixedSize();
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                return true;
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)type));
    }

    private static boolean fieldsEqual(Schema.Field f1, Schema.Field f2, Set<SchemaPair> visitedSet, boolean allowNullDefault) {
        if (!f1.name().equals(f2.name())) {
            return false;
        }
        if (!SchemaChecker.schemasEqual(f1.schema(), f2.schema(), visitedSet)) {
            return false;
        }
        JsonNode d1 = f1.defaultValue();
        JsonNode d2 = f2.defaultValue();
        if (d1 == null || d2 == null) {
            if (d1 == null && d2 == null) {
                return true;
            }
            if (allowNullDefault) {
                return d1 == null;
            }
            return false;
        }
        if (Double.isNaN(d1.getDoubleValue())) {
            return Double.isNaN(d2.getDoubleValue());
        }
        return d1.equals(d2);
    }

    static void checkSchema(Schema s, List<String> errors, List<String> warnings) {
        SchemaChecker.checkSchema(s, errors, warnings, new HashSet<SchemaPair>(100));
    }

    private static void checkSchema(Schema s, List<String> errors, List<String> warnings, Set<SchemaPair> visitedSet) {
        if (SchemaChecker.alreadyVisited(new SchemaPair(s, s), visitedSet)) {
            return;
        }
        switch (s.getType()) {
            case RECORD: {
                for (Schema.Field field : s.getFields()) {
                    if (field.defaultValue() == null) {
                        warnings.add("Field " + SchemaChecker.makeFieldName(s, field) + " does not have a default value. Without a default, the field cannot be deleted in a future version of the schema. If it is deleted in the future, data written with the new schema will not be readable with the old schema.");
                    } else {
                        String strictError = SchemaChecker.checkDefaultValueStrictRules(field);
                        if (strictError != null) {
                            errors.add("Field " + SchemaChecker.makeFieldName(s, field) + " has a default value that does not conform strictly to the field's type. " + strictError);
                            continue;
                        }
                        String avroError = SchemaChecker.checkDefaultValueAvroRules(field);
                        if (avroError != null) {
                            errors.add("Field " + SchemaChecker.makeFieldName(s, field) + " has a default value that does not conform to the field's type. " + avroError);
                            continue;
                        }
                    }
                    SchemaChecker.checkSchema(field.schema(), errors, warnings, visitedSet);
                }
                break;
            }
            case UNION: {
                for (Schema type : s.getTypes()) {
                    SchemaChecker.checkSchema(type, errors, warnings, visitedSet);
                }
                break;
            }
            case ARRAY: {
                SchemaChecker.checkSchema(s.getElementType(), errors, warnings, visitedSet);
                break;
            }
            case MAP: {
                SchemaChecker.checkSchema(s.getValueType(), errors, warnings, visitedSet);
                break;
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + (Object)((Object)s.getType()));
            }
        }
    }

    private static String checkDefaultValueAvroRules(Schema.Field field) {
        Schema s = field.schema();
        JsonNode jsonValue = field.defaultValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(baos, null);
        try {
            ResolvingGrammarGenerator.encode(encoder, s, jsonValue);
        }
        catch (RuntimeException e) {
            return "Avro default value error: " + e.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Schema writerSchema = Schema.createRecord("testRecord", "", "", false);
        writerSchema.setFields(new ArrayList<Schema.Field>());
        Schema readerSchema = Schema.createRecord("testRecord", "", "", false);
        Schema.Field testField = new Schema.Field("testField", s, "", jsonValue);
        readerSchema.setFields(Collections.singletonList(testField));
        baos.reset();
        GenericData.Record record = new GenericData.Record(writerSchema);
        GenericBinding.GenericWriter writer = new GenericBinding.GenericWriter(writerSchema);
        try {
            writer.write(record, encoder);
            encoder.flush();
        }
        catch (RuntimeException e) {
            return "Avro serialization error: " + e.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(writerSchema, readerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(baos.toByteArray(), null);
        try {
            reader.read(null, decoder);
        }
        catch (RuntimeException e) {
            return "Avro deserialization error: " + e.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static String checkDefaultValueStrictRules(Schema.Field field) {
        Schema s = field.schema();
        JsonNode jsonValue = field.defaultValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonBinding.JsonDatumWriter writer = new JsonBinding.JsonDatumWriter(s, true);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(baos, null);
        try {
            writer.write(s, jsonValue, encoder);
            encoder.flush();
        }
        catch (RuntimeException e) {
            return e.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    static void checkEvolution(Schema s1, Schema s2, List<String> errors, List<String> warnings) {
        SchemaChecker.checkRecordEvolution(s1, s2, errors, warnings, new HashSet<SchemaPair>(100));
    }

    private static void checkRecordEvolution(Schema s1, Schema s2, List<String> errors, List<String> warnings, Set<SchemaPair> visitedSet) {
        for (Schema.Field f1 : s1.getFields()) {
            if (s2.getField(f1.name()) != null || f1.defaultValue() != null) continue;
            warnings.add("Field " + SchemaChecker.makeFieldName(s1, f1) + " was deleted but does not have a default value." + CANNOT_READ_WITH_OLD_SCHEMA);
        }
        for (Schema.Field f2 : s2.getFields()) {
            Schema.Field f1 = s1.getField(f2.name());
            if (f1 == null) {
                if (f2.defaultValue() != null) continue;
                errors.add("Field " + SchemaChecker.makeFieldName(s2, f2) + " was added but does not have a default value." + CANNOT_READ_WITH_NEW_SCHEMA);
                continue;
            }
            SchemaChecker.checkTypeEvolution(f1.schema(), f2.schema(), "The type of field " + SchemaChecker.makeFieldName(s2, f2) + " was changed.", errors, warnings, visitedSet);
        }
    }

    private static String makeFieldName(Schema record, Schema.Field field) {
        return field.name() + " in record " + record.getFullName();
    }

    private static void checkTypeEvolution(Schema s1, Schema s2, String parentPrefixMsg, List<String> errors, List<String> warnings, Set<SchemaPair> visitedSet) {
        Schema.Type type2;
        Schema.Type type = s1.getType();
        if (type != (type2 = s2.getType())) {
            if (type == Schema.Type.UNION) {
                String s2Name = s2.getFullName();
                Map<String, Schema> s1Types = SchemaChecker.getUnionTypes(s1);
                if (s1Types.size() == 1 && s1Types.containsKey(s2Name)) {
                    SchemaChecker.checkTypeEvolution(s1Types.get(s2Name), s2, parentPrefixMsg, errors, warnings, visitedSet);
                } else {
                    errors.add(parentPrefixMsg + " Union with types " + s1Types.keySet() + " was changed to non-union type " + s2Name + '.' + CANNOT_READ_WITH_NEW_SCHEMA);
                }
            } else if (type2 == Schema.Type.UNION) {
                String s1Name = s1.getFullName();
                Map<String, Schema> s2Types = SchemaChecker.getUnionTypes(s2);
                if (s2Types.size() == 1 && s2Types.containsKey(s1Name)) {
                    SchemaChecker.checkTypeEvolution(s1, s2Types.get(s1Name), parentPrefixMsg, errors, warnings, visitedSet);
                } else if (s2Types.containsKey(s1Name)) {
                    warnings.add(parentPrefixMsg + " Non-union type " + s1Name + " was changed to a union with additional types " + s2Types.keySet() + '.' + CANNOT_READ_WITH_OLD_SCHEMA);
                } else {
                    errors.add(parentPrefixMsg + " Non-union type " + s1Name + " was changed to a union that does not include the original type " + s2Types.keySet() + '.' + CANNOT_READ_WITH_EITHER_SCHEMA);
                }
            } else if (SchemaChecker.isTypePromotion(type, type2)) {
                warnings.add(parentPrefixMsg + " The type was promoted from " + (Object)((Object)type) + " to " + (Object)((Object)type2) + '.' + CANNOT_READ_WITH_OLD_SCHEMA);
            } else {
                errors.add(parentPrefixMsg + " The type was changed incompatibly from " + (Object)((Object)type) + " to " + (Object)((Object)type2) + '.' + (SchemaChecker.isTypePromotion(type2, type) ? CANNOT_READ_WITH_NEW_SCHEMA : CANNOT_READ_WITH_EITHER_SCHEMA));
            }
            return;
        }
        if (type == Schema.Type.RECORD || type == Schema.Type.ENUM || type == Schema.Type.FIXED) {
            String n1 = s1.getFullName();
            String n2 = s2.getFullName();
            if (n1 == null ? n2 != null : !n1.equals(n2)) {
                errors.add(parentPrefixMsg + " The type name was changed incompatibly from " + n1 + " to " + n2 + '.' + CANNOT_READ_WITH_EITHER_SCHEMA);
            }
            if (SchemaChecker.alreadyVisited(new SchemaPair(s1, s2), visitedSet)) {
                return;
            }
        }
        switch (type) {
            case RECORD: {
                SchemaChecker.checkRecordEvolution(s1, s2, errors, warnings, visitedSet);
                break;
            }
            case UNION: {
                String typeName;
                Map<String, Schema> s1Types = SchemaChecker.getUnionTypes(s1);
                Map<String, Schema> s2Types = SchemaChecker.getUnionTypes(s2);
                for (Map.Entry<String, Schema> entry : s1Types.entrySet()) {
                    typeName = entry.getKey();
                    if (s2Types.get(typeName) != null) continue;
                    errors.add(parentPrefixMsg + " Union type " + typeName + " was removed." + CANNOT_READ_WITH_NEW_SCHEMA);
                }
                for (Map.Entry<String, Schema> entry : s2Types.entrySet()) {
                    typeName = entry.getKey();
                    Schema t2 = entry.getValue();
                    Schema t1 = s1Types.get(typeName);
                    if (t1 == null) {
                        warnings.add(parentPrefixMsg + " Union type " + typeName + " was added." + CANNOT_READ_WITH_OLD_SCHEMA);
                        continue;
                    }
                    SchemaChecker.checkTypeEvolution(t1, t2, parentPrefixMsg, errors, warnings, visitedSet);
                }
                break;
            }
            case ARRAY: {
                SchemaChecker.checkTypeEvolution(s1.getElementType(), s2.getElementType(), parentPrefixMsg + " Array element type was changed.", errors, warnings, visitedSet);
                break;
            }
            case MAP: {
                SchemaChecker.checkTypeEvolution(s1.getValueType(), s2.getValueType(), parentPrefixMsg + " Map value type was changed.", errors, warnings, visitedSet);
                break;
            }
            case ENUM: {
                HashSet<String> removedSymbols = new HashSet<String>(s1.getEnumSymbols());
                removedSymbols.removeAll(s2.getEnumSymbols());
                if (removedSymbols.size() > 0) {
                    errors.add(parentPrefixMsg + " Enum symbols " + ((Object)removedSymbols).toString() + " were removed." + CANNOT_READ_WITH_NEW_SCHEMA);
                }
                HashSet<String> addedSymbols = new HashSet<String>(s2.getEnumSymbols());
                addedSymbols.removeAll(s1.getEnumSymbols());
                if (addedSymbols.size() <= 0) break;
                warnings.add(parentPrefixMsg + " Enum symbols " + ((Object)addedSymbols).toString() + " were added." + CANNOT_READ_WITH_OLD_SCHEMA);
                break;
            }
            case FIXED: {
                if (s1.getFixedSize() == s2.getFixedSize()) break;
                errors.add(parentPrefixMsg + " Fixed " + s1.getFullName() + " size was changed from " + s1.getFixedSize() + " to " + s2.getFixedSize() + '.' + CANNOT_READ_WITH_EITHER_SCHEMA);
                break;
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + (Object)((Object)type));
            }
        }
    }

    private static boolean isTypePromotion(Schema.Type t1, Schema.Type t2) {
        switch (t1) {
            case INT: {
                return t2 == Schema.Type.LONG || t2 == Schema.Type.FLOAT || t2 == Schema.Type.DOUBLE;
            }
            case LONG: {
                return t2 == Schema.Type.FLOAT || t2 == Schema.Type.DOUBLE;
            }
            case FLOAT: {
                return t2 == Schema.Type.DOUBLE;
            }
        }
        return false;
    }

    private static Map<String, Schema> getUnionTypes(Schema parent) {
        HashMap<String, Schema> map = new HashMap<String, Schema>();
        for (Schema s : parent.getTypes()) {
            map.put(s.getFullName(), s);
        }
        return map;
    }

    private static <T> boolean alreadyVisited(T visited, Set<T> visitedSet) {
        if (visitedSet.contains(visited)) {
            return true;
        }
        visitedSet.add(visited);
        return false;
    }

    private static class SchemaPair {
        private final Schema s1;
        private final Schema s2;

        SchemaPair(Schema s1, Schema s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SchemaPair)) {
                return false;
            }
            SchemaPair o = (SchemaPair)other;
            return this.s1 == o.s1 && this.s2 == o.s2 || this.s1 == o.s2 && this.s2 == o.s1;
        }

        public int hashCode() {
            return System.identityHashCode(this.s1) + System.identityHashCode(this.s2);
        }
    }
}

