/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.exception;

import oracle.kv.impl.async.exception.ConnectionException;

public abstract class DialogException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final boolean hasSideEffect;
    private final boolean fromRemote;

    protected DialogException(boolean hasSideEffect, boolean fromRemote, String message, Throwable cause) {
        super(message, cause);
        this.hasSideEffect = hasSideEffect;
        this.fromRemote = fromRemote;
    }

    public abstract boolean shouldBackoff();

    public boolean hasSideEffect() {
        return this.hasSideEffect;
    }

    public boolean fromRemote() {
        return this.fromRemote;
    }

    public Exception getUnderlyingException() {
        Throwable cause = this.getCause();
        if (cause instanceof ConnectionException) {
            return ((ConnectionException)cause).getUnderlyingException();
        }
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return this;
    }
}

