/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.mappings.converters;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.mappings.converters.AttributeNamePrefix;

public class AttributeNameTokenizer
implements Iterable<String> {
    public static final char SEPARATOR = '.';
    private static final String PREFIX = "prefix";
    private static final Pattern VALUE_DOT_PATTERN = Pattern.compile(AttributeNamePrefix.VALUE.getName() + "\\" + '.');
    private static final Pattern KEY_DOT_PATTERN = Pattern.compile(AttributeNamePrefix.KEY.getName() + "\\" + '.');
    private final String attributeName;

    public static String getNameAfterVersion(String attributeName) {
        Matcher matcher = VALUE_DOT_PATTERN.matcher(attributeName);
        if (matcher.find()) {
            return attributeName.substring(matcher.end());
        }
        return null;
    }

    public static String getNameAfterKey(String attributeName) {
        Matcher matcher = KEY_DOT_PATTERN.matcher(attributeName);
        if (matcher.find()) {
            return attributeName.substring(matcher.end());
        }
        return null;
    }

    public AttributeNameTokenizer(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public Iterator<String> iterator() {
        return new TokensIterator(this.attributeName);
    }

    public TokensIterator tokensIterator() {
        return new TokensIterator(this.attributeName);
    }

    public static final class TokensIterator
    implements Iterator<String> {
        private static final Pattern PREFIX_PATTERN = Pattern.compile("(?:(?<prefix>" + AttributeNamePrefix.KEY.getName() + "|" + AttributeNamePrefix.VALUE.getName() + ")\\.){0,1}([^\\.]+)");
        private static final Pattern SIMPLE_PATTERN = Pattern.compile("([^\\.]+)");
        private static final Pattern NEXT_PATTERN = Pattern.compile("\\.([^\\.]+)");
        private final Matcher matcher;
        private final AttributeNamePrefix prefix;
        private String token;

        public TokensIterator(String attributeName) {
            this(attributeName, false);
        }

        public TokensIterator(String attributeName, boolean isPrefix) {
            if (!isPrefix) {
                this.matcher = SIMPLE_PATTERN.matcher(attributeName);
                this.token = this.matcher.lookingAt() ? (this.matcher.groupCount() > 0 ? this.matcher.group(1) : null) : null;
                this.prefix = null;
            } else {
                this.matcher = PREFIX_PATTERN.matcher(attributeName);
                if (this.matcher.lookingAt()) {
                    String prefixString = this.matcher.group(AttributeNameTokenizer.PREFIX);
                    this.prefix = AttributeNamePrefix.toValue(prefixString != null ? prefixString : "");
                    this.token = this.matcher.groupCount() > 1 ? this.matcher.group(2) : null;
                } else {
                    this.prefix = AttributeNamePrefix.NULL;
                    this.token = null;
                }
            }
            this.matcher.usePattern(NEXT_PATTERN);
            this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
        }

        public AttributeNamePrefix getPrefix() {
            return this.prefix;
        }

        @Override
        public boolean hasNext() {
            return this.token != null;
        }

        @Override
        public String next() {
            String tokenToReturn = this.token;
            if (this.matcher.lookingAt()) {
                this.token = this.matcher.groupCount() > 0 ? this.matcher.group(1) : null;
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            } else {
                this.token = null;
            }
            return tokenToReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal of attribute name tokens makes no sense");
        }
    }
}

