/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.sessions.Session;

public class XMLListConverter
implements Converter {
    private XMLConversionManager conversionManager;
    private XMLCompositeDirectCollectionMapping mapping;
    private Class objectClass = null;
    private String objectClassName = null;

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.conversionManager.convertStringToList(dataValue, this.getObjectClass(), this.mapping.getContainerPolicy(), ((Field)((Object)this.mapping.getField())).getSchemaType());
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.conversionManager.convertListToString(objectValue, ((Field)((Object)this.mapping.getField())).getSchemaType());
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        this.conversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager();
        this.mapping = (XMLCompositeDirectCollectionMapping)mapping;
        try {
            if (this.getObjectClassName() != null) {
                ClassLoader loader = session.getDatasourcePlatform().getConversionManager().getLoader();
                Class aClass = AccessController.doPrivileged(new PrivilegedClassForName(this.getObjectClassName(), true, loader));
                this.setObjectClass(aClass);
            }
        }
        catch (PrivilegedActionException pae) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getObjectClassName(), pae.getException());
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String aClassName) {
        this.objectClassName = aClassName;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class aClass) {
        this.objectClass = aClass;
        if (this.objectClassName == null) {
            this.objectClassName = aClass.getName();
        }
    }
}

