/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.mapping.Joystick;
import org.eclipse.persistence.testing.models.mapping.Keyboard;

public class ConstraintOrderTest
extends TransactionalTestCase {
    protected Keyboard objectToBeWritten;

    public ConstraintOrderTest() {
        this.setDescription("Test constraints are maintained correctly for 1-m and user defined constraints.");
    }

    public void test() {
        this.objectToBeWritten = Keyboard.example1();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerNewObject((Object)this.objectToBeWritten);
        uow.registerObject((Object)Keyboard.example2());
        uow.registerObject((Object)new Joystick("Logitech", this.objectToBeWritten));
        uow.registerObject((Object)new Joystick("Intel", Keyboard.example2()));
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object objectFromDatabase = this.getSession().readObject((Object)this.objectToBeWritten);
        if (!this.compareObjects(this.objectToBeWritten, objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

