/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class InvalidIndirectionContainerClassTest
extends ExceptionTest {
    ClassDescriptor descriptor;
    OneToManyMapping mapping;
    IndirectionPolicy orgIndirectionPolicy;
    IntegrityChecker orgIntegrityChecker;

    public InvalidIndirectionContainerClassTest() {
        this.setDescription("This tests Invalid Indirection Container Class (TL-ERROR 154)");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.expectedException = DescriptorException.invalidIndirectionContainerClass((ContainerIndirectionPolicy)new ContainerIndirectionPolicy(), null);
        this.descriptor = this.getSession().getDescriptor(Employee.class);
        this.mapping = (OneToManyMapping)this.descriptor.getMappingForAttributeName("phoneNumbers");
        this.orgIndirectionPolicy = this.mapping.getIndirectionPolicy();
        this.mapping.useContainerIndirection(Vector.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.mapping.setIndirectionPolicy(this.orgIndirectionPolicy);
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.mapping.initialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

