/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.datatypes;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.datatypes.DataTypesTableCreator;
import org.eclipse.persistence.testing.models.jpa.datatypes.WrapperTypes;

public class BooleanJUnitTestCase
extends JUnitTestCase {
    public BooleanJUnitTestCase() {
    }

    public BooleanJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Boolean DataTypes");
        suite.addTest((Test)new BooleanJUnitTestCase("testSetup"));
        suite.addTest((Test)new BooleanJUnitTestCase("testCreateWrapperTypes"));
        suite.addTest((Test)new BooleanJUnitTestCase("testBoolean"));
        return suite;
    }

    public void testSetup() {
        new DataTypesTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testCreateWrapperTypes() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        WrapperTypes[] wrapperTypes = new WrapperTypes[]{new WrapperTypes(BigDecimal.ZERO, BigInteger.ZERO, Boolean.FALSE, Byte.valueOf("0"), Character.valueOf('A'), Short.valueOf("0"), Integer.valueOf(0), Long.valueOf(0L), Float.valueOf(0.0f), Double.valueOf(0.0), "A String"), new WrapperTypes(BigDecimal.ONE, BigInteger.ONE, Boolean.TRUE, Byte.valueOf("1"), Character.valueOf('B'), Short.valueOf("1"), Integer.valueOf(1), Long.valueOf(1L), Float.valueOf(1.0f), Double.valueOf(1.0), "B String"), new WrapperTypes(new BigDecimal(2), new BigInteger("2"), Boolean.FALSE, Byte.valueOf("2"), Character.valueOf('C'), Short.valueOf("2"), Integer.valueOf(2), Long.valueOf(2L), Float.valueOf(2.0f), Double.valueOf(2.0), "C String"), new WrapperTypes(new BigDecimal(3), new BigInteger("3"), Boolean.TRUE, Byte.valueOf("3"), Character.valueOf('D'), Short.valueOf("3"), Integer.valueOf(3), Long.valueOf(3L), Float.valueOf(3.0f), Double.valueOf(3.0), "D String")};
        for (WrapperTypes wrapperType : wrapperTypes) {
            em.persist((Object)wrapperType);
        }
        this.commitTransaction(em);
    }

    public void testBoolean() {
        EntityManager em = this.createEntityManager();
        try {
            Query q = em.createQuery("SELECT wt.booleanData FROM WrapperTypes wt");
            List result = q.getResultList();
            BooleanJUnitTestCase.assertTrue((String)"Not all boolean rows are selected", (result.size() == 4 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            this.closeEntityManager(em);
            throw e;
        }
    }
}

