/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.xml.bind.Marshaller;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.oxm.XMLMarshalListener;

public class JAXBMarshalListener
implements XMLMarshalListener {
    private Marshaller.Listener listener;
    private Map classBasedMarshalEvents;
    private Marshaller marshaller;
    private JAXBContext jaxbContext;

    public JAXBMarshalListener(JAXBContext context, Marshaller marshaller) {
        this.jaxbContext = context;
        this.marshaller = marshaller;
    }

    public void setListener(Marshaller.Listener jaxbListener) {
        this.listener = jaxbListener;
    }

    public Marshaller.Listener getListener() {
        return this.listener;
    }

    public void beforeMarshal(Object obj) {
        MarshalCallback callback;
        if (this.classBasedMarshalEvents != null && (callback = (MarshalCallback)this.classBasedMarshalEvents.get(obj.getClass().getName())) != null && callback.getBeforeMarshalCallback() != null) {
            PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod((Method)callback.getBeforeMarshalCallback(), (Object)obj, (Object[])new Object[]{this.marshaller}), ex -> XMLMarshalException.marshalException((Exception)ex));
        }
        if (this.listener != null) {
            this.listener.beforeMarshal(obj instanceof Root ? this.jaxbContext.createJAXBElementFromXMLRoot((Root)obj, ((Root)obj).getDeclaredType()) : obj);
        }
    }

    public void afterMarshal(Object obj) {
        MarshalCallback callback;
        if (this.classBasedMarshalEvents != null && (callback = (MarshalCallback)this.classBasedMarshalEvents.get(obj.getClass().getName())) != null && callback.getAfterMarshalCallback() != null) {
            PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod((Method)callback.getAfterMarshalCallback(), (Object)obj, (Object[])new Object[]{this.marshaller}), ex -> XMLMarshalException.marshalException((Exception)ex));
        }
        if (this.listener != null) {
            this.listener.afterMarshal(obj instanceof Root ? this.jaxbContext.createJAXBElementFromXMLRoot((Root)obj, ((Root)obj).getDeclaredType()) : obj);
        }
    }

    public void setClassBasedMarshalEvents(Map events) {
        this.classBasedMarshalEvents = events;
    }
}

