/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa;

import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.ServerPlatformException;
import org.eclipse.persistence.internal.jpa.IsolatedHashMap;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;

public class IsolatedHashMapTest
extends JUnitTestCase {
    private static final char SEPARATOR = '$';
    private static final String DEFAULT_PARTITION_ID = "0";
    private static final Map<String, String> map = IsolatedHashMap.newMap();
    private static final ServerPlatform serverPlatform;
    private static final boolean supportPartitions;
    private static final String[] sessionNameTemplates;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("IsolatedHashMapTest");
        suite.addTest((Test)new IsolatedHashMapTest("testIsolationInRealContext"));
        return suite;
    }

    private static String[] initSessionNames(String partitionId) {
        int count = sessionNameTemplates.length;
        String[] sessionNames = new String[count];
        int maxLength = 0;
        for (int i = 0; i < count; ++i) {
            int sessionNameTemplateLength = sessionNameTemplates[i].length();
            if (sessionNameTemplateLength <= maxLength) continue;
            maxLength = sessionNameTemplateLength;
        }
        StringBuilder sb = new StringBuilder(maxLength += 1 + partitionId.length());
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.delete(0, sb.length() - 1);
            }
            sb.append(sessionNameTemplates[i]);
            sb.append('$');
            sb.append(partitionId);
            sessionNames[i] = sb.toString();
        }
        return sessionNames;
    }

    public IsolatedHashMapTest() {
    }

    public IsolatedHashMapTest(String name) {
        super(name);
    }

    private static void doIsolationCheck(Map<String, String> map, String partitionId, SessionLog log) {
        String[] sessionNames = IsolatedHashMapTest.initSessionNames(partitionId);
        HashSet<String> namesSet = new HashSet<String>(sessionNames.length);
        log.log(5, "  Partition ID: " + partitionId);
        for (String sessionName : sessionNames) {
            log.log(5, "    Adding session name: " + sessionName);
            map.put(sessionName, sessionName);
            namesSet.add(sessionName);
        }
        int mapSize = map.size();
        log.log(5, "  Checking map size: session names count = " + sessionNames.length + ", map size = " + mapSize);
        IsolatedHashMapTest.assertEquals((String)"Map size does not match session names count.", (int)sessionNames.length, (int)mapSize);
        for (String sessionName : map.keySet()) {
            log.log(5, "    Getting and checking session name: " + sessionName);
            IsolatedHashMapTest.assertTrue((String)("Session name " + sessionName + "was not stored in current partition context."), (boolean)namesSet.contains(sessionName));
        }
    }

    public void testIsolationInRealContext() {
        SessionLog log = IsolatedHashMapTest.getServerSession().getSessionLog();
        log.log(5, "IsolatedHashMapTest.testIsolationInRealContext()");
        IsolatedHashMapTest.doIsolationCheck(map, supportPartitions ? serverPlatform.getPartitionID() : DEFAULT_PARTITION_ID, log);
    }

    static {
        sessionNameTemplates = new String[]{"", DEFAULT_PARTITION_ID, "mySession", "EclipseLink"};
        String platformClass = ServerPlatformUtils.detectServerPlatform(null);
        ServerPlatform sp = null;
        try {
            sp = platformClass != null ? ServerPlatformUtils.createServerPlatform(null, (String)platformClass, (ClassLoader)SessionManager.class.getClassLoader()) : null;
        }
        catch (ServerPlatformException serverPlatformException) {
            // empty catch block
        }
        serverPlatform = sp;
        supportPartitions = serverPlatform != null ? serverPlatform.usesPartitions() : false;
    }
}

