/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass2;

public class SequenceStringExistingPKTest
extends AutoVerifyTestCase {
    public static final String TEST_NAME = "SequenceStringExistingPKTest";
    SeqTestClass2 testObject;
    String originalPK;
    Exception storedException;

    public SequenceStringExistingPKTest() {
        this.setDescription("Tests that existing String Primary Key is not overridden by sequencing.");
    }

    public void reset() {
        if (this.testObject != null) {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.deleteObject((Object)this.testObject);
            uow.commit();
            this.testObject = null;
        }
    }

    protected void setup() {
        if (this.getSession().getPlatform().getDefaultSequence().shouldAcquireValueAfterInsert()) {
            throw new TestWarningException("This test doesn't work with *after insert* sequencing.");
        }
        if (this.getSession().getPlatform().isDB2()) {
            throw new TestWarningException("DB2 does not support inserting a numeric value into a String column.");
        }
        if (this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere()) {
            throw new TestWarningException("Sybase and SQLAnyWhere do not support inserting a numeric value into a String column.");
        }
        this.storedException = null;
        this.testObject = new SeqTestClass2();
        this.testObject.setTest1("Sequence Test Object");
        this.testObject.setTest2(TEST_NAME);
        try {
            this.originalPK = this.getSession().getNextSequenceNumberValue(SeqTestClass2.class).toString();
        }
        catch (Exception ex) {
            throw new TestWarningException("Failed to obtain original value for PK");
        }
    }

    protected void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            SeqTestClass2 testObjectClone = (SeqTestClass2)uow.registerObject((Object)this.testObject);
            testObjectClone.setPkey(this.originalPK);
            uow.commit();
        }
        catch (Exception e) {
            this.setStoredException((Exception)((Object)new TestErrorException("Unable to assign String sequence number in test:SequenceStringExistingPKTest")));
            return;
        }
    }

    protected void verify() throws Exception {
        if (this.storedException != null) {
            throw this.storedException;
        }
        if (!this.testObject.getPkey().equals(this.originalPK)) {
            throw new TestErrorException("Original String PK has been overridden by sequencing.");
        }
    }

    protected void setStoredException(Exception e) {
        if (this.storedException == null) {
            this.storedException = e;
        }
    }
}

