/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.io.Exceptions;
import com.sun.corba.ee.impl.io.InputStreamHook;
import com.sun.corba.ee.impl.io.ObjectStreamClass;
import com.sun.corba.ee.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.ee.impl.io.ObjectStreamField;
import com.sun.corba.ee.impl.io.ValueHandlerImpl;
import com.sun.corba.ee.impl.io.ValueUtility;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.trace.ValueHandlerRead;
import com.sun.org.omg.CORBA.AttributeDescription;
import com.sun.org.omg.CORBA.ExceptionDescription;
import com.sun.org.omg.CORBA.OperationDescription;
import com.sun.org.omg.CORBA.ParameterDescription;
import com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rmi.CORBA.ValueHandler;
import org.glassfish.pfl.basic.logex.OperationTracer;
import org.glassfish.pfl.basic.reflection.Bridge;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

@ValueHandlerRead
public class IIOPInputStream
extends InputStreamHook {
    private static Bridge bridge = AccessController.doPrivileged(new PrivilegedAction<Bridge>(){

        @Override
        public Bridge run() {
            return Bridge.get();
        }
    });
    private ValueMember[] defaultReadObjectFVDMembers = null;
    private InputStream orbStream;
    private CodeBase cbSender;
    private ValueHandlerImpl vhandler;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private Class<?> currentClass = null;
    private int recursionDepth = 0;
    private int simpleReadDepth = 0;
    ActiveRecursionManager activeRecursionMgr = new ActiveRecursionManager();
    private IOException abortIOException = null;
    private ClassNotFoundException abortClassNotFoundException = null;
    private List<Object> callbacks;
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private static final String kEmptyStr = "";
    public static final TypeCode kRemoteTypeCode = ORB.init().get_primitive_tc(TCKind.tk_objref);
    public static final TypeCode kValueTypeCode = ORB.init().get_primitive_tc(TCKind.tk_value);
    private static final boolean useFVDOnly = false;
    private byte streamFormatVersion;

    @Override
    protected byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    @InfoMethod
    private void streamFormatVersionInfo(byte sfv) {
    }

    @ValueHandlerRead
    private void readFormatVersion() throws IOException {
        this.streamFormatVersion = this.orbStream.read_octet();
        this.streamFormatVersionInfo(this.streamFormatVersion);
        if (this.streamFormatVersion < 1 || this.streamFormatVersion > this.vhandler.getMaximumStreamFormatVersion()) {
            MARSHAL sysex = omgWrapper.unsupportedFormatVersion();
            throw new IOException("Unsupported format version: " + this.streamFormatVersion, sysex);
        }
        if (this.streamFormatVersion == 2 && !(this.orbStream instanceof ValueInputStream)) {
            BAD_PARAM sysex = omgWrapper.notAValueinputstream();
            throw new IOException("Not a ValueInputStream", sysex);
        }
    }

    public static void setTestFVDFlag(boolean val) {
    }

    public IIOPInputStream() throws IOException {
        this.resetStream();
    }

    final void setOrbStream(InputStream os) {
        this.orbStream = os;
    }

    @Override
    final InputStream getOrbStream() {
        return this.orbStream;
    }

    public final void setSender(CodeBase cb) {
        this.cbSender = cb;
    }

    public final CodeBase getSender() {
        return this.cbSender;
    }

    public final void setValueHandler(ValueHandler vh) {
        this.vhandler = (ValueHandlerImpl)vh;
    }

    public final ValueHandler getValueHandler() {
        return this.vhandler;
    }

    @InfoMethod
    private void recursionDepthInfo(int rd) {
    }

    @ValueHandlerRead
    final void increaseRecursionDepth() {
        ++this.recursionDepth;
        this.recursionDepthInfo(this.recursionDepth);
    }

    @ValueHandlerRead
    final int decreaseRecursionDepth() {
        --this.recursionDepth;
        this.recursionDepthInfo(this.recursionDepth);
        return this.recursionDepth;
    }

    @ValueHandlerRead
    public final synchronized Object readObjectDelegate() throws ClassNotFoundException, OptionalDataException, StreamCorruptedException, IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_abstract_interface();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, true);
            throw marshalException;
        }
        catch (IndirectionException cdrie) {
            return this.activeRecursionMgr.getObject(cdrie.offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueHandlerRead
    final synchronized Object simpleReadObject(Class clz, ClassInfoCache.ClassInfo cinfo, String repositoryID, CodeBase sender, int offset) {
        Object prevObject = this.currentObject;
        ObjectStreamClass prevClassDesc = this.currentClassDesc;
        Class<?> prevClass = this.currentClass;
        byte oldStreamFormatVersion = this.streamFormatVersion;
        ++this.simpleReadDepth;
        Object obj = null;
        OperationTracer.startReadValue((String)clz.getName());
        try {
            obj = this.vhandler.useFullValueDescription(clz, repositoryID) ? this.inputObjectUsingFVD(clz, cinfo, repositoryID, sender, offset) : this.inputObject(clz, cinfo, repositoryID, sender, offset);
            obj = this.currentClassDesc.readResolve(obj);
        }
        catch (ClassNotFoundException cnfe) {
            bridge.throwException((Throwable)cnfe);
            Object var12_14 = null;
            return var12_14;
        }
        catch (IOException ioe) {
            bridge.throwException((Throwable)ioe);
            Object var12_15 = null;
            return var12_15;
        }
        finally {
            --this.simpleReadDepth;
            this.currentObject = prevObject;
            this.currentClassDesc = prevClassDesc;
            this.currentClass = prevClass;
            this.streamFormatVersion = oldStreamFormatVersion;
            OperationTracer.endReadValue();
        }
        IOException exIOE = this.abortIOException;
        if (this.simpleReadDepth == 0) {
            this.abortIOException = null;
        }
        if (exIOE != null) {
            bridge.throwException((Throwable)exIOE);
            return null;
        }
        ClassNotFoundException exCNF = this.abortClassNotFoundException;
        if (this.simpleReadDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (exCNF != null) {
            bridge.throwException((Throwable)exCNF);
            return null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueHandlerRead
    public final synchronized void simpleSkipObject(String repositoryID, CodeBase sender) {
        Object prevObject = this.currentObject;
        ObjectStreamClass prevClassDesc = this.currentClassDesc;
        Class<?> prevClass = this.currentClass;
        byte oldStreamFormatVersion = this.streamFormatVersion;
        ++this.simpleReadDepth;
        Object obj = null;
        try {
            this.skipObjectUsingFVD(repositoryID, sender);
        }
        catch (ClassNotFoundException cnfe) {
            bridge.throwException((Throwable)cnfe);
            return;
        }
        catch (IOException ioe) {
            bridge.throwException((Throwable)ioe);
            return;
        }
        finally {
            --this.simpleReadDepth;
            this.streamFormatVersion = oldStreamFormatVersion;
            this.currentObject = prevObject;
            this.currentClassDesc = prevClassDesc;
            this.currentClass = prevClass;
        }
        IOException exIOE = this.abortIOException;
        if (this.simpleReadDepth == 0) {
            this.abortIOException = null;
        }
        if (exIOE != null) {
            bridge.throwException((Throwable)exIOE);
            return;
        }
        ClassNotFoundException exCNF = this.abortClassNotFoundException;
        if (this.simpleReadDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (exCNF != null) {
            bridge.throwException((Throwable)exCNF);
            return;
        }
    }

    @Override
    protected final Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return this.readObjectDelegate();
    }

    @InfoMethod
    private void usingLocalFieldsToRead() {
    }

    @Override
    @ValueHandlerRead
    public final synchronized void defaultReadObjectDelegate() {
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultReadObjectDelegate");
            }
            if (!this.currentClassDesc.forClass().isAssignableFrom(this.currentObject.getClass())) {
                throw new IOException("Object Type mismatch");
            }
            if (this.defaultReadObjectFVDMembers != null && this.defaultReadObjectFVDMembers.length > 0) {
                ValueMember[] valueMembers = this.defaultReadObjectFVDMembers;
                this.defaultReadObjectFVDMembers = null;
                this.displayValueMembers(valueMembers);
                this.inputClassFields(this.currentObject, this.currentClass, this.currentClassDesc, valueMembers, this.cbSender);
            } else {
                this.usingLocalFieldsToRead();
                ObjectStreamField[] fields = this.currentClassDesc.getFieldsNoCopy();
                if (fields.length > 0) {
                    this.inputClassFields(this.currentObject, this.currentClass, fields, this.cbSender);
                }
            }
        }
        catch (NotActiveException nae) {
            bridge.throwException((Throwable)nae);
        }
        catch (IOException | ClassNotFoundException ioe) {
            bridge.throwException((Throwable)ioe);
        }
    }

    public final boolean enableResolveObjectDelegate(boolean enable) {
        return false;
    }

    @Override
    public final void mark(int readAheadLimit) {
        this.orbStream.mark(readAheadLimit);
    }

    @Override
    public final boolean markSupported() {
        return this.orbStream.markSupported();
    }

    @Override
    public final void reset() throws IOException {
        try {
            this.orbStream.reset();
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    public final int available() throws IOException {
        return 0;
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    @ValueHandlerRead
    public final int read() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_octet() & 0xFF;
        }
        catch (MARSHAL marshalException) {
            if (marshalException.minor == OMGSystemException.RMIIIOP_OPTIONAL_DATA_INCOMPATIBLE) {
                this.setState(IN_READ_OBJECT_NO_MORE_OPT_DATA);
                return -1;
            }
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final int read(byte[] data, int offset, int length) throws IOException {
        try {
            this.readObjectState.readData(this);
            this.orbStream.read_octet_array(data, offset, length);
            return length;
        }
        catch (MARSHAL marshalException) {
            if (marshalException.minor == OMGSystemException.RMIIIOP_OPTIONAL_DATA_INCOMPATIBLE) {
                this.setState(IN_READ_OBJECT_NO_MORE_OPT_DATA);
                return -1;
            }
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final boolean readBoolean() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_boolean();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final byte readByte() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_octet();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final char readChar() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_wchar();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final double readDouble() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_double();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final float readFloat() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_float();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    @Override
    @ValueHandlerRead
    public final void readFully(byte[] data, int offset, int size) throws IOException {
        try {
            this.readObjectState.readData(this);
            this.orbStream.read_octet_array(data, offset, size);
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final int readInt() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_long();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    public final String readLine() throws IOException {
        throw Exceptions.self.readLineMethodNotSupported();
    }

    @Override
    @ValueHandlerRead
    public final long readLong() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_longlong();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final short readShort() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_short();
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    protected final void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    @Override
    @ValueHandlerRead
    public final int readUnsignedByte() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_octet() & 0xFF;
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    @ValueHandlerRead
    public final int readUnsignedShort() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.orbStream.read_ushort() & 0xFFFF;
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @ValueHandlerRead
    protected String internalReadUTF(org.omg.CORBA.portable.InputStream stream) {
        return stream.read_wstring();
    }

    @Override
    @ValueHandlerRead
    public final String readUTF() throws IOException {
        try {
            this.readObjectState.readData(this);
            return this.internalReadUTF((org.omg.CORBA.portable.InputStream)this.orbStream);
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    private void handleOptionalDataMarshalException(MARSHAL marshalException, boolean objectRead) throws IOException {
        if (marshalException.minor == OMGSystemException.RMIIIOP_OPTIONAL_DATA_INCOMPATIBLE) {
            IOException result = !objectRead ? new EOFException("No more optional data") : bridge.newOptionalDataExceptionForSerialization(true);
            result.initCause(marshalException);
            this.setState(IN_READ_OBJECT_NO_MORE_OPT_DATA);
            throw result;
        }
    }

    @Override
    public final synchronized void registerValidation(ObjectInputValidation obj, int prio) {
        throw Exceptions.self.registerValidationNotSupport();
    }

    @Override
    protected final Class<?> resolveClass(java.io.ObjectStreamClass v) throws IOException {
        throw Exceptions.self.resolveClassNotSupported();
    }

    @Override
    protected final Object resolveObject(Object obj) throws IOException {
        throw Exceptions.self.resolveObjectNotSupported();
    }

    @Override
    @ValueHandlerRead
    public final int skipBytes(int len) throws IOException {
        try {
            this.readObjectState.readData(this);
            byte[] buf = new byte[len];
            this.orbStream.read_octet_array(buf, 0, len);
            return len;
        }
        catch (MARSHAL marshalException) {
            this.handleOptionalDataMarshalException(marshalException, false);
            throw marshalException;
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @ValueHandlerRead
    private Object handleEnum(Class clz, ClassInfoCache.ClassInfo cinfo) throws IOException {
        String value = (String)((Object)this.orbStream.read_value(String.class));
        Class enumClass = ClassInfoCache.getEnumClass(cinfo, clz);
        if (enumClass == null) {
            throw Exceptions.self.couldNotUnmarshalEnum(clz.getName(), value);
        }
        return Enum.valueOf(enumClass, value);
    }

    @InfoMethod
    private void readingExternalizable() {
    }

    @InfoMethod
    private void readingSerializable() {
    }

    @InfoMethod
    private void newInstanceInfo(Class<?> cls) {
    }

    @InfoMethod
    private void readingDataForClass(Class<?> cls) {
    }

    @InfoMethod
    private void classHasWriteObject(boolean flag) {
    }

    @InfoMethod
    private void currentClassInfo(ObjectStreamClass ocs, Class<?> cls) {
    }

    @InfoMethod
    private void matchingClassInfo(Class<?> cls) {
    }

    @ValueHandlerRead
    private void callReadExternal(Externalizable ext) throws IOException, ClassNotFoundException {
        InputStreamHook.ReadObjectState oldState = this.readObjectState;
        this.setState(DEFAULT_STATE);
        try {
            ext.readExternal(this);
        }
        finally {
            this.setState(oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @ValueHandlerRead
    private synchronized Object inputObject(Class clz, ClassInfoCache.ClassInfo cinfo, String repositoryID, CodeBase sender, int offset) throws IOException, ClassNotFoundException {
        block32: {
            spBase = this.spClass;
            try {
                this.currentClassDesc = ObjectStreamClass.lookup(clz);
                this.currentClass = this.currentClassDesc.forClass();
                if (cinfo.isEnum()) {
                    var7_7 = this.handleEnum(clz, cinfo);
                    return var7_7;
                }
                if (this.currentClassDesc.isExternalizable()) {
                    this.readingExternalizable();
                    try {
                        this.newInstanceInfo(this.currentClass);
                        v0 = this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                        if (this.currentObject != null) {
                            this.activeRecursionMgr.addObject(offset, this.currentObject);
                            this.readFormatVersion();
                            this.callReadExternal((Externalizable)this.currentObject);
                        }
                        break block32;
                    }
                    catch (InvocationTargetException e) {
                        exc = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                        exc.initCause(e);
                        throw exc;
                    }
                    catch (UnsupportedOperationException e) {
                        exc = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                        exc.initCause(e);
                        throw exc;
                    }
                    catch (InstantiationException e) {
                        exc = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                        exc.initCause(e);
                        throw exc;
                    }
                }
                this.readingSerializable();
                currdesc = this.currentClassDesc;
                currclass = this.currentClass;
                spBase = this.spClass;
                if (this.currentClass.getName().equals("java.lang.String")) {
                    var9_16 = this.readUTF();
                    return var9_16;
                }
                currclass = this.currentClass;
                for (currdesc = this.currentClassDesc; currdesc != null && currdesc.isSerializable(); currdesc = currdesc.getSuperclass()) {
                    cc = currdesc.forClass();
                    this.currentClassInfo(currdesc, cc);
                    for (cl = currclass; cl != null; cl = cl.getSuperclass()) {
                        if (cc != cl) continue;
                        this.matchingClassInfo(cl);
                        break;
                    }
                    ++this.spClass;
                    if (this.spClass >= this.classes.length) {
                        newlen = this.classes.length * 2;
                        newclasses = new Class[newlen];
                        newclassdesc = new ObjectStreamClass[newlen];
                        System.arraycopy(this.classes, 0, newclasses, 0, this.classes.length);
                        System.arraycopy(this.classdesc, 0, newclassdesc, 0, this.classes.length);
                        this.classes = newclasses;
                        this.classdesc = newclassdesc;
                    }
                    if (cl == null) {
                        this.classdesc[this.spClass] = currdesc;
                        this.classes[this.spClass] = null;
                        continue;
                    }
                    this.classdesc[this.spClass] = currdesc;
                    this.classes[this.spClass] = cl;
                    currclass = cl.getSuperclass();
                }
                try {
                    this.newInstanceInfo(this.currentClass);
                    this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                    this.activeRecursionMgr.addObject(offset, this.currentObject);
                }
                catch (InvocationTargetException e) {
                    exc = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                    exc.initCause(e);
                    throw exc;
                }
                catch (UnsupportedOperationException e) {
                    exc = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                    exc.initCause(e);
                    throw exc;
                }
                catch (InstantiationException e) {
                    exc = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                    exc.initCause(e);
                    throw exc;
                }
                this.spClass = this.spClass;
                while (this.spClass > spBase) {
                    this.currentClassDesc = this.classdesc[this.spClass];
                    this.currentClass = this.classes[this.spClass];
                    this.readingDataForClass(this.currentClass);
                    if (this.classes[this.spClass] != null) {
                        oldState = this.readObjectState;
                        this.setState(IIOPInputStream.DEFAULT_STATE);
                        try {
                            if (this.currentClassDesc.hasWriteObject()) {
                                this.classHasWriteObject(true);
                                this.readFormatVersion();
                                calledDefaultWriteObject = this.readDefaultWriteObjectCalledFlag();
                                this.readObjectState.beginUnmarshalCustomValue(this, calledDefaultWriteObject, this.currentClassDesc.getReadObjectMethod() != null);
                            } else {
                                this.classHasWriteObject(false);
                                if (this.currentClassDesc.hasReadObject()) {
                                    this.setState(IIOPInputStream.IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED);
                                }
                            }
                            if (!(this.invokeObjectReader(this.currentClassDesc, this.currentObject, this.currentClass, null) && this.readObjectState != IIOPInputStream.IN_READ_OBJECT_DEFAULTS_SENT || (fields = this.currentClassDesc.getFieldsNoCopy()).length <= 0)) {
                                this.inputClassFields(this.currentObject, this.currentClass, fields, sender);
                            }
                            if (!this.currentClassDesc.hasWriteObject()) ** GOTO lbl114
                            this.readObjectState.endUnmarshalCustomValue(this);
                        }
                        finally {
                            this.setState(oldState);
                        }
                    } else {
                        fields = this.currentClassDesc.getFieldsNoCopy();
                        if (fields.length > 0) {
                            this.inputClassFields(null, this.currentClass, fields, sender);
                        }
                    }
lbl114:
                    // 5 sources

                    --this.spClass;
                }
            }
            finally {
                this.spClass = spBase;
                this.activeRecursionMgr.removeObject(offset);
            }
        }
        return this.currentObject;
    }

    private boolean readDefaultWriteObjectCalledFlag() throws IOException {
        boolean sentDefaultWriteObjectCalled = this.readBoolean();
        if (this.isDateClassWorkaroundRequired()) {
            return this.getSimulatedDefaultWriteObjectCalledFlag();
        }
        return sentDefaultWriteObjectCalled;
    }

    private boolean isDateClassWorkaroundRequired() {
        return this.currentClassDesc.getName().equals(Date.class.getName());
    }

    private boolean getSimulatedDefaultWriteObjectCalledFlag() {
        return this.isJdk9_orLater();
    }

    private boolean isJdk9_orLater() {
        return !System.getProperty("java.version").startsWith("1.");
    }

    @InfoMethod
    private void fullValueDescriptorsInfo(List<FullValueDescription> fvds) {
    }

    @ValueHandlerRead
    private List<FullValueDescription> getOrderedDescriptions(String repositoryID, CodeBase sender) {
        ArrayList<FullValueDescription> descs = new ArrayList<FullValueDescription>();
        if (sender == null) {
            return descs;
        }
        FullValueDescription aFVD = sender.meta(repositoryID);
        while (aFVD != null) {
            descs.add(0, aFVD);
            if (aFVD.base_value != null && !kEmptyStr.equals(aFVD.base_value)) {
                aFVD = sender.meta(aFVD.base_value);
                continue;
            }
            return descs;
        }
        this.fullValueDescriptorsInfo(descs);
        return descs;
    }

    private String displayFVD(FullValueDescription fvd) {
        StringBuilder sb = new StringBuilder();
        sb.append("FVD(");
        sb.append("\n\tname=");
        sb.append(fvd.name);
        sb.append("\n\tid=");
        sb.append(fvd.id);
        sb.append("\n\tis_abstract=");
        sb.append(fvd.is_abstract);
        sb.append("\n\tis_custom=");
        sb.append(fvd.is_custom);
        sb.append("\n\tdefined_in=");
        sb.append(fvd.defined_in);
        sb.append("\n\tversion=");
        sb.append(fvd.version);
        sb.append("\n\tis_truncatable=");
        sb.append(fvd.is_truncatable);
        sb.append("\n\tbase_value=");
        sb.append(fvd.base_value);
        int ctr = 0;
        sb.append("\n\toperations:");
        for (OperationDescription operationDescription : fvd.operations) {
            sb.append("\n\t    [");
            sb.append(ctr++);
            sb.append("]");
            sb.append("\n\t\tname=");
            sb.append(operationDescription.name);
            sb.append("\n\t\tid=");
            sb.append(operationDescription.id);
            sb.append("\n\t\tdefined_in=");
            sb.append(operationDescription.defined_in);
            sb.append("\n\t\tversion=");
            sb.append(operationDescription.version);
            sb.append("\n\t\tmode=");
            sb.append(operationDescription.mode);
            int ctr2 = 0;
            sb.append("\n\t\tcontexts=");
            for (String str : operationDescription.contexts) {
                sb.append("\n\t\t    [");
                sb.append(ctr2++);
                sb.append("]");
                sb.append("\n\t\t");
                sb.append(str);
            }
            ctr2 = 0;
            sb.append("\n\t\tparameters");
            for (ParameterDescription pdesc : operationDescription.parameters) {
                sb.append("\n\t\t    [");
                sb.append(ctr2++);
                sb.append("]");
                sb.append("\n\t\t\tname=");
                sb.append(pdesc.name);
                sb.append("\n\t\t\tmode=");
                sb.append(pdesc.mode);
            }
            ctr2 = 0;
            sb.append("\n\t\texceptions");
            for (ExceptionDescription edesc : operationDescription.exceptions) {
                sb.append("\n\t\t    [");
                sb.append(ctr2++);
                sb.append("]");
                sb.append("\n\t\t\tname=");
                sb.append(edesc.name);
                sb.append("\n\t\t\tid=");
                sb.append(edesc.id);
                sb.append("\n\t\t\tdefined_in=");
                sb.append(edesc.defined_in);
                sb.append("\n\t\t\tversion=");
                sb.append(edesc.version);
            }
        }
        ctr = 0;
        sb.append("\n\tattributes:");
        for (AttributeDescription attributeDescription : fvd.attributes) {
            sb.append("\n\t    [");
            sb.append(ctr++);
            sb.append("]");
            sb.append("\n\t\t\tname=");
            sb.append(attributeDescription.name);
            sb.append("\n\t\t\tid=");
            sb.append(attributeDescription.id);
            sb.append("\n\t\t\tdefined_in=");
            sb.append(attributeDescription.defined_in);
            sb.append("\n\t\t\tversion=");
            sb.append(attributeDescription.version);
            sb.append("\n\t\t\tmode=");
            sb.append(attributeDescription.mode);
        }
        ctr = 0;
        sb.append("\n\tmembers:");
        for (ValueMember valueMember : fvd.members) {
            sb.append("\n\t    [");
            sb.append(ctr++);
            sb.append("]");
            sb.append("\n\t\tname=");
            sb.append(valueMember.name);
            sb.append("\n\t\tid=");
            sb.append(valueMember.id);
            sb.append("\n\t\tdefined_in=");
            sb.append(valueMember.defined_in);
            sb.append("\n\t\tversion=");
            sb.append(valueMember.version);
            sb.append("\n\t\taccess=");
            sb.append(valueMember.access);
        }
        ctr = 0;
        sb.append("\n\tsupported_interfaces:");
        for (String string : fvd.supported_interfaces) {
            sb.append("\n\t    [");
            sb.append(ctr++);
            sb.append("]");
            sb.append("\n\t\t");
            sb.append(string);
        }
        ctr = 0;
        sb.append("\n\tabstract_base_values:");
        for (String string : fvd.abstract_base_values) {
            sb.append("\n\t    [");
            sb.append(ctr++);
            sb.append("]");
            sb.append("\n\t\t");
            sb.append(string);
        }
        sb.append("\n)");
        return sb.toString();
    }

    @InfoMethod
    private void readingDataUsingFVD(FullValueDescription fvd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueHandlerRead
    private synchronized Object inputObjectUsingFVD(Class clz, ClassInfoCache.ClassInfo cinfo, String repositoryID, CodeBase sender, int offset) throws IOException, ClassNotFoundException {
        block40: {
            int spBase = this.spClass;
            try {
                FullValueDescription fvd;
                InvalidClassException exc;
                this.currentClassDesc = ObjectStreamClass.lookup(clz);
                this.currentClass = this.currentClassDesc.forClass();
                if (cinfo.isEnum()) {
                    Object object = this.handleEnum(clz, cinfo);
                    return object;
                }
                if (this.currentClassDesc.isExternalizable()) {
                    this.readingExternalizable();
                    try {
                        this.newInstanceInfo(this.currentClass);
                        Object object = this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                        if (this.currentObject != null) {
                            this.activeRecursionMgr.addObject(offset, this.currentObject);
                            this.readFormatVersion();
                            this.callReadExternal((Externalizable)this.currentObject);
                        }
                        break block40;
                    }
                    catch (InvocationTargetException e) {
                        InvalidClassException exc2 = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                        exc2.initCause(e);
                        throw exc2;
                    }
                    catch (UnsupportedOperationException e) {
                        InvalidClassException exc3 = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                        exc3.initCause(e);
                        throw exc3;
                    }
                    catch (InstantiationException e) {
                        InvalidClassException exc4 = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                        exc4.initCause(e);
                        throw exc4;
                    }
                }
                this.readingSerializable();
                ObjectStreamClass currdesc = this.currentClassDesc;
                Class currclass = this.currentClass = clz;
                spBase = this.spClass;
                currclass = this.currentClass;
                for (currdesc = this.currentClassDesc; currdesc != null && currdesc.isSerializable(); currdesc = currdesc.getSuperclass()) {
                    Class cl;
                    Class<?> cc = currdesc.forClass();
                    this.currentClassInfo(currdesc, cc);
                    for (cl = currclass; cl != null; cl = cl.getSuperclass()) {
                        if (cc != cl) continue;
                        this.matchingClassInfo(cl);
                        break;
                    }
                    ++this.spClass;
                    if (this.spClass >= this.classes.length) {
                        int newlen = this.classes.length * 2;
                        Class[] newclasses = new Class[newlen];
                        ObjectStreamClass[] newclassdesc = new ObjectStreamClass[newlen];
                        System.arraycopy(this.classes, 0, newclasses, 0, this.classes.length);
                        System.arraycopy(this.classdesc, 0, newclassdesc, 0, this.classes.length);
                        this.classes = newclasses;
                        this.classdesc = newclassdesc;
                    }
                    if (cl == null) {
                        this.classdesc[this.spClass] = currdesc;
                        this.classes[this.spClass] = null;
                        continue;
                    }
                    this.classdesc[this.spClass] = currdesc;
                    this.classes[this.spClass] = cl;
                    currclass = cl.getSuperclass();
                }
                try {
                    this.newInstanceInfo(this.currentClass);
                    this.currentObject = this.currentClass == null ? null : this.currentClassDesc.newInstance();
                    this.activeRecursionMgr.addObject(offset, this.currentObject);
                }
                catch (InvocationTargetException e) {
                    exc = new InvalidClassException(this.currentClass.getName(), "InvocationTargetException accessing no-arg constructor");
                    exc.initCause(e);
                    throw exc;
                }
                catch (UnsupportedOperationException e) {
                    exc = new InvalidClassException(this.currentClass.getName(), "UnsupportedOperationException accessing no-arg constructor");
                    exc.initCause(e);
                    throw exc;
                }
                catch (InstantiationException e) {
                    exc = new InvalidClassException(this.currentClass.getName(), "InstantiationException accessing no-arg constructor");
                    exc.initCause(e);
                    throw exc;
                }
                Iterator<FullValueDescription> fvdsList = this.getOrderedDescriptions(repositoryID, sender).iterator();
                while (fvdsList.hasNext() && this.spClass > spBase) {
                    boolean calledDefaultWriteObject2;
                    fvd = fvdsList.next();
                    this.readingDataUsingFVD(fvd);
                    String repIDForFVD = this.vhandler.getClassName(fvd.id);
                    String repIDForClass = this.vhandler.getClassName(this.vhandler.getRMIRepositoryID(this.currentClass));
                    while (this.spClass > spBase && !repIDForFVD.equals(repIDForClass)) {
                        int pos = this.findNextClass(repIDForFVD, this.classes, this.spClass, spBase);
                        if (pos != -1) {
                            this.spClass = pos;
                            currclass = this.currentClass = this.classes[this.spClass];
                            repIDForClass = this.vhandler.getClassName(this.vhandler.getRMIRepositoryID(this.currentClass));
                            continue;
                        }
                        if (fvd.is_custom) {
                            this.readFormatVersion();
                            calledDefaultWriteObject2 = this.readBoolean();
                            if (calledDefaultWriteObject2) {
                                this.inputClassFields(null, null, null, fvd.members, sender);
                            }
                            if (this.getStreamFormatVersion() == 2) {
                                ((ValueInputStream)this.getOrbStream()).start_value();
                                ((ValueInputStream)this.getOrbStream()).end_value();
                            }
                        } else {
                            this.inputClassFields(null, this.currentClass, null, fvd.members, sender);
                        }
                        if (fvdsList.hasNext()) {
                            fvd = fvdsList.next();
                            repIDForFVD = this.vhandler.getClassName(fvd.id);
                            continue;
                        }
                        Object calledDefaultWriteObject2 = this.currentObject;
                        return calledDefaultWriteObject2;
                    }
                    currdesc = this.currentClassDesc = ObjectStreamClass.lookup(this.currentClass);
                    if (!repIDForClass.equals("java.lang.Object")) {
                        InputStreamHook.ReadObjectState oldState = this.readObjectState;
                        this.setState(DEFAULT_STATE);
                        try {
                            if (fvd.is_custom) {
                                this.readFormatVersion();
                                calledDefaultWriteObject2 = this.readBoolean();
                                this.readObjectState.beginUnmarshalCustomValue(this, calledDefaultWriteObject2, this.currentClassDesc.getReadObjectMethod() != null);
                            }
                            boolean usedReadObject = false;
                            if (!fvd.is_custom && this.currentClassDesc.hasReadObject()) {
                                this.setState(IN_READ_OBJECT_REMOTE_NOT_CUSTOM_MARSHALED);
                            }
                            if (!(usedReadObject = this.invokeObjectReader(this.currentClassDesc, this.currentObject, this.currentClass, fvd.members)) || this.readObjectState == IN_READ_OBJECT_DEFAULTS_SENT) {
                                this.inputClassFields(this.currentObject, this.currentClass, currdesc, fvd.members, sender);
                            }
                            if (fvd.is_custom) {
                                this.readObjectState.endUnmarshalCustomValue(this);
                            }
                        }
                        finally {
                            this.setState(oldState);
                        }
                        currclass = this.currentClass = this.classes[--this.spClass];
                        continue;
                    }
                    this.inputClassFields(null, this.currentClass, null, fvd.members, sender);
                    while (fvdsList.hasNext()) {
                        fvd = fvdsList.next();
                        if (fvd.is_custom) {
                            this.skipCustomUsingFVD(fvd.members, sender);
                            continue;
                        }
                        this.inputClassFields(null, this.currentClass, null, fvd.members, sender);
                    }
                }
                while (fvdsList.hasNext()) {
                    fvd = fvdsList.next();
                    if (fvd.is_custom) {
                        this.skipCustomUsingFVD(fvd.members, sender);
                        continue;
                    }
                    this.throwAwayData(fvd.members, sender);
                }
            }
            finally {
                this.spClass = spBase;
                this.activeRecursionMgr.removeObject(offset);
            }
        }
        return this.currentObject;
    }

    @ValueHandlerRead
    private Object skipObjectUsingFVD(String repositoryID, CodeBase sender) throws IOException, ClassNotFoundException {
        for (FullValueDescription fvd : this.getOrderedDescriptions(repositoryID, sender)) {
            String repIDForFVD = this.vhandler.getClassName(fvd.id);
            if (repIDForFVD.equals("java.lang.Object")) continue;
            if (fvd.is_custom) {
                this.readFormatVersion();
                boolean calledDefaultWriteObject = this.readBoolean();
                if (calledDefaultWriteObject) {
                    this.inputClassFields(null, null, null, fvd.members, sender);
                }
                if (this.getStreamFormatVersion() != 2) continue;
                ((ValueInputStream)this.getOrbStream()).start_value();
                ((ValueInputStream)this.getOrbStream()).end_value();
                continue;
            }
            this.inputClassFields(null, null, null, fvd.members, sender);
        }
        return null;
    }

    @ValueHandlerRead
    private int findNextClass(String classname, Class[] classes, int _spClass, int _spBase) {
        for (int i = _spClass; i > _spBase; --i) {
            if (!classname.equals(classes[i].getName())) continue;
            return i;
        }
        return -1;
    }

    @ValueHandlerRead
    private boolean invokeObjectReader(ObjectStreamClass osc, Object obj, Class aclass, ValueMember[] valueMembers) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        OperationTracer.readingField((String)"<<readObject>>");
        boolean result = false;
        if (osc.getReadObjectMethod() != null) {
            try {
                this.defaultReadObjectFVDMembers = valueMembers;
                osc.getReadObjectMethod().invoke(obj, this);
                result = true;
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error("internal error");
            }
            finally {
                this.defaultReadObjectFVDMembers = null;
            }
        }
        return result;
    }

    @ValueHandlerRead
    private void resetStream() throws IOException {
        int i;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            for (i = 0; i < this.classes.length; ++i) {
                this.classes[i] = null;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            for (i = 0; i < this.classdesc.length; ++i) {
                this.classdesc[i] = null;
            }
        }
        this.spClass = 0;
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
    }

    @ValueHandlerRead
    private void inputPrimitiveField(Object o, Class<?> cl, ObjectStreamField field) throws InvalidClassException, IOException {
        try {
            switch (field.getTypeCode()) {
                case 'B': {
                    byte byteValue = this.orbStream.read_octet();
                    bridge.putByte(o, field.getFieldID(), byteValue);
                    break;
                }
                case 'Z': {
                    boolean booleanValue = this.orbStream.read_boolean();
                    bridge.putBoolean(o, field.getFieldID(), booleanValue);
                    break;
                }
                case 'C': {
                    char charValue = this.orbStream.read_wchar();
                    bridge.putChar(o, field.getFieldID(), charValue);
                    break;
                }
                case 'S': {
                    short shortValue = this.orbStream.read_short();
                    bridge.putShort(o, field.getFieldID(), shortValue);
                    break;
                }
                case 'I': {
                    int intValue = this.orbStream.read_long();
                    bridge.putInt(o, field.getFieldID(), intValue);
                    break;
                }
                case 'J': {
                    long longValue = this.orbStream.read_longlong();
                    bridge.putLong(o, field.getFieldID(), longValue);
                    break;
                }
                case 'F': {
                    float floatValue = this.orbStream.read_float();
                    bridge.putFloat(o, field.getFieldID(), floatValue);
                    break;
                }
                case 'D': {
                    double doubleValue = this.orbStream.read_double();
                    bridge.putDouble(o, field.getFieldID(), doubleValue);
                    break;
                }
                default: {
                    throw Exceptions.self.invalidClassForPrimitive(cl.getName());
                }
            }
        }
        catch (IllegalArgumentException e) {
            ClassCastException cce = new ClassCastException("Assigning instance of class " + field.getType().getName() + " to field " + this.currentClassDesc.getName() + '#' + field.getField().getName());
            cce.initCause(e);
            throw cce;
        }
    }

    @InfoMethod
    private void callTypeInfo(int ct) {
    }

    @InfoMethod
    private void typeInfo(Class<?> type) {
    }

    @ValueHandlerRead
    private Object inputObjectField(ValueMember field, CodeBase sender) throws IndirectionException, ClassNotFoundException, IOException, StreamCorruptedException {
        Object objectValue = null;
        Class type = null;
        String id = field.id;
        try {
            type = this.vhandler.getClassFromType(id);
        }
        catch (ClassNotFoundException cnfe) {
            type = null;
        }
        this.typeInfo(type);
        String signature = null;
        if (type != null) {
            signature = ValueUtility.getSignature(field);
        }
        if (signature != null && (signature.equals("Ljava/lang/Object;") || signature.equals("Ljava/io/Serializable;") || signature.equals("Ljava/io/Externalizable;"))) {
            objectValue = Util.getInstance().readAny((org.omg.CORBA.portable.InputStream)this.orbStream);
        } else {
            int callType = 2;
            if (!this.vhandler.isSequence(id)) {
                if (field.type.kind().value() == kRemoteTypeCode.kind().value()) {
                    callType = 0;
                } else {
                    ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(type);
                    if (type != null && cinfo.isInterface() && (this.vhandler.isAbstractBase(type) || ObjectStreamClassCorbaExt.isAbstractInterface(type))) {
                        callType = 1;
                    }
                }
            }
            this.callTypeInfo(callType);
            switch (callType) {
                case 0: {
                    if (type != null) {
                        objectValue = Utility.readObjectAndNarrow((org.omg.CORBA.portable.InputStream)this.orbStream, type);
                        break;
                    }
                    objectValue = this.orbStream.read_Object();
                    break;
                }
                case 1: {
                    if (type != null) {
                        objectValue = Utility.readAbstractAndNarrow(this.orbStream, type);
                        break;
                    }
                    objectValue = this.orbStream.read_abstract_interface();
                    break;
                }
                case 2: {
                    if (type != null) {
                        objectValue = this.orbStream.read_value(type);
                        break;
                    }
                    objectValue = this.orbStream.read_value();
                    break;
                }
                default: {
                    throw Exceptions.self.unknownCallType(callType);
                }
            }
        }
        return objectValue;
    }

    @ValueHandlerRead
    private Object inputObjectField(ObjectStreamField field) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IndirectionException, IOException {
        Class fieldType;
        if (ObjectStreamClassCorbaExt.isAny(field.getTypeString())) {
            return Util.getInstance().readAny((org.omg.CORBA.portable.InputStream)this.orbStream);
        }
        Object objectValue = null;
        Class actualType = fieldType = field.getType();
        int callType = 2;
        boolean narrow = false;
        ClassInfoCache.ClassInfo cinfo = field.getClassInfo();
        if (cinfo.isInterface()) {
            boolean loadStubClass = false;
            if (cinfo.isARemote(fieldType)) {
                callType = 0;
            } else if (cinfo.isACORBAObject(fieldType)) {
                callType = 0;
                loadStubClass = true;
            } else if (this.vhandler.isAbstractBase(fieldType)) {
                callType = 1;
                loadStubClass = true;
            } else if (ObjectStreamClassCorbaExt.isAbstractInterface(fieldType)) {
                callType = 1;
            }
            if (loadStubClass) {
                try {
                    Class stubType;
                    String codebase = Util.getInstance().getCodebase(fieldType);
                    String repID = this.vhandler.createForAnyType(fieldType);
                    actualType = stubType = Utility.loadStubClass(repID, codebase, fieldType);
                }
                catch (ClassNotFoundException e) {
                    narrow = true;
                }
            } else {
                narrow = true;
            }
        }
        switch (callType) {
            case 0: {
                if (!narrow) {
                    objectValue = this.orbStream.read_Object(actualType);
                    break;
                }
                objectValue = Utility.readObjectAndNarrow((org.omg.CORBA.portable.InputStream)this.orbStream, actualType);
                break;
            }
            case 1: {
                if (!narrow) {
                    objectValue = this.orbStream.read_abstract_interface(actualType);
                    break;
                }
                objectValue = Utility.readAbstractAndNarrow(this.orbStream, actualType);
                break;
            }
            case 2: {
                objectValue = this.orbStream.read_value(actualType);
                break;
            }
            default: {
                throw Exceptions.self.unknownCallType(callType);
            }
        }
        return objectValue;
    }

    @Override
    void readFields(Map<String, Object> fieldToValueMap) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.defaultReadObjectFVDMembers != null) {
            this.inputRemoteMembersForReadFields(fieldToValueMap);
        } else {
            this.inputCurrentClassFieldsForReadFields(fieldToValueMap);
        }
    }

    @ValueHandlerRead
    private void inputRemoteMembersForReadFields(Map<String, Object> fieldToValueMap) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        ValueMember[] fields = this.defaultReadObjectFVDMembers;
        this.defaultReadObjectFVDMembers = null;
        try {
            block15: for (int i = 0; i < fields.length; ++i) {
                OperationTracer.readingField((String)fields[i].name);
                this.displayValueMember(fields[i]);
                switch (fields[i].type.kind().value()) {
                    case 10: {
                        byte byteValue = this.orbStream.read_octet();
                        fieldToValueMap.put(fields[i].name, byteValue);
                        continue block15;
                    }
                    case 8: {
                        boolean booleanValue = this.orbStream.read_boolean();
                        fieldToValueMap.put(fields[i].name, booleanValue);
                        continue block15;
                    }
                    case 9: 
                    case 26: {
                        char charValue = this.orbStream.read_wchar();
                        fieldToValueMap.put(fields[i].name, Character.valueOf(charValue));
                        continue block15;
                    }
                    case 2: {
                        short shortValue = this.orbStream.read_short();
                        fieldToValueMap.put(fields[i].name, shortValue);
                        continue block15;
                    }
                    case 3: {
                        int intValue = this.orbStream.read_long();
                        fieldToValueMap.put(fields[i].name, intValue);
                        continue block15;
                    }
                    case 23: {
                        long longValue = this.orbStream.read_longlong();
                        fieldToValueMap.put(fields[i].name, longValue);
                        continue block15;
                    }
                    case 6: {
                        float floatValue = this.orbStream.read_float();
                        fieldToValueMap.put(fields[i].name, Float.valueOf(floatValue));
                        continue block15;
                    }
                    case 7: {
                        double doubleValue = this.orbStream.read_double();
                        fieldToValueMap.put(fields[i].name, doubleValue);
                        continue block15;
                    }
                    case 14: 
                    case 29: 
                    case 30: {
                        Object objectValue = null;
                        try {
                            objectValue = this.inputObjectField(fields[i], this.cbSender);
                        }
                        catch (IndirectionException cdrie) {
                            objectValue = this.activeRecursionMgr.getObject(cdrie.offset);
                        }
                        fieldToValueMap.put(fields[i].name, objectValue);
                        continue block15;
                    }
                    default: {
                        throw Exceptions.self.unknownTypecodeKind(fields[i].type.kind().value());
                    }
                }
            }
        }
        catch (Throwable t) {
            StreamCorruptedException result = new StreamCorruptedException(t.getMessage());
            result.initCause(t);
            throw result;
        }
    }

    @ValueHandlerRead
    private void inputCurrentClassFieldsForReadFields(Map<String, Object> fieldToValueMap) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int i;
        ObjectStreamField[] fields = this.currentClassDesc.getFieldsNoCopy();
        int primFields = fields.length - this.currentClassDesc.objFields;
        block12: for (i = 0; i < primFields; ++i) {
            switch (fields[i].getTypeCode()) {
                case 'B': {
                    byte byteValue = this.orbStream.read_octet();
                    fieldToValueMap.put(fields[i].getName(), byteValue);
                    continue block12;
                }
                case 'Z': {
                    boolean booleanValue = this.orbStream.read_boolean();
                    fieldToValueMap.put(fields[i].getName(), booleanValue);
                    continue block12;
                }
                case 'C': {
                    char charValue = this.orbStream.read_wchar();
                    fieldToValueMap.put(fields[i].getName(), Character.valueOf(charValue));
                    continue block12;
                }
                case 'S': {
                    short shortValue = this.orbStream.read_short();
                    fieldToValueMap.put(fields[i].getName(), shortValue);
                    continue block12;
                }
                case 'I': {
                    int intValue = this.orbStream.read_long();
                    fieldToValueMap.put(fields[i].getName(), intValue);
                    continue block12;
                }
                case 'J': {
                    long longValue = this.orbStream.read_longlong();
                    fieldToValueMap.put(fields[i].getName(), longValue);
                    continue block12;
                }
                case 'F': {
                    float floatValue = this.orbStream.read_float();
                    fieldToValueMap.put(fields[i].getName(), Float.valueOf(floatValue));
                    continue block12;
                }
                case 'D': {
                    double doubleValue = this.orbStream.read_double();
                    fieldToValueMap.put(fields[i].getName(), doubleValue);
                    continue block12;
                }
                default: {
                    throw Exceptions.self.invalidClassForPrimitive(this.currentClassDesc.getName());
                }
            }
        }
        if (this.currentClassDesc.objFields > 0) {
            for (i = primFields; i < fields.length; ++i) {
                OperationTracer.readingField((String)fields[i].getName());
                Object objectValue = null;
                try {
                    objectValue = this.inputObjectField(fields[i]);
                }
                catch (IndirectionException cdrie) {
                    objectValue = this.activeRecursionMgr.getObject(cdrie.offset);
                }
                fieldToValueMap.put(fields[i].getName(), objectValue);
            }
        }
    }

    @InfoMethod
    private void readingPrimitiveFields(int count) {
    }

    @InfoMethod
    private void readingField(int index, ObjectStreamField fld) {
    }

    @ValueHandlerRead
    private void inputClassFields(Object o, Class<?> cl, ObjectStreamField[] fields, CodeBase sender) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        int i;
        int primFields = fields.length - this.currentClassDesc.objFields;
        this.readingPrimitiveFields(primFields);
        if (o != null) {
            for (i = 0; i < primFields; ++i) {
                OperationTracer.readingField((String)fields[i].getName());
                if (fields[i].getField() == null) continue;
                this.inputPrimitiveField(o, cl, fields[i]);
            }
        }
        if (this.currentClassDesc.objFields > 0) {
            for (i = primFields; i < fields.length; ++i) {
                OperationTracer.readingField((String)fields[i].getName());
                Object objectValue = null;
                try {
                    this.readingField(i, fields[i]);
                    objectValue = this.inputObjectField(fields[i]);
                }
                catch (IndirectionException cdrie) {
                    objectValue = this.activeRecursionMgr.getObject(cdrie.offset);
                }
                if (o == null || fields[i].getField() == null) continue;
                try {
                    Class fieldCl = fields[i].getClazz();
                    if (objectValue != null && !fieldCl.isAssignableFrom(objectValue.getClass())) {
                        throw new IllegalArgumentException("Field mismatch");
                    }
                    Field classField = null;
                    try {
                        classField = cl.getDeclaredField(fields[i].getName());
                    }
                    catch (NoSuchFieldException nsfEx) {
                        throw new IllegalArgumentException(nsfEx);
                    }
                    catch (SecurityException secEx) {
                        throw new IllegalArgumentException(secEx.getCause());
                    }
                    Class<?> declaredFieldClass = classField.getType();
                    if (!declaredFieldClass.isAssignableFrom(fieldCl)) {
                        throw new IllegalArgumentException("Field Type mismatch");
                    }
                    if (objectValue != null && !fieldCl.isInstance(objectValue)) {
                        throw new IllegalArgumentException();
                    }
                    bridge.putObject(o, fields[i].getFieldID(), objectValue);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ClassCastException exc = new ClassCastException("Assigning instance of class " + objectValue.getClass().getName() + " to field " + this.currentClassDesc.getName() + '#' + fields[i].getField().getName());
                    exc.initCause(e);
                    throw exc;
                }
            }
        }
    }

    @InfoMethod
    private void valueMemberInfo(String name, String id, String definedIn, String version, short access) {
    }

    @ValueHandlerRead
    private void displayValueMember(ValueMember member) {
        this.valueMemberInfo(member.name, member.id, member.defined_in, member.version, member.access);
    }

    @ValueHandlerRead
    private void displayValueMembers(ValueMember[] members) {
        for (ValueMember member : members) {
            this.displayValueMember(member);
        }
    }

    @ValueHandlerRead
    private void inputClassFields(Object o, Class<?> cl, ObjectStreamClass osc, ValueMember[] fields, CodeBase sender) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        this.displayValueMembers(fields);
        try {
            block19: for (int i = 0; i < fields.length; ++i) {
                OperationTracer.readingField((String)fields[i].name);
                this.displayValueMember(fields[i]);
                try {
                    switch (fields[i].type.kind().value()) {
                        case 10: {
                            byte byteValue = this.orbStream.read_octet();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setByteField(o, cl, fields[i].name, byteValue);
                            break;
                        }
                        case 8: {
                            boolean booleanValue = this.orbStream.read_boolean();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setBooleanField(o, cl, fields[i].name, booleanValue);
                            break;
                        }
                        case 9: 
                        case 26: {
                            char charValue = this.orbStream.read_wchar();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setCharField(o, cl, fields[i].name, charValue);
                            break;
                        }
                        case 2: {
                            short shortValue = this.orbStream.read_short();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setShortField(o, cl, fields[i].name, shortValue);
                            break;
                        }
                        case 3: {
                            int intValue = this.orbStream.read_long();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setIntField(o, cl, fields[i].name, intValue);
                            break;
                        }
                        case 23: {
                            long longValue = this.orbStream.read_longlong();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setLongField(o, cl, fields[i].name, longValue);
                            break;
                        }
                        case 6: {
                            float floatValue = this.orbStream.read_float();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setFloatField(o, cl, fields[i].name, floatValue);
                            break;
                        }
                        case 7: {
                            double doubleValue = this.orbStream.read_double();
                            if (o == null || !osc.hasField(fields[i])) continue block19;
                            IIOPInputStream.setDoubleField(o, cl, fields[i].name, doubleValue);
                            break;
                        }
                        case 14: 
                        case 29: 
                        case 30: {
                            Object objectValue = null;
                            try {
                                objectValue = this.inputObjectField(fields[i], sender);
                            }
                            catch (IndirectionException cdrie) {
                                objectValue = this.activeRecursionMgr.getObject(cdrie.offset);
                            }
                            if (o == null) continue block19;
                            try {
                                if (osc.hasField(fields[i])) {
                                    IIOPInputStream.setObjectField(o, cl, fields[i].name, objectValue);
                                    break;
                                }
                                Exceptions.self.notSettingField(fields[i].name, osc.getName());
                                break;
                            }
                            catch (IllegalArgumentException e) {
                                throw Exceptions.self.couldNotAssignObjectToField(e, objectValue.getClass().getName(), fields[i].name);
                            }
                        }
                        default: {
                            throw Exceptions.self.unknownTypecodeKind(fields[i].type.kind().value());
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw Exceptions.self.couldNotAssignObjectToField(e, fields[i].id, fields[i].name);
                }
            }
        }
        catch (Throwable t) {
            throw Exceptions.self.streamCorrupted(t);
        }
    }

    @ValueHandlerRead
    private void skipCustomUsingFVD(ValueMember[] fields, CodeBase sender) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        this.readFormatVersion();
        boolean calledDefaultWriteObject = this.readBoolean();
        if (calledDefaultWriteObject) {
            this.throwAwayData(fields, sender);
        }
        if (this.getStreamFormatVersion() == 2) {
            ((ValueInputStream)this.getOrbStream()).start_value();
            ((ValueInputStream)this.getOrbStream()).end_value();
        }
    }

    /*
     * Unable to fully structure code
     */
    @ValueHandlerRead
    private void throwAwayData(ValueMember[] fields, CodeBase sender) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        block22: for (i = 0; i < fields.length; ++i) {
            OperationTracer.readingField((String)fields[i].name);
            try {
                switch (fields[i].type.kind().value()) {
                    case 10: {
                        this.orbStream.read_octet();
                        break;
                    }
                    case 8: {
                        this.orbStream.read_boolean();
                        break;
                    }
                    case 9: 
                    case 26: {
                        this.orbStream.read_wchar();
                        break;
                    }
                    case 2: {
                        this.orbStream.read_short();
                        break;
                    }
                    case 3: {
                        this.orbStream.read_long();
                        break;
                    }
                    case 23: {
                        this.orbStream.read_longlong();
                        break;
                    }
                    case 6: {
                        this.orbStream.read_float();
                        break;
                    }
                    case 7: {
                        this.orbStream.read_double();
                        break;
                    }
                    case 14: 
                    case 29: 
                    case 30: {
                        type = null;
                        id = fields[i].id;
                        try {
                            type = this.vhandler.getClassFromType(id);
                        }
                        catch (ClassNotFoundException cnfe) {
                            type = null;
                        }
                        signature = null;
                        if (type != null) {
                            signature = ValueUtility.getSignature(fields[i]);
                        }
                        try {
                            if (signature != null && (signature.equals("Ljava/lang/Object;") || signature.equals("Ljava/io/Serializable;") || signature.equals("Ljava/io/Externalizable;"))) {
                                Util.getInstance().readAny((org.omg.CORBA.portable.InputStream)this.orbStream);
                                ** break;
                            }
                            callType = 2;
                            if (!this.vhandler.isSequence(id)) {
                                fieldFVD = sender.meta(fields[i].id);
                                if (IIOPInputStream.kRemoteTypeCode == fields[i].type) {
                                    callType = 0;
                                } else if (fieldFVD.is_abstract) {
                                    callType = 1;
                                }
                            }
                            switch (callType) {
                                case 0: {
                                    this.orbStream.read_Object();
                                    ** break;
                                }
                                case 1: {
                                    this.orbStream.read_abstract_interface();
                                    ** break;
                                }
                                case 2: {
                                    if (type != null) {
                                        this.orbStream.read_value(type);
                                        ** break;
                                    }
                                    this.orbStream.read_value();
                                    ** break;
                                }
                            }
                            throw Exceptions.self.unknownCallType(callType);
lbl79:
                            // 5 sources

                            break;
                        }
                        catch (IndirectionException cdrie) {
                            continue block22;
                        }
                    }
                    default: {
                        throw Exceptions.self.unknownTypecodeKind(fields[i].type.kind().value());
                    }
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                throw Exceptions.self.couldNotAssignObjectToField(e, fields[i].id, this.currentClassDesc.getName());
            }
        }
    }

    @ValueHandlerRead
    private static void setObjectField(Object o, Class<?> c, String fieldName, Object v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            Class<?> fieldCl = fld.getType();
            if (v != null && !fieldCl.isInstance(v)) {
                throw new Exception();
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putObject(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetObjectField(e, fieldName, o.toString(), v.toString());
            }
            throw utilWrapper.errorSetObjectField(e, fieldName, "null " + c.getName() + " object", v.toString());
        }
    }

    @ValueHandlerRead
    private static void setBooleanField(Object o, Class<?> c, String fieldName, boolean v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Boolean.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putBoolean(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetBooleanField(e, fieldName, o.toString(), new Boolean(v));
            }
            throw utilWrapper.errorSetBooleanField(e, fieldName, "null " + c.getName() + " object", new Boolean(v));
        }
    }

    @ValueHandlerRead
    private static void setByteField(Object o, Class<?> c, String fieldName, byte v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Byte.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putByte(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetByteField(e, fieldName, o.toString(), new Byte(v));
            }
            throw utilWrapper.errorSetByteField(e, fieldName, "null " + c.getName() + " object", new Byte(v));
        }
    }

    @ValueHandlerRead
    private static void setCharField(Object o, Class<?> c, String fieldName, char v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Character.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putChar(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetCharField(e, fieldName, o.toString(), new Character(v).charValue());
            }
            throw utilWrapper.errorSetCharField(e, fieldName, "null " + c.getName() + " object", new Character(v).charValue());
        }
    }

    @ValueHandlerRead
    private static void setShortField(Object o, Class<?> c, String fieldName, short v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Short.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putShort(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetShortField(e, fieldName, o.toString(), new Short(v));
            }
            throw utilWrapper.errorSetShortField(e, fieldName, "null " + c.getName() + " object", new Short(v));
        }
    }

    @ValueHandlerRead
    private static void setIntField(Object o, Class<?> c, String fieldName, int v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Integer.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putInt(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetIntField(e, fieldName, o.toString(), new Integer(v));
            }
            throw utilWrapper.errorSetIntField(e, fieldName, "null " + c.getName() + " object", new Integer(v));
        }
    }

    @ValueHandlerRead
    private static void setLongField(Object o, Class<?> c, String fieldName, long v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Long.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putLong(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetLongField(e, fieldName, o.toString(), new Long(v));
            }
            throw utilWrapper.errorSetLongField(e, fieldName, "null " + c.getName() + " object", new Long(v));
        }
    }

    @ValueHandlerRead
    private static void setFloatField(Object o, Class<?> c, String fieldName, float v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Float.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putFloat(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetFloatField(e, fieldName, o.toString(), new Float(v).floatValue());
            }
            throw utilWrapper.errorSetFloatField(e, fieldName, "null " + c.getName() + " object", new Float(v).floatValue());
        }
    }

    @ValueHandlerRead
    private static void setDoubleField(Object o, Class<?> c, String fieldName, double v) {
        try {
            Field fld = c.getDeclaredField(fieldName);
            if (fld == null || fld.getType() != Double.TYPE) {
                throw new InvalidObjectException("Field Type mismatch");
            }
            long key = bridge.objectFieldOffset(fld);
            bridge.putDouble(o, key, v);
        }
        catch (Exception e) {
            if (o != null) {
                throw utilWrapper.errorSetDoubleField(e, fieldName, o.toString(), new Double(v));
            }
            throw utilWrapper.errorSetDoubleField(e, fieldName, "null " + c.getName() + " object", new Double(v));
        }
    }

    static class ActiveRecursionManager {
        private Map<Integer, Object> offsetToObjectMap = new HashMap<Integer, Object>();

        public void addObject(int offset, Object value) {
            this.offsetToObjectMap.put(offset, value);
        }

        public Object getObject(int offset) throws IOException {
            Integer position = offset;
            if (!this.offsetToObjectMap.containsKey(position)) {
                throw new IOException("Invalid indirection to offset " + offset);
            }
            return this.offsetToObjectMap.get(position);
        }

        public void removeObject(int offset) {
            this.offsetToObjectMap.remove(offset);
        }

        public boolean containsObject(int offset) {
            return this.offsetToObjectMap.containsKey(offset);
        }
    }
}

