/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaWebsphere61PlatformTest
extends AutoVerifyTestCase {
    Exception m_exceptionCaught;
    DatabaseSession m_employeeSession;

    public SessionsXMLSchemaWebsphere61PlatformTest() {
        this.setDescription("Tests loading a websphere 6.0 platform from the schema.");
    }

    public void reset() {
        if (this.m_employeeSession != null && this.m_employeeSession.isConnected()) {
            this.m_employeeSession.logout();
            SessionManager.getManager().getSessions().remove(this.m_employeeSession);
            this.m_employeeSession = null;
        }
    }

    protected void setup() {
        this.m_exceptionCaught = null;
    }

    public void test() {
        try {
            XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSessionWAS61Platform.xml");
            this.m_employeeSession = (DatabaseSession)SessionManager.getManager().getSession(loader, "EmployeeSession", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
        }
        catch (Exception e) {
            this.m_exceptionCaught = e;
        }
    }

    protected void verify() {
        if (this.m_exceptionCaught != null) {
            throw new TestErrorException("Loading of the session failed: " + this.m_exceptionCaught, (Throwable)this.m_exceptionCaught);
        }
        if (this.m_employeeSession == null) {
            throw new TestErrorException("Loaded session was null");
        }
    }
}

