/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Operation;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.DeleteIfVersion;
import oracle.kv.impl.api.ops.Execute;
import oracle.kv.impl.api.ops.Get;
import oracle.kv.impl.api.ops.GetIdentityAttrsAndValues;
import oracle.kv.impl.api.ops.IndexIterate;
import oracle.kv.impl.api.ops.IndexKeysIterate;
import oracle.kv.impl.api.ops.MultiDelete;
import oracle.kv.impl.api.ops.MultiDeleteTable;
import oracle.kv.impl.api.ops.MultiGet;
import oracle.kv.impl.api.ops.MultiGetBatchIterate;
import oracle.kv.impl.api.ops.MultiGetBatchKeysIterate;
import oracle.kv.impl.api.ops.MultiGetBatchTable;
import oracle.kv.impl.api.ops.MultiGetBatchTableKeys;
import oracle.kv.impl.api.ops.MultiGetIterate;
import oracle.kv.impl.api.ops.MultiGetKeys;
import oracle.kv.impl.api.ops.MultiGetKeysIterate;
import oracle.kv.impl.api.ops.MultiGetTable;
import oracle.kv.impl.api.ops.MultiGetTableKeys;
import oracle.kv.impl.api.ops.NOP;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutBatch;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.PutIfPresent;
import oracle.kv.impl.api.ops.PutIfVersion;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.api.ops.TableIterate;
import oracle.kv.impl.api.ops.TableKeysIterate;
import oracle.kv.impl.api.ops.TableQuery;
import oracle.kv.impl.api.ops.ThroughputTracker;
import oracle.kv.impl.measurement.PerfStatType;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.table.TimeToLive;

public abstract class InternalOperation
implements FastExternalizable {
    private final short opSerialVersion;
    private transient boolean enableCacheReadBytes;
    private transient int cachedReadKB;
    private transient ThroughputTracker tracker = null;
    private transient boolean isAbsolute = false;
    private transient int readKB = 0;
    private transient int writeKB = 0;
    private final OpCode opCode;

    public InternalOperation(OpCode opCode) {
        this.opCode = opCode;
        this.opSerialVersion = SerialVersion.CURRENT;
    }

    InternalOperation(OpCode opCode, DataInput in, short serialVersion) {
        this.opCode = opCode;
        this.opSerialVersion = serialVersion;
    }

    public static InternalOperation readFastExternal(DataInput in, short serialVersion) throws IOException {
        OpCode op = OpCode.readFastExternal(in, serialVersion);
        return op.readOperation(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.opCode.writeFastExternal(out, serialVersion);
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public boolean performsRead() {
        return true;
    }

    public boolean performsWrite() {
        assert (!this.isDelete());
        return false;
    }

    public boolean isDelete() {
        return false;
    }

    public long getTableId() {
        return 0L;
    }

    public long[] getTableIds() {
        return null;
    }

    public boolean isTableOp() {
        return this.getTableId() != 0L || this.getTableIds() != null;
    }

    public void setThroughputTracker(ThroughputTracker tracker, Consistency consistency) {
        assert (this.tracker == null);
        this.tracker = tracker;
        this.isAbsolute = this.opCode.isWrite() || Consistency.ABSOLUTE.equals(consistency);
    }

    public void setThroughputTracker(InternalOperation op) {
        this.tracker = op.tracker;
        this.isAbsolute = op.isAbsolute;
    }

    public int getReadKB() {
        return this.readKB;
    }

    public int getWriteKB() {
        return this.writeKB;
    }

    public void addReadBytes(int bytes) {
        if (this.tracker != null) {
            if (this.enableCacheReadBytes) {
                this.cachedReadKB += InternalOperation.toKBytes(bytes);
                return;
            }
            this.readKB += this.tracker.addReadBytes(bytes, this.isAbsolute);
        }
    }

    void beginAddReadBytes() {
        this.enableCacheReadBytes = true;
        this.cachedReadKB = 0;
    }

    void flushReadBytes(boolean add) {
        if (this.cachedReadKB == 0) {
            return;
        }
        if (add) {
            this.readKB += this.tracker.addReadBytes(this.cachedReadKB * 1024, this.isAbsolute);
        }
        this.cachedReadKB = 0;
        this.enableCacheReadBytes = false;
    }

    void addEmptyReadCharge() {
        this.addReadBytes(1024);
    }

    public void addMinReadCharge() {
        this.addReadBytes(1024);
    }

    public void addWriteBytes(int bytes, int nIndexWrites) {
        if (this.tracker != null) {
            this.writeKB += this.tracker.addWriteBytes(bytes, nIndexWrites);
        }
    }

    public static int toKBytes(int bytes) {
        if (bytes == 0) {
            return 0;
        }
        int roundedKB = bytes / 1024;
        if (bytes % 1024 != 0) {
            ++roundedKB;
        }
        return roundedKB;
    }

    public int getReadKBToAdd(int bytes) {
        if (this.tracker != null) {
            return this.tracker.getReadKBToAdd(bytes, this.isAbsolute);
        }
        return 0;
    }

    public byte[] checkLOBSuffix(byte[] lobSuffixBytes) {
        return null;
    }

    public String toString() {
        return this.opCode.name();
    }

    public static void writeTimeToLive(DataOutput out, short serialVersion, TimeToLive ttl, String operationName) throws IOException {
        InternalOperation.writeTimeToLive(out, serialVersion, TimeToLive.getTTLValue(ttl), TimeToLive.getTTLUnit(ttl), operationName);
    }

    public static void writeTimeToLive(DataOutput out, short serialVersion, int ttlVal, TimeUnit ttlUnit, String operationName) throws IOException {
        try {
            TimeToLive.writeFastExternal(out, serialVersion, ttlVal, ttlUnit);
        }
        catch (UnsupportedOperationException e) {
            InternalOperation.throwVersionRequired(serialVersion, (short)10, operationName);
        }
    }

    short getOpSerialVersion() {
        return this.opSerialVersion;
    }

    private static void throwVersionRequired(short serverVersion, short requiredVersion, String operationName) {
        throw new UnsupportedOperationException("Attempting an operation that is not supported by the server version.  Server version is " + SerialVersion.getKVVersion(serverVersion).getNumericVersionString() + ", required version is " + SerialVersion.getKVVersion(requiredVersion).getNumericVersionString() + ", operation is " + operationName);
    }

    public static enum OpCode implements FastExternalizable
    {
        NOP(0){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new NOP(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.NOPResult(in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return true;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.NOP_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.NOP_CUM;
            }
        }
        ,
        GET(1){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new Get(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.GetResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.GetResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.GET_CUM;
            }
        }
        ,
        MULTI_GET(2){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGet(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_CUM;
            }
        }
        ,
        MULTI_GET_KEYS(3){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetKeys(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_KEYS_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_KEYS_CUM;
            }
        }
        ,
        MULTI_GET_ITERATE(4){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_ITERATOR_CUM;
            }
        }
        ,
        MULTI_GET_KEYS_ITERATE(5){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_KEYS_ITERATOR_CUM;
            }
        }
        ,
        STORE_ITERATE(6){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new StoreIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_ITERATOR_CUM;
            }
        }
        ,
        STORE_KEYS_ITERATE(7){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new StoreKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_CUM;
            }
        }
        ,
        PUT(8){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new Put(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.PutResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        PUT_IF_ABSENT(9){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new PutIfAbsent(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.PutResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT_IF_ABSENT;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_IF_ABSENT_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_IF_ABSENT_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        PUT_IF_PRESENT(10){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new PutIfPresent(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.PutResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT_IF_PRESENT;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_IF_PRESENT_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_IF_PRESENT_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        PUT_IF_VERSION(11){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new PutIfVersion(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.PutResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.PUT_IF_VERSION;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_IF_VERSION_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_IF_VERSION_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        DELETE(12){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new Delete(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.DeleteResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.DeleteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.DELETE;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.DELETE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.DELETE_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        DELETE_IF_VERSION(13){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new DeleteIfVersion(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.DeleteResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.DeleteResult;
            }

            @Override
            public Operation.Type getExecuteType() {
                return Operation.Type.DELETE_IF_VERSION;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.DELETE_IF_VERSION_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.DELETE_IF_VERSION_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        MULTI_DELETE(14){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiDelete(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.MultiDeleteResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.MultiDeleteResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_DELETE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_DELETE_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        EXECUTE(15){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new Execute(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.ExecuteResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.ExecuteResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.EXECUTE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.EXECUTE_CUM;
            }
        }
        ,
        MULTI_GET_TABLE(16){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetTable(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_CUM;
            }
        }
        ,
        MULTI_GET_TABLE_KEYS(17){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetTableKeys(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_CUM;
            }
        }
        ,
        TABLE_ITERATE(18){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new TableIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_ITERATOR_CUM;
            }
        }
        ,
        TABLE_KEYS_ITERATE(19){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new TableKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.KeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.KeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.STORE_KEYS_ITERATOR_CUM;
            }
        }
        ,
        INDEX_ITERATE(20){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new IndexIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IndexRowsIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IndexRowsIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.INDEX_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.INDEX_ITERATOR_CUM;
            }
        }
        ,
        INDEX_KEYS_ITERATE(21){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new IndexKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.IndexKeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.IndexKeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.INDEX_KEYS_ITERATOR_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.INDEX_KEYS_ITERATOR_CUM;
            }
        }
        ,
        MULTI_DELETE_TABLE(22){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiDeleteTable(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.MultiDeleteResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.MultiDeleteResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_DELETE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_DELETE_CUM;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        MULTI_GET_BATCH(23){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetBatchIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.BulkGetIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.BulkGetIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_BATCH_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_BATCH_CUM;
            }

            @Override
            public short requiredVersion() {
                return 8;
            }
        }
        ,
        MULTI_GET_BATCH_KEYS(24){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetBatchKeysIterate(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.BulkGetKeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.BulkGetKeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_BATCH_KEYS_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_BATCH_KEYS_CUM;
            }

            @Override
            public short requiredVersion() {
                return 8;
            }
        }
        ,
        MULTI_GET_BATCH_TABLE(25){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetBatchTable(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.BulkGetIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.BulkGetIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_BATCH_TABLE_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_BATCH_TABLE_CUM;
            }

            @Override
            public short requiredVersion() {
                return 8;
            }
        }
        ,
        MULTI_GET_BATCH_TABLE_KEYS(26){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new MultiGetBatchTableKeys(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.BulkGetKeysIterateResult((OpCode)this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.BulkGetKeysIterateResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.MULTI_GET_BATCH_TABLE_KEYS_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.MULTI_GET_BATCH_TABLE_KEYS_CUM;
            }

            @Override
            public short requiredVersion() {
                return 8;
            }
        }
        ,
        PUT_BATCH(27){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new PutBatch(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.PutBatchResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.PutBatchResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.PUT_BATCH_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.PUT_BATCH_CUM;
            }

            @Override
            public short requiredVersion() {
                return 9;
            }

            @Override
            protected boolean isWrite() {
                return true;
            }
        }
        ,
        QUERY_SINGLE_PARTITION(28){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new TableQuery(this, in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.QueryResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.QueryResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.QUERY_SINGLE_PARTITION_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.QUERY_SINGLE_PARTITION_CUM;
            }

            @Override
            public short requiredVersion() {
                return 11;
            }
        }
        ,
        QUERY_MULTI_PARTITION(29){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new TableQuery(this, in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.QueryResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.QueryResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.QUERY_MULTI_PARTITION_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.QUERY_MULTI_PARTITION_CUM;
            }

            @Override
            public short requiredVersion() {
                return 11;
            }
        }
        ,
        QUERY_MULTI_SHARD(30){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new TableQuery(this, in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.QueryResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.QueryResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.QUERY_MULTI_SHARD_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.QUERY_MULTI_SHARD_CUM;
            }

            @Override
            public short requiredVersion() {
                return 11;
            }
        }
        ,
        GET_IDENTITY(31){

            @Override
            InternalOperation readOperation(DataInput in, short serialVersion) throws IOException {
                return new GetIdentityAttrsAndValues(in, serialVersion);
            }

            @Override
            public Result readResult(DataInput in, int readKB, int writeKB, short serialVersion) throws IOException {
                return new Result.GetIdentityResult(this, readKB, writeKB, in, serialVersion);
            }

            @Override
            public boolean checkResultType(Result result) {
                return result instanceof Result.GetIdentityResult;
            }

            @Override
            public PerfStatType getIntervalMetric() {
                return PerfStatType.GET_IDENTITY_INT;
            }

            @Override
            public PerfStatType getCumulativeMetric() {
                return PerfStatType.GET_IDENTITY_CUM;
            }
        };

        private static final OpCode[] VALUES;

        private OpCode(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        abstract InternalOperation readOperation(DataInput var1, short var2) throws IOException;

        public abstract Result readResult(DataInput var1, int var2, int var3, short var4) throws IOException;

        public abstract boolean checkResultType(Result var1);

        public Operation.Type getExecuteType() {
            throw new RuntimeException("Not an execute op: " + this);
        }

        public abstract PerfStatType getIntervalMetric();

        public abstract PerfStatType getCumulativeMetric();

        public short requiredVersion() {
            return 4;
        }

        protected boolean isWrite() {
            return false;
        }

        public static OpCode readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown opcode: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = OpCode.values();
        }
    }
}

