/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ContainerCloningTest
extends AutoVerifyTestCase {
    public ContainerCloningTest() {
        this.setDescription("Test the cloneFor method on collections that are not cloneable.");
    }

    public void test() {
        CollectionContainerPolicy cp = new CollectionContainerPolicy();
        cp.setContainerClass(ClassConstants.ArrayList_class);
        List<Employee> originalC = Arrays.asList(new Employee());
        Collection cloneC = (Collection)cp.cloneFor(originalC);
        cp = new MapContainerPolicy();
        cp.setContainerClass(WeakHashMap.class);
        WeakHashMap<Integer, Integer> originalM = new WeakHashMap<Integer, Integer>();
        originalM.put(1, 2);
        Map cloneM = (Map)cp.cloneFor(originalM);
        if (originalC == cloneC || originalC.size() != cloneC.size()) {
            throw new TestErrorException("Cloned Collections are not copies.");
        }
        if (originalM == cloneM || originalM.size() != cloneM.size()) {
            throw new TestErrorException("Cloned Maps are not copies.");
        }
        if (!((Employee)originalC.iterator().next()).equals(cloneC.iterator().next())) {
            throw new TestErrorException("Cloned Collections are not the same.");
        }
        if (!originalM.get(1).equals(cloneM.get(1))) {
            throw new TestErrorException("Cloned Maps are not the same.");
        }
    }
}

