/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.interfaces.Actor;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class VariableOneToOneMappingIsNotDefinedProperlyTest
extends ExceptionTest {
    private int testMode = 0;
    VariableOneToOneMapping mapping;
    DatabaseField sourceField;
    String targetQueryKeyName;
    ObjectReferenceChangeRecord changeRecord;
    DeleteObjectQuery deleteObjectQuery;
    DatabaseRecord databaseRow;
    ClassDescriptor descriptor;
    Actor actor;

    public VariableOneToOneMappingIsNotDefinedProperlyTest(String testMode) {
        this.testMode = testMode.endsWith("IntoRow") || testMode.equalsIgnoreCase("writeFromObjectIntoRow") ? 0 : (testMode.endsWith("ChangeRecord") || testMode.equalsIgnoreCase("writeFromObjectIntoRowWithChangeRecord") ? 1 : (testMode.endsWith("WhereClause") || testMode.equalsIgnoreCase("writeFromObjectIntoRowForWhereClause") ? 2 : -1));
        this.setDescription("This tests Variable One-To-One Mapping Is Not Defined Properly (" + testMode + ") (TL-ERROR 166)");
    }

    protected void setup() {
        this.descriptor = this.getSession().getDescriptor(Actor.class);
        this.mapping = (VariableOneToOneMapping)this.descriptor.getMappingForAttributeName("program");
        this.sourceField = new DatabaseField("ACTOR.PROGRAM_ID");
        this.targetQueryKeyName = (String)this.mapping.getSourceToTargetQueryKeyNames().get(this.sourceField);
        this.mapping.addForeignQueryKeyName("ACTOR.PROGRAM_ID", "name2");
        this.mapping.getForeignKeyFields().removeElement(this.sourceField);
        this.actor = Actor.example4();
        this.databaseRow = new DatabaseRecord();
        if (this.testMode != 0) {
            if (this.testMode == 1) {
                ObjectChangeSet changeSet = new ObjectChangeSet(new Vector(), this.descriptor, (Object)this.actor, new UnitOfWorkChangeSet(), true);
                this.changeRecord = new ObjectReferenceChangeRecord(changeSet);
                this.changeRecord.setNewValue(changeSet);
            } else if (this.testMode == 2) {
                this.deleteObjectQuery = new DeleteObjectQuery((Object)this.actor);
                this.deleteObjectQuery.setSession((AbstractSession)this.getSession());
            }
        }
        this.expectedException = DescriptorException.variableOneToOneMappingIsNotDefinedProperly((DatabaseMapping)this.mapping, (ClassDescriptor)this.descriptor, (String)this.targetQueryKeyName);
    }

    @Override
    public void reset() {
        this.mapping.addForeignQueryKeyName("ACTOR.PROGRAM_ID", this.targetQueryKeyName);
        this.mapping.getForeignKeyFields().removeElement(this.sourceField);
    }

    public void test() {
        block5: {
            try {
                if (this.testMode == 0) {
                    this.mapping.writeFromObjectIntoRow((Object)this.actor, (AbstractRecord)this.databaseRow, (AbstractSession)this.getSession(), DatabaseMapping.WriteType.UNDEFINED);
                    break block5;
                }
                if (this.testMode == 1) {
                    this.mapping.writeFromObjectIntoRowWithChangeRecord((ChangeRecord)this.changeRecord, (AbstractRecord)this.databaseRow, (AbstractSession)this.getSession(), DatabaseMapping.WriteType.UNDEFINED);
                    break block5;
                }
                if (this.testMode == 2) {
                    this.mapping.writeFromObjectIntoRowForWhereClause((ObjectLevelModifyQuery)this.deleteObjectQuery, (AbstractRecord)this.databaseRow);
                    break block5;
                }
                throw new TestProblemException("Invalid method test name for VariableOneToOneMappingIsNotDefinedProperlyTest");
            }
            catch (EclipseLinkException exception) {
                this.caughtException = exception;
            }
        }
    }
}

