/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.DataOutput;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MessageOutput
implements DataOutput {
    private static final int BUFFER_SIZE = 4096;
    private final int bufferSize;
    private ByteBuffer buffer;
    private int pos = 0;
    private final List<ByteBuffer> outputs = new ArrayList<ByteBuffer>();
    private volatile int nbytesTotal = 0;
    private volatile boolean framesPolled = false;

    public MessageOutput() {
        this(4096);
    }

    public MessageOutput(int bufferSize) {
        if (bufferSize < 8) {
            throw new IllegalArgumentException();
        }
        this.bufferSize = bufferSize;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public void write(int b) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(1);
        this.buffer.put((byte)b);
        ++this.nbytesTotal;
    }

    @Override
    public void write(byte[] b) {
        this.ensureFramesNotPolled();
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureFramesNotPolled();
        if (len == 0) {
            return;
        }
        this.appendBufferedToOutput();
        this.outputs.add(ByteBuffer.wrap(b, off, len));
        this.nbytesTotal += len;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.ensureFramesNotPolled();
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.ensureFramesNotPolled();
        this.write(v);
    }

    @Override
    public void writeShort(int v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(2);
        this.buffer.putShort((short)v);
        this.nbytesTotal += 2;
    }

    @Override
    public void writeChar(int v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(2);
        this.buffer.putChar((char)v);
        this.nbytesTotal += 2;
    }

    @Override
    public void writeInt(int v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(4);
        this.buffer.putInt(v);
        this.nbytesTotal += 4;
    }

    @Override
    public void writeLong(long v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(8);
        this.buffer.putLong(v);
        this.nbytesTotal += 8;
    }

    @Override
    public void writeFloat(float v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(4);
        this.buffer.putFloat(v);
        this.nbytesTotal += 4;
    }

    @Override
    public void writeDouble(double v) {
        this.ensureFramesNotPolled();
        this.allocIfLessThan(8);
        this.buffer.putDouble(v);
        this.nbytesTotal += 8;
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUTF(String s) throws UTFDataFormatException {
        throw new UnsupportedOperationException("Use oracle.kv.impl.util.SerializationUtil.writeString");
    }

    public int size() {
        return this.nbytesTotal;
    }

    public Queue<List<ByteBuffer>> pollFrames(int frameSize) {
        if (frameSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.ensureFramesNotPolled();
        this.framesPolled = true;
        this.appendBufferedToOutput();
        LinkedList<List<ByteBuffer>> frames = new LinkedList<List<ByteBuffer>>();
        if (this.outputs.isEmpty()) {
            return frames;
        }
        ArrayList<ByteBuffer> curr = new ArrayList<ByteBuffer>();
        int size = 0;
        frames.add(curr);
        for (ByteBuffer buf : this.outputs) {
            int remaining;
            int inc = buf.remaining();
            if (size + inc <= frameSize) {
                curr.add(buf);
                size += inc;
                continue;
            }
            while ((remaining = buf.remaining()) != 0) {
                if (size == frameSize) {
                    curr = new ArrayList();
                    size = 0;
                    frames.add(curr);
                }
                inc = Math.min(remaining, frameSize - size);
                int newPos = buf.position() + inc;
                ByteBuffer chunk = buf.duplicate();
                chunk.limit(newPos);
                curr.add(chunk);
                size += inc;
                buf.position(newPos);
            }
        }
        this.outputs.clear();
        return frames;
    }

    private void allocIfLessThan(int val) {
        if (val > this.bufferSize) {
            throw new AssertionError();
        }
        if (this.buffer.remaining() >= val) {
            return;
        }
        this.appendBufferedToOutput();
        this.buffer = ByteBuffer.allocate(Math.max(val, this.bufferSize));
        this.pos = 0;
    }

    private void appendBufferedToOutput() {
        int currpos = this.buffer.position();
        assert (this.buffer.limit() == this.buffer.capacity() && this.pos <= currpos);
        if (this.pos == currpos) {
            return;
        }
        ByteBuffer chunk = this.buffer.duplicate();
        chunk.position(this.pos);
        chunk.limit(currpos);
        this.outputs.add(chunk);
        this.pos = currpos;
    }

    private void ensureFramesNotPolled() {
        if (this.framesPolled) {
            throw new AssertionError((Object)"Frames polled");
        }
    }
}

