/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.ExprCase;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprMapConstr;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprUpdateField
extends Expr {
    private Expr.UpdateKind theUpdateKind;
    private Expr theInput;
    private Expr thePosExpr;
    private ExprVar theTargetItemVar;
    private Expr theNewValueExpr;
    private boolean theCloneNewValues = true;

    ExprUpdateField(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Expr input) {
        super(qcb, sctx, Expr.ExprKind.UPDATE_FIELD, location);
        if (input != null) {
            this.theInput = input;
            this.theInput.addParent(this);
        }
        this.theType = TypeManager.EMPTY();
    }

    void setUpdateKind(Expr.UpdateKind k) {
        this.theUpdateKind = k;
        if (this.theUpdateKind == Expr.UpdateKind.REMOVE) {
            this.theCloneNewValues = false;
            if (this.theInput.getType().isRecord()) {
                throw new QueryException("Cannot remove fields from records.", this.theLocation);
            }
        }
    }

    Expr.UpdateKind getUpdateKind() {
        return this.theUpdateKind;
    }

    boolean isTTLUpdate() {
        return this.theUpdateKind == Expr.UpdateKind.TTL_HOURS || this.theUpdateKind == Expr.UpdateKind.TTL_DAYS || this.theUpdateKind == Expr.UpdateKind.TTL_TABLE;
    }

    void addTargetItemVar(ExprVar v) {
        this.theTargetItemVar = v;
    }

    void addNewValueExpr(Expr e) {
        if (this.theUpdateKind == Expr.UpdateKind.SET && e.isMultiValued()) {
            ArrayList<Expr> args = new ArrayList<Expr>(1);
            args.add(e);
            e = new ExprArrayConstr(this.theQCB, this.theSctx, e.getLocation(), args, true);
        }
        this.theNewValueExpr = e;
        this.theNewValueExpr.addParent(this);
        this.theCloneNewValues = ExprUpdateField.mustCloneNewValues(e, this.theTargetItemVar, false);
    }

    void addPosExpr(Expr e) {
        this.thePosExpr = e;
        this.thePosExpr.addParent(this);
    }

    void removeTargetItemVar() {
        if (this.theTargetItemVar.getNumParents() == 0) {
            this.theTargetItemVar = null;
        }
    }

    void setPosExpr(Expr newExpr, boolean destroy) {
        this.thePosExpr.removeParent(this, destroy);
        this.thePosExpr = newExpr;
        newExpr.addParent(this);
        this.removeTargetItemVar();
    }

    void setNewValueExpr(Expr newExpr, boolean destroy) {
        this.theNewValueExpr.removeParent(this, destroy);
        this.theNewValueExpr = newExpr;
        newExpr.addParent(this);
        this.removeTargetItemVar();
        this.theCloneNewValues = ExprUpdateField.mustCloneNewValues(newExpr, this.theTargetItemVar, false);
    }

    @Override
    int getNumChildren() {
        return this.theInput == null ? 0 : (this.theNewValueExpr != null ? (this.thePosExpr != null ? 3 : 2) : 1);
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    Expr getPosExpr() {
        return this.thePosExpr;
    }

    Expr getNewValueExpr() {
        return this.theNewValueExpr;
    }

    ExprVar getTargetItemVar() {
        return this.theTargetItemVar;
    }

    boolean cloneNewValues() {
        return this.theCloneNewValues;
    }

    private static boolean mustCloneNewValues(Expr expr, Expr targetItemVar, boolean inPathExpr) {
        if (expr.getType().getDef().isAtomic()) {
            return false;
        }
        switch (expr.getKind()) {
            case CONST: {
                return false;
            }
            case VAR: {
                ExprVar var = (ExprVar)expr;
                return var.getTable() != null || var == targetItemVar && !inPathExpr;
            }
            case FUNC_CALL: {
                if (expr.getFunction(FunctionLib.FuncCode.FN_SEQ_CONCAT) != null) {
                    ExprFuncCall fncall = (ExprFuncCall)expr;
                    for (int i = 0; i < fncall.getNumArgs(); ++i) {
                        if (!ExprUpdateField.mustCloneNewValues(fncall.getArg(i), targetItemVar, inPathExpr)) continue;
                        return true;
                    }
                    return false;
                }
                Function func = expr.getFunction(null);
                throw new QueryStateException("Unexpected function call: " + (Object)((Object)func.getCode()));
            }
            case PROMOTE: 
            case CAST: 
            case SEQ_MAP: {
                return ExprUpdateField.mustCloneNewValues(expr.getInput(), targetItemVar, inPathExpr);
            }
            case CASE: {
                ExprCase caseExpr = (ExprCase)expr;
                for (int i = 0; i < caseExpr.getNumWhenClauses(); ++i) {
                    if (!ExprUpdateField.mustCloneNewValues(caseExpr.getThenExpr(i), targetItemVar, inPathExpr)) continue;
                    return true;
                }
                return caseExpr.getElseExpr() != null && ExprUpdateField.mustCloneNewValues(caseExpr.getElseExpr(), targetItemVar, inPathExpr);
            }
            case ARRAY_CONSTR: {
                ExprArrayConstr arr = (ExprArrayConstr)expr;
                for (int i = 0; i < arr.getNumArgs(); ++i) {
                    if (!ExprUpdateField.mustCloneNewValues(arr.getArg(i), targetItemVar, inPathExpr)) continue;
                    return true;
                }
                return false;
            }
            case MAP_CONSTR: {
                ExprMapConstr map = (ExprMapConstr)expr;
                for (int i = 0; i < map.getNumArgs(); ++i) {
                    if (i % 2 == 0 || !ExprUpdateField.mustCloneNewValues(map.getArg(i), targetItemVar, inPathExpr)) continue;
                    return true;
                }
                return false;
            }
            case FIELD_STEP: 
            case MAP_FILTER: 
            case ARRAY_SLICE: 
            case ARRAY_FILTER: {
                return ExprUpdateField.mustCloneNewValues(expr.getInput(), targetItemVar, true);
            }
            case BASE_TABLE: 
            case IS_OF_TYPE: 
            case SFW: 
            case REC_CONSTR: 
            case INSERT_ROW: 
            case DELETE_ROW: 
            case UPDATE_ROW: 
            case UPDATE_FIELD: 
            case RECEIVE: 
            case SORT: {
                throw new QueryStateException("Unexpected expression kind: " + (Object)((Object)expr.getKind()));
            }
        }
        return true;
    }

    @Override
    public ExprType computeType() {
        return this.theType;
    }

    @Override
    public boolean mayReturnNULL() {
        return false;
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        if (this.theInput != null) {
            this.theInput.display(sb, formatter);
        }
        if (this.theTargetItemVar != null) {
            sb.append("\n");
            this.theTargetItemVar.display(sb, formatter);
        }
        if (this.theNewValueExpr != null) {
            sb.append("\n");
            this.theNewValueExpr.display(sb, formatter);
        }
    }
}

