/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.topo.RepNodeId;

public class ResourceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RepNodeId rnId;
    private final int topoSeqNum;
    private final Set<RateRecord> rateRecords;

    public ResourceInfo(RepNodeId rnId, int topoSeqNum, Set<RateRecord> rateRecords) {
        this.rnId = rnId;
        this.topoSeqNum = topoSeqNum;
        this.rateRecords = rateRecords != null && rateRecords.isEmpty() ? null : rateRecords;
    }

    public RepNodeId getRepNodeId() {
        return this.rnId;
    }

    public int getTopoSeqNum() {
        return this.topoSeqNum;
    }

    public Set<RateRecord> getRateRecords() {
        if (this.rateRecords == null) {
            return Collections.emptySet();
        }
        return this.rateRecords;
    }

    public String toString() {
        return "ResourceInfo[" + this.rnId + ", " + this.topoSeqNum + ", " + this.getRateRecords().size() + "]";
    }

    public static class UsageRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long tableId;
        private final int readRate;
        private final int writeRate;
        private final long size;

        public UsageRecord(long tableId, int readKB, int writeKB) {
            this.tableId = tableId;
            this.readRate = readKB;
            this.writeRate = writeKB;
            this.size = -1L;
        }

        public UsageRecord(long tableId, long size) {
            assert (size >= 0L);
            this.tableId = tableId;
            this.size = size;
            this.readRate = -1;
            this.writeRate = -1;
        }

        public long getTableId() {
            return this.tableId;
        }

        public int getReadRate() {
            return this.readRate;
        }

        public int getWriteRate() {
            return this.writeRate;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            return "UsageRecord[" + this.tableId + ", " + this.readRate + ", " + this.writeRate + ", " + this.size + "]";
        }
    }

    public static class RateRecord
    implements Comparable<RateRecord>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long tableId;
        private final long second;
        private final int readKB;
        private final int writeKB;
        private final int readLimitKBSec;
        private final int writeLimitKBSec;

        public RateRecord(TableImpl table, long second, int readKB, int writeKB) {
            this.tableId = table.getId();
            this.second = second;
            this.readKB = readKB;
            this.writeKB = writeKB;
            TableLimits limits = table.getTableLimits();
            assert (limits != null);
            assert (limits.hasLimits());
            this.readLimitKBSec = limits.getReadLimit();
            this.writeLimitKBSec = limits.getWriteLimit();
        }

        public long getTableId() {
            return this.tableId;
        }

        public long getSecond() {
            return this.second;
        }

        public int getReadLimitKB() {
            return this.readLimitKBSec;
        }

        public int getWriteLimitKB() {
            return this.writeLimitKBSec;
        }

        public int getReadKB() {
            return this.readKB;
        }

        public int getWriteKB() {
            return this.writeKB;
        }

        @Override
        public int compareTo(RateRecord other) {
            int ret = (int)(this.second - other.second);
            return ret == 0 ? 1 : ret;
        }

        public String toString() {
            return "RateRecord[" + this.tableId + ", " + this.second + ", " + this.readKB + ", " + this.writeKB + "]";
        }
    }
}

