/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import oracle.kv.impl.async.AsyncVersionedRemote;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.util.SerialVersion;

public class AsyncVersionedRemoteAPI {
    private final short serialVersion;

    protected AsyncVersionedRemoteAPI(short serialVersion) {
        this.serialVersion = serialVersion;
    }

    public short getSerialVersion() {
        return this.serialVersion;
    }

    protected static void computeSerialVersion(AsyncVersionedRemote initiator, long timeoutMillis, ResultHandler<Short> handler) {
        class SerialVersionResultHandler
        implements ResultHandler<Short> {
            final /* synthetic */ ResultHandler val$handler;

            SerialVersionResultHandler(ResultHandler resultHandler) {
                this.val$handler = resultHandler;
            }

            @Override
            public void onResult(Short serialVersion, Throwable exception) {
                if (exception != null) {
                    this.val$handler.onResult(null, exception);
                } else if (serialVersion < SerialVersion.MINIMUM) {
                    this.val$handler.onResult(null, SerialVersion.serverUnsupportedException(serialVersion, SerialVersion.MINIMUM));
                } else {
                    this.val$handler.onResult((short)Math.min(SerialVersion.CURRENT, serialVersion.shortValue()), null);
                }
            }

            public String toString() {
                return this.val$handler.toString();
            }
        }
        initiator.getSerialVersion(SerialVersion.CURRENT, timeoutMillis, new SerialVersionResultHandler(handler));
    }
}

