/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.CommandResult;
import oracle.kv.impl.admin.DdlResultsReport;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.client.admin.ClientAdminService;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.client.admin.ExecutionInfoImpl;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.test.ExceptionTestHook;
import oracle.kv.impl.test.ExceptionTestHookExecute;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.impl.util.registry.RemoteAPI;
import oracle.kv.util.ErrorMessage;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;

public class ClientAdminServiceAPI
extends RemoteAPI {
    public static final short STATEMENT_RESULT_VERSION = 7;
    private static final AuthContext NULL_CTX = null;
    private final ClientAdminService proxyRemote;
    public static ExceptionTestHook<String, RemoteException> REMOTE_FAULT_HOOK;

    private ClientAdminServiceAPI(ClientAdminService remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
    }

    public static ClientAdminServiceAPI wrap(ClientAdminService remote, LoginHandle loginHdl) throws RemoteException {
        return new ClientAdminServiceAPI(remote, loginHdl);
    }

    public ExecutionInfo execute(char[] statement, String namespace, boolean validateNamespace, TableLimits limits, LogContext lc) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "execute"));
        if (limits != null) {
            this.checkMethodSupported((short)16);
        }
        if (namespace != null) {
            this.checkMethodSupported((short)14);
        }
        if (this.getSerialVersion() < 14) {
            return this.convertInfo(this.proxyRemote.execute(new String(statement), NULL_CTX, this.getSerialVersion()));
        }
        if (this.getSerialVersion() < 15) {
            return this.convertInfo(this.proxyRemote.execute(new String(statement), namespace, NULL_CTX, this.getSerialVersion()));
        }
        if (this.getSerialVersion() < 16) {
            return this.convertInfo(this.proxyRemote.execute(statement, namespace, NULL_CTX, this.getSerialVersion()));
        }
        if (this.getSerialVersion() < 18) {
            return this.convertInfo(this.proxyRemote.execute(statement, namespace, limits, lc, NULL_CTX, this.getSerialVersion()));
        }
        return this.convertInfo(this.proxyRemote.execute(statement, namespace, validateNamespace, limits, lc, NULL_CTX, this.getSerialVersion()));
    }

    public ExecutionInfo setTableLimits(String namespace, String tableName, TableLimits limits) throws RemoteException {
        this.checkMethodSupported((short)16);
        return this.proxyRemote.setTableLimits(namespace, tableName, limits, NULL_CTX, this.getSerialVersion());
    }

    public ExecutionInfo getExecutionStatus(int planId) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "getExecutionStatus"));
        return this.proxyRemote.getExecutionStatus(planId, NULL_CTX, this.getSerialVersion());
    }

    public boolean canHandleDDL() throws RemoteException {
        return this.proxyRemote.canHandleDDL(NULL_CTX, this.getSerialVersion());
    }

    public URI getMasterRmiAddress() throws RemoteException {
        return this.proxyRemote.getMasterRmiAddress(NULL_CTX, this.getSerialVersion());
    }

    public ExecutionInfo interruptAndCancel(int planId) throws RemoteException {
        assert (ExceptionTestHookExecute.doHookIfSet(REMOTE_FAULT_HOOK, "interruptAndCancel"));
        return this.proxyRemote.interruptAndCancel(planId, NULL_CTX, this.getSerialVersion());
    }

    private ExecutionInfo convertInfo(ExecutionInfo execInfo) {
        if (this.getSerialVersion() < 7) {
            String jsonInfo = execInfo.getJSONInfo();
            boolean showResult = false;
            try {
                JsonParser parser = JsonUtils.createJsonParser(new StringBufferInputStream(jsonInfo));
                JsonNode json = parser.readValueAsTree();
                String type = JsonUtils.getAsText(json, "type");
                if (type != null && (type.equals("show") || type.equals("describe"))) {
                    showResult = true;
                }
            }
            catch (IOException ignore) {
                showResult = true;
            }
            if (showResult) {
                return new ExecutionInfoImpl(execInfo.getPlanId(), execInfo.isTerminated(), "Statement completed.", DdlResultsReport.STATEMENT_COMPLETED_JSON, execInfo.isSuccess(), execInfo.isCancelled(), execInfo.getErrorMessage(), execInfo.needsTermination(), execInfo.getJSONInfo());
            }
        }
        return execInfo;
    }

    private void checkMethodSupported(short expectVersion) throws UnsupportedOperationException {
        if (this.getSerialVersion() < expectVersion) {
            String errMsg = "Command not available because service has not yet been upgraded.  (Internal local version=" + expectVersion + ", internal service version=" + this.getSerialVersion() + ")";
            throw new AdminFaultException(new UnsupportedOperationException(errMsg), errMsg, ErrorMessage.NOSQL_5200, CommandResult.NO_CLEANUP_JOBS);
        }
    }
}

