/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.ExternalizableDelegator;
import commonj.sdo.impl.HelperProvider;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Field;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.sdo.AbstractExternalizableDelegator;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.DataObjectInputStream;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;

public class SDOExternalizableDelegator
extends AbstractExternalizableDelegator {
    static final PrivilegedGetField privilegedGetDelegateField = new PrivilegedGetField(AbstractExternalizableDelegator.class, "delegate", true);

    public SDOExternalizableDelegator() {
    }

    public SDOExternalizableDelegator(Object target) {
        super(target);
    }

    public SDOExternalizableDelegator(Object target, HelperContext aContext) {
        if (aContext instanceof SDOHelperContext) {
            this.setDelegate(((SDOHelperContext)aContext).createResolvable(target));
        } else {
            this.setDelegate(HelperProvider.createResolvable(target));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in instanceof DataObjectInputStream) {
            this.getDelegate().setHelperContext(((DataObjectInputStream)in).getHelperContext());
        }
        super.readExternal(in);
    }

    private SDOResolvable getDelegate() {
        try {
            Field delegateField = privilegedGetDelegateField.run();
            PrivilegedGetValueFromField privilegedGetValueFromDelegateField = new PrivilegedGetValueFromField(delegateField, (Object)this);
            return (SDOResolvable)privilegedGetValueFromDelegateField.run();
        }
        catch (NoSuchFieldException nsfException) {
            throw SDOException.errorAccessingExternalizableDelegator((String)"delegate", (Exception)nsfException);
        }
        catch (IllegalAccessException iaException) {
            throw SDOException.errorAccessingExternalizableDelegator((String)"delegate", (Exception)iaException);
        }
    }

    private void setDelegate(ExternalizableDelegator.Resolvable resolvable) {
        try {
            Field delegateField = privilegedGetDelegateField.run();
            PrivilegedSetValueInField privilegedSetValueInDelegateField = new PrivilegedSetValueInField(delegateField, (Object)this, (Object)resolvable);
            privilegedSetValueInDelegateField.run();
        }
        catch (NoSuchFieldException nsfException) {
            throw SDOException.errorAccessingExternalizableDelegator((String)"delegate", (Exception)nsfException);
        }
        catch (IllegalAccessException iaException) {
            throw SDOException.errorAccessingExternalizableDelegator((String)"delegate", (Exception)iaException);
        }
    }
}

