/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ResourceLimitException;

public class TableAccessException
extends ResourceLimitException {
    private static final long serialVersionUID = 1L;
    private final boolean readAllowed;

    public TableAccessException(String tableName, boolean readAllowed, String msg) {
        super(tableName, msg);
        assert (tableName != null);
        this.readAllowed = readAllowed;
    }

    public TableAccessException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.readAllowed = in.readBoolean();
    }

    public boolean getReadAllowed() {
        return this.readAllowed;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeBoolean(this.readAllowed);
    }
}

