/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CodeGenerator;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.FieldDef;

class FuncAvg
extends Function {
    FuncAvg() {
        super(FunctionLib.FuncCode.FN_AVG, "avg", TypeManager.ANY_STAR(), TypeManager.ANY_ATOMIC_ONE());
    }

    @Override
    ExprType getRetType(ExprFuncCall caller) {
        FieldDefImpl inType = caller.getInput().getType().getDef();
        FieldDef.Type inTypeCode = inType.getType();
        switch (inTypeCode) {
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return TypeManager.DOUBLE_ONE();
            }
            case NUMBER: {
                return TypeManager.NUMBER_ONE();
            }
            case ANY: 
            case JSON: 
            case ANY_ATOMIC: 
            case ANY_JSON_ATOMIC: {
                return this.theReturnType;
            }
        }
        throw new QueryException("Invalid input type for the avg aggregate function:\n" + inType.getDDLString(), caller.getLocation());
    }

    @Override
    boolean mayReturnNULL(ExprFuncCall caller) {
        return true;
    }

    @Override
    boolean isAggregate() {
        return true;
    }

    @Override
    Expr normalizeCall(ExprFuncCall fncall) {
        ExprType inType = fncall.getArg(0).getType();
        if (!inType.isNumeric() && !inType.isWildcard()) {
            throw new QueryException("Invalid input type for the avg aggregate function:\n" + inType.getDef().getDDLString(), fncall.getLocation());
        }
        return fncall;
    }

    @Override
    PlanIter codegen(CodeGenerator codegen, ExprFuncCall caller, PlanIter[] argIters) {
        throw new QueryStateException("No iterator for avg function");
    }
}

