/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.api.table.AddIndex;
import oracle.kv.impl.api.table.AddNamespaceChange;
import oracle.kv.impl.api.table.AddTable;
import oracle.kv.impl.api.table.DropIndex;
import oracle.kv.impl.api.table.DropTable;
import oracle.kv.impl.api.table.EvolveTable;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.IdentityColumnInfo;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.NameUtils;
import oracle.kv.impl.api.table.RemoveNamespaceChange;
import oracle.kv.impl.api.table.TableChange;
import oracle.kv.impl.api.table.TableChangeList;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableLimit;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.api.table.UpdateIndexStatus;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataKey;
import oracle.kv.impl.security.Ownable;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Index;
import oracle.kv.table.Table;
import oracle.kv.table.TimeToLive;

public class TableMetadata
implements TableMetadataHelper,
Metadata<TableChangeList>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, NamespaceImpl> namespaces;
    private final Map<String, Table> tables = new TreeMap<String, Table>(FieldComparator.instance);
    private int seqNum = 0;
    private long keyId = 1L;
    public static final int INITIAL_KEY_ID = 1;
    private final List<TableChange> changeHistory;

    public TableMetadata(boolean keepChanges) {
        this.changeHistory = keepChanges ? new LinkedList() : null;
    }

    public TableImpl addTable(String namespace, String name, String parentName, List<String> primaryKey, List<Integer> primaryKeySizes, List<String> shardKey, FieldMap fieldMap, TimeToLive ttl, TableLimits limits, boolean r2compat, int schemaId, String description, ResourceOwner owner) {
        return this.addTable(namespace, name, parentName, primaryKey, primaryKeySizes, shardKey, fieldMap, ttl, limits, r2compat, schemaId, description, owner, false, null);
    }

    public TableImpl addTable(String namespace, String name, String parentName, List<String> primaryKey, List<Integer> primaryKeySizes, List<String> shardKey, FieldMap fieldMap, TimeToLive ttl, TableLimits limits, boolean r2compat, int schemaId, String description, ResourceOwner owner, boolean sysTable, IdentityColumnInfo identityColumnInfo) {
        TableImpl table = this.insertTable(namespace, name, parentName, primaryKey, primaryKeySizes, shardKey, fieldMap, ttl, limits, r2compat, schemaId, description, owner, sysTable, identityColumnInfo);
        this.addTableChange(table);
        return table;
    }

    private void addTableChange(TableImpl table) {
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new AddTable(table, this.seqNum));
        }
    }

    public void dropTable(String namespace, String tableName, boolean markForDelete) {
        this.removeTable(namespace, tableName, markForDelete);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new DropTable(namespace, tableName, markForDelete, this.seqNum));
        }
    }

    public boolean evolveTable(TableImpl table, int tableVersion, FieldMap fieldMap, TimeToLive ttl, String description, boolean systemTable, IdentityColumnInfo newIdentityColumnInfo) {
        if (table.isSystemTable() != systemTable) {
            if (systemTable) {
                throw new IllegalCommandException("Table " + NameUtils.makeQualifiedName(null, null, table.getName()) + " is not system table");
            }
            throw new IllegalCommandException("Cannot evolve table " + NameUtils.makeQualifiedName(null, null, table.getName()));
        }
        if (fieldMap.equals(table.getFieldMap()) && TableImpl.compareTTL(ttl, table.getDefaultTTL()) && TableImpl.compareIdentityColumn(table.getIdentityColumnInfo(), newIdentityColumnInfo)) {
            return false;
        }
        if (tableVersion != table.numTableVersions()) {
            throw new IllegalCommandException("Table evolution must be performed on the latest version, version supplied is " + tableVersion + ", latest is " + table.numTableVersions());
        }
        table.evolve(fieldMap, ttl, description, newIdentityColumnInfo, null);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new EvolveTable(table, this.seqNum));
        }
        return true;
    }

    public void setLimits(TableImpl table, TableLimits newLimits) {
        table.setTableLimits(newLimits);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new TableLimit(table, this.seqNum));
        }
    }

    public void addIndex(String namespace, String indexName, String tableName, List<String> fields, List<FieldDef.Type> types, String description) {
        this.insertIndex(namespace, indexName, tableName, fields, types, description);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new AddIndex(namespace, indexName, tableName, fields, types, description, this.seqNum));
        }
    }

    public void addTextIndex(String namespace, String indexName, String tableName, List<IndexImpl.AnnotatedField> fields, Map<String, String> properties, String description) {
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        HashMap<String, String> annotations = new HashMap<String, String>(fields.size());
        IndexImpl.populateMapFromAnnotatedFields(fields, fieldNames, annotations);
        this.insertTextIndex(namespace, indexName, tableName, fieldNames, annotations, properties, description);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new AddIndex(namespace, indexName, tableName, fieldNames, annotations, properties, description, this.seqNum));
        }
    }

    public void dropIndex(String namespace, String indexName, String tableName) {
        if (this.removeIndex(namespace, indexName, tableName)) {
            this.bumpSeqNum();
            if (this.changeHistory != null) {
                this.changeHistory.add(new DropIndex(namespace, indexName, tableName, this.seqNum));
            }
        }
    }

    public boolean updateIndexStatus(String namespace, String indexName, String tableName, IndexImpl.IndexStatus status) {
        IndexImpl index = this.changeIndexStatus(namespace, indexName, tableName, status);
        if (index != null) {
            this.bumpSeqNum();
            if (this.changeHistory != null) {
                this.changeHistory.add(new UpdateIndexStatus(index, this.seqNum));
            }
            return true;
        }
        return false;
    }

    TableImpl insertTable(String namespace, String name, String parentName, List<String> primaryKey, List<Integer> primaryKeySizes, List<String> shardKey, FieldMap fields, TimeToLive ttl, TableLimits limits, boolean r2compat, int schemaId, String description, ResourceOwner owner, boolean sysTable, IdentityColumnInfo identityColumnInfo) {
        TableImpl table = null;
        if (r2compat) {
            this.verifyIdNotUsed(name);
        }
        if (parentName != null) {
            TableImpl parent = this.getTable(namespace, parentName, true);
            if (parent.childTableExists(name)) {
                throw new IllegalArgumentException("Cannot create table.  Table exists: " + NameUtils.makeQualifiedName(namespace, name, parentName));
            }
            if (parent.isSystemTable() != sysTable) {
                throw new IllegalArgumentException("Cannot create table " + name + ". It must" + (sysTable ? " not" : "") + " be a system table, because its parent is " + (sysTable ? "" : " not") + " a system table");
            }
            parent.checkChildLimit(name);
            table = TableImpl.createTable(namespace, name, parent, primaryKey, primaryKeySizes, shardKey, fields, r2compat, schemaId, description, true, owner, ttl, limits, sysTable, identityColumnInfo);
            table.setId(this.allocateId());
            parent.getMutableChildTables().put(name, table);
        } else {
            String namespaceName = NameUtils.makeQualifiedName(namespace, name);
            if (this.tables.containsKey(namespaceName)) {
                throw new IllegalArgumentException("Cannot create table.  Table exists: " + namespaceName);
            }
            table = TableImpl.createTable(namespace, name, null, primaryKey, primaryKeySizes, shardKey, fields, r2compat, schemaId, description, true, owner, ttl, limits, sysTable, identityColumnInfo);
            table.setId(this.allocateId());
            this.tables.put(namespaceName, table);
        }
        return table;
    }

    TableImpl evolveTable(String namespace, String tableName, FieldMap fields, TimeToLive ttl, String description, IdentityColumnInfo identityColumnInfo) {
        TableImpl table = this.getTable(namespace, tableName, true);
        table.evolve(fields, ttl, description, identityColumnInfo, null);
        return table;
    }

    Table removeTable(String namespace, String tableName, boolean markForDelete) {
        TableImpl table = this.checkForRemove(namespace, tableName, false);
        if (markForDelete) {
            table.setStatus(TableImpl.TableStatus.DELETING);
            return table;
        }
        Table parent = table.getParent();
        if (parent != null) {
            ((TableImpl)parent).getMutableChildTables().remove(table.getName());
        } else {
            this.tables.remove(NameUtils.makeQualifiedName(namespace, table.getName()));
        }
        return table;
    }

    public TableImpl checkForRemove(String namespace, String tableName, boolean indexesAllowed, boolean childTablesAllowed) {
        TableImpl table = this.getTable(namespace, tableName, true);
        String qname = NameUtils.makeQualifiedName(namespace, null, tableName);
        if (table == null) {
            throw new IllegalCommandException("Table " + qname + " does not exist");
        }
        if (table.isSystemTable()) {
            throw new IllegalCommandException("Cannot remove system table: " + qname);
        }
        if (!childTablesAllowed && !table.getChildTables().isEmpty()) {
            throw new IllegalCommandException("Cannot remove table " + qname + ", it is still referenced by child tables");
        }
        if (!indexesAllowed && !table.getIndexes().isEmpty()) {
            throw new IllegalCommandException("Cannot remove table " + qname + ", it still contains indexes");
        }
        return table;
    }

    public TableImpl checkForRemove(String namespace, String tableName, boolean indexesAllowed) {
        return this.checkForRemove(namespace, tableName, indexesAllowed, false);
    }

    IndexImpl insertIndex(String namespace, String indexName, String tableName, List<String> fields, List<FieldDef.Type> types, String description) {
        TableImpl table = this.getTable(namespace, tableName, true);
        if (table.isSystemTable()) {
            throw new IllegalCommandException("Cannot add index " + indexName + " on system table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        if (table.isDeleting()) {
            throw new IllegalCommandException("Cannot add index " + indexName + " on table: " + NameUtils.makeQualifiedName(namespace, null, tableName) + ", it is being removed");
        }
        if (table.getIndex(indexName) != null) {
            throw new IllegalArgumentException("Index exists: " + indexName + " on table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        IndexImpl index = new IndexImpl(indexName, table, fields, types, description);
        index.setStatus(IndexImpl.IndexStatus.POPULATING);
        table.addIndex(index);
        return index;
    }

    boolean removeIndex(String namespace, String indexName, String tableName) {
        TableImpl table = this.getTable(namespace, tableName, true);
        if (table.isSystemTable()) {
            throw new IllegalCommandException("Cannot remove index " + indexName + " on system table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        Index index = table.getIndex(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Index does not exist: " + indexName + " on table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        table.removeIndex(indexName);
        return true;
    }

    IndexImpl changeIndexStatus(String namespace, String indexName, String tableName, IndexImpl.IndexStatus status) {
        TableImpl table = this.getTable(namespace, tableName, true);
        IndexImpl index = (IndexImpl)table.getIndex(indexName);
        if (index == null) {
            throw new IllegalArgumentException("Index does not exist: " + indexName + " on table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        if (index.getStatus() == status) {
            return null;
        }
        index.setStatus(status);
        return index;
    }

    IndexImpl insertTextIndex(String namespace, String indexName, String tableName, List<String> fields, Map<String, String> annotations, Map<String, String> properties, String description) {
        TableImpl table = this.getTable(namespace, tableName, true);
        if (table.isSystemTable()) {
            throw new IllegalCommandException("Cannot add text index " + indexName + " on table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        if (table.getTextIndex(indexName) != null) {
            throw new IllegalArgumentException("Text Index exists: " + indexName + " on table: " + NameUtils.makeQualifiedName(namespace, null, tableName));
        }
        IndexImpl index = new IndexImpl(indexName, table, fields, null, annotations, properties, description);
        index.setStatus(IndexImpl.IndexStatus.POPULATING);
        table.addIndex(index);
        return index;
    }

    public TableImpl getTable(String namespace, String tableName, boolean mustExist) {
        String[] path = TableImpl.parseFullName(tableName);
        return this.getTable(namespace, path, mustExist);
    }

    public TableImpl getTable(String tableName) {
        String namespace = NameUtils.getNamespaceFromQualifiedName(tableName);
        String fullTableName = NameUtils.getFullNameFromQualifiedName(tableName);
        return this.getTable(namespace, fullTableName);
    }

    public TableImpl getTable(String namespace, String tableName, String parentName) {
        StringBuilder sb = new StringBuilder();
        if (parentName != null) {
            sb.append(parentName).append('.');
        }
        if (tableName != null) {
            sb.append(tableName);
        }
        return this.getTable(namespace, sb.toString(), false);
    }

    @Override
    public TableImpl getTable(String namespace, String tableName) {
        return this.getTable(namespace, tableName, false);
    }

    @Override
    public TableImpl getTable(String namespace, String[] tablePath, int cost) {
        return this.getTable(namespace, tablePath, false);
    }

    public TableImpl getTable(String namespace, String[] path, boolean mustExist) {
        if (path == null || path.length == 0) {
            return null;
        }
        String firstKey = NameUtils.makeQualifiedName(namespace, path[0]);
        TableImpl targetTable = (TableImpl)this.tables.get(firstKey);
        if (path.length > 1) {
            for (int i = 1; i < path.length && targetTable != null; ++i) {
                try {
                    targetTable = this.getChildTable(path[i], targetTable);
                    continue;
                }
                catch (IllegalArgumentException ignored) {
                    targetTable = null;
                    break;
                }
            }
        }
        if (targetTable == null && mustExist) {
            throw new IllegalArgumentException("Table: " + TableMetadata.makeQualifiedName(namespace, path) + " does not exist in " + this);
        }
        return targetTable;
    }

    public boolean tableExists(String namespace, String tableName, String parentName) {
        return this.getTable(namespace, tableName, parentName) != null;
    }

    public Index getIndex(String namespace, String tableName, String indexName) {
        TableImpl table = this.getTable(namespace, tableName);
        if (table != null) {
            return table.getIndex(indexName);
        }
        return null;
    }

    public Index getTextIndex(String namespace, String tableName, String indexName) {
        TableImpl table = this.getTable(namespace, tableName);
        if (table != null) {
            return table.getTextIndex(indexName);
        }
        return null;
    }

    private static String makeQualifiedName(String namespace, String[] pathName) {
        StringBuilder sb = new StringBuilder();
        for (String step : pathName) {
            sb.append(step);
        }
        return NameUtils.makeQualifiedName(namespace, null, sb.toString());
    }

    public TableImpl getChildTable(String tableName, Table parent) {
        return (TableImpl)parent.getChildTable(tableName);
    }

    public TableImpl getTable(TableMetadataKey mdKey) {
        String tableName = NameUtils.getFullNameFromQualifiedName(mdKey.getTableName());
        String namespace = NameUtils.getNamespaceFromQualifiedName(mdKey.getTableName());
        TableImpl table = this.getTable(namespace, tableName);
        if (table != null && table.getIndexes().size() > 0) {
            table = table.clone();
            Iterator<Map.Entry<String, Index>> it = table.getMutableIndexes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Index> entry = it.next();
                if (((IndexImpl)entry.getValue()).getStatus().isReady()) continue;
                it.remove();
            }
        }
        return table;
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }

    public Map<String, Table> getTables(String namespace) {
        if (namespace == null) {
            return this.tables;
        }
        TreeMap<String, Table> nsTables = new TreeMap<String, Table>(FieldComparator.instance);
        String prefix = namespace + ":";
        for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith(prefix.toLowerCase())) continue;
            nsTables.put(NameUtils.getFullNameFromQualifiedName(entry.getKey()), entry.getValue());
        }
        return nsTables;
    }

    public List<String> listTables(String namespace) {
        List<String> list = this.listTables(namespace, true);
        Collections.sort(list);
        return list;
    }

    public List<String> listTables(final String namespace, final boolean allTables) {
        final ArrayList<String> tableList = new ArrayList<String>();
        this.iterateTables(new TableMetadataIteratorCallback(){

            @Override
            public boolean tableCallback(Table table) {
                if (namespace != null && namespace.equalsIgnoreCase(((TableImpl)table).getInternalNamespace())) {
                    tableList.add(table.getFullName());
                } else if (namespace == null) {
                    if (allTables) {
                        tableList.add(table.getFullNamespaceName());
                    } else if (((TableImpl)table).getInternalNamespace() == null) {
                        tableList.add(table.getFullName());
                    }
                }
                return true;
            }
        });
        return tableList;
    }

    private int numTables() {
        final int[] num = new int[1];
        this.iterateTables(new TableMetadataIteratorCallback(){

            @Override
            public boolean tableCallback(Table table) {
                num[0] = num[0] + 1;
                return true;
            }
        });
        return num[0];
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public Set<String> listNamespaces() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("sysdefault");
        if (this.namespaces != null) {
            keySet.addAll(this.namespaces.keySet());
        }
        return keySet;
    }

    public List<Index> getTextIndexes() {
        final ArrayList<Index> textIndexes = new ArrayList<Index>();
        this.iterateTables(new TableMetadataIteratorCallback(){

            @Override
            public boolean tableCallback(Table table) {
                textIndexes.addAll(table.getIndexes(Index.IndexType.TEXT).values());
                return true;
            }
        });
        return textIndexes;
    }

    public Set<String> getTextIndexNames() {
        HashSet<String> textIndexNames = new HashSet<String>();
        for (Index ti : this.getTextIndexes()) {
            textIndexNames.add(ti.getName());
        }
        return textIndexNames;
    }

    private void bumpSeqNum() {
        ++this.seqNum;
    }

    private long allocateId() {
        while (true) {
            ++this.keyId;
            try {
                this.verifyIdNotUsed(TableImpl.createIdString(this.keyId));
                return this.keyId;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            break;
        }
    }

    public long getMaxTableId() {
        return this.keyId;
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public int getSequenceNumber() {
        return this.seqNum;
    }

    @Override
    public TableChangeList getChangeInfo(int startSeqNum) {
        return new TableChangeList(this.seqNum, this.getChanges(startSeqNum));
    }

    public TableMetadata pruneChanges(int limitSeqNum, int maxChanges) {
        int firstChangeSeqNum = this.getFirstChangeSeqNum();
        if (firstChangeSeqNum == -1) {
            return this;
        }
        int firstRetainedChangeSeqNum = Math.min(this.getSequenceNumber() - maxChanges + 1, limitSeqNum);
        if (firstRetainedChangeSeqNum <= firstChangeSeqNum) {
            return this;
        }
        Iterator<TableChange> itr = this.changeHistory.iterator();
        while (itr.hasNext() && itr.next().getSequenceNumber() < firstRetainedChangeSeqNum) {
            itr.remove();
        }
        return this;
    }

    int getFirstChangeSeqNum() {
        return this.changeHistory == null ? -1 : (this.changeHistory.isEmpty() ? -1 : this.changeHistory.get(0).getSequenceNumber());
    }

    int getChangeHistorySize() {
        return this.changeHistory == null ? 0 : this.changeHistory.size();
    }

    private List<TableChange> getChanges(int startSeqNum) {
        if (startSeqNum >= this.seqNum || this.changeHistory == null || this.changeHistory.isEmpty()) {
            return null;
        }
        if (startSeqNum < this.changeHistory.get(0).getSequenceNumber()) {
            return null;
        }
        LinkedList<TableChange> list = null;
        for (TableChange change : this.changeHistory) {
            if (change.getSequenceNumber() <= startSeqNum) continue;
            if (list == null) {
                list = new LinkedList<TableChange>();
            }
            list.add(change);
        }
        return list;
    }

    public boolean update(MetadataInfo metadataInfo) {
        if (metadataInfo instanceof TableChangeList) {
            return this.apply((TableChangeList)metadataInfo);
        }
        throw new IllegalArgumentException("Unknow metadata info: " + metadataInfo);
    }

    private boolean apply(TableChangeList changeList) {
        if (changeList.isEmpty()) {
            return false;
        }
        int origSeqNum = this.seqNum;
        for (TableChange change : changeList) {
            if (change.getSequenceNumber() <= this.seqNum) continue;
            if (change.getSequenceNumber() > this.seqNum + 1 || !change.apply(this)) break;
            this.seqNum = change.getSequenceNumber();
            if (this.changeHistory == null) continue;
            this.changeHistory.add(change);
        }
        return origSeqNum != this.seqNum;
    }

    public TableMetadata getCopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (TableMetadata)ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IllegalStateException("Unexpected exception", ex);
        }
    }

    public String toString() {
        return "TableMetadata[" + this.seqNum + ", n:" + (this.namespaces == null ? "-" : Integer.valueOf(this.namespaces.size())) + ", t:" + this.tables.size() + ", " + (this.changeHistory == null ? "-" : Integer.valueOf(this.changeHistory.size())) + "]";
    }

    public boolean compareMetadata(final TableMetadata omd) {
        int num = this.numTables();
        if (num == omd.numTables()) {
            final int[] numCompared = new int[1];
            this.iterateTables(new TableMetadataIteratorCallback(){

                @Override
                public boolean tableCallback(Table table) {
                    if (!TableMetadata.existsAndEqual((TableImpl)table, omd)) {
                        return false;
                    }
                    numCompared[0] = numCompared[0] + 1;
                    return true;
                }
            });
            return numCompared[0] == num;
        }
        return false;
    }

    private void verifyIdNotUsed(final String idString) {
        this.iterateTables(new TableMetadataIteratorCallback(){

            @Override
            public boolean tableCallback(Table table) {
                String tableId = ((TableImpl)table).getIdString();
                if (tableId.equals(idString)) {
                    throw new IllegalArgumentException("Cannot create a table overlay with the name " + idString + ", it exists as a table Id");
                }
                return true;
            }
        });
    }

    private static boolean existsAndEqual(TableImpl table, TableMetadata md) {
        TableImpl otherTable = md.getTable(table.getInternalNamespace(), table.getFullName());
        if (otherTable != null && table.equals(otherTable)) {
            for (Table child : table.getChildTables().values()) {
                if (TableMetadata.existsAndEqual((TableImpl)child, md)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void iterateTables(TableMetadataIteratorCallback callback) {
        for (Table table : this.getTables().values()) {
            if (!TableMetadata.iterateTables(table, callback)) break;
        }
    }

    private static boolean iterateTables(Table table, TableMetadataIteratorCallback callback) {
        for (Table child : table.getChildTables().values()) {
            if (TableMetadata.iterateTables(child, callback)) continue;
            return false;
        }
        return callback.tableCallback(table);
    }

    private void ensureNamespaceMap() {
        if (this.namespaces == null) {
            this.namespaces = new TreeMap<String, NamespaceImpl>(FieldComparator.instance);
        }
    }

    public boolean hasNamespace(String namespace) {
        if (NameUtils.isInternalInitialNamespace(namespace)) {
            return true;
        }
        if (this.namespaces == null) {
            return false;
        }
        return this.namespaces.containsKey(namespace);
    }

    public NamespaceImpl getNamespace(String namespace) {
        if (NameUtils.isInternalInitialNamespace(namespace)) {
            return new NamespaceImpl(namespace, null);
        }
        if (this.namespaces == null) {
            return null;
        }
        return this.namespaces.get(namespace);
    }

    public NamespaceImpl createNamespace(String namespace, ResourceOwner owner) {
        if (this.hasNamespace(namespace)) {
            throw new IllegalArgumentException("Cannot create namespace. Namespace already exists: '" + namespace + "' ");
        }
        NamespaceImpl nsObj = new NamespaceImpl(namespace, owner);
        this.ensureNamespaceMap();
        this.namespaces.put(namespace, nsObj);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new AddNamespaceChange(namespace, owner, this.seqNum));
        }
        return nsObj;
    }

    public NamespaceImpl dropNamespace(String namespace) {
        if (!this.hasNamespace(namespace)) {
            throw new IllegalArgumentException("Cannot drop namespace. Namespace doesn't exist: '" + namespace + "' ");
        }
        if (!this.isNamespaceEmpty(namespace)) {
            throw new IllegalArgumentException("Cannot drop namespace. Namespace is not empty: '" + namespace + "' ");
        }
        this.ensureNamespaceMap();
        NamespaceImpl res = this.namespaces.remove(namespace);
        this.bumpSeqNum();
        if (this.changeHistory != null) {
            this.changeHistory.add(new RemoveNamespaceChange(namespace, this.seqNum));
        }
        return res;
    }

    public boolean isNamespaceEmpty(String namespace) {
        if (NameUtils.isInternalInitialNamespace(namespace)) {
            return false;
        }
        if (!this.hasNamespace(namespace)) {
            return true;
        }
        for (Table table : this.getTables().values()) {
            if (namespace == null || !namespace.equals(table.getNamespace())) continue;
            return false;
        }
        return true;
    }

    public static interface TableMetadataIteratorCallback {
        public boolean tableCallback(Table var1);
    }

    public static class TableMetadataKey
    implements MetadataKey,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String tableName;

        public TableMetadataKey(String tableName) {
            this.tableName = tableName;
        }

        public TableMetadataKey(String namespace, String tableName) {
            this.tableName = NameUtils.makeQualifiedName(namespace, tableName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public MetadataKey getMetadataKey() {
            return this;
        }

        public String toString() {
            return "TableMetadataKey[" + (this.tableName != null ? this.tableName : "null") + "]";
        }
    }

    public static class NamespaceImpl
    implements Ownable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String namespace;
        private final ResourceOwner owner;

        NamespaceImpl(String namespace, ResourceOwner owner) {
            this.namespace = namespace;
            this.owner = owner == null ? null : new ResourceOwner(owner);
        }

        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public ResourceOwner getOwner() {
            return this.owner;
        }
    }
}

