/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.utilint.net.SSLDataChannel;
import com.sleepycat.je.rep.utilint.net.SimpleDataChannel;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.ListenerConfig;
import oracle.kv.impl.async.ListenerPortRange;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.security.ssl.SSLControl;

public class NioUtil {
    public static final Map<SocketSetter<?>, AsyncOption<?>> socketSetterMap;
    public static final Map<ServerSocketSetter<?>, AsyncOption<?>> serverSocketSetterMap;

    public static DataChannel getDataChannel(NetworkAddress address, EndpointConfig endpointConfig, Logger logger) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        NioUtil.configureSocketChannel(socketChannel, endpointConfig);
        socketChannel.connect(address.getInetSocketAddress());
        return NioUtil.getDataChannel(socketChannel, endpointConfig.getSSLControl(), true, address.getHostName(), logger);
    }

    public static DataChannel getDataChannel(SocketChannel socketChannel, EndpointConfig endpointConfig, Logger logger) throws IOException {
        NioUtil.configureSocketChannel(socketChannel, endpointConfig);
        return NioUtil.getDataChannel(socketChannel, endpointConfig.getSSLControl(), false, null, logger);
    }

    public static ServerSocketChannel listen(final ListenerConfig listenerConfig) throws IOException {
        final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        for (final ServerSocketSetter<?> s : serverSocketSetterMap.keySet()) {
            new ServerSocketSetHelper(){

                @Override
                public <T> void run() throws IOException {
                    Object val;
                    AsyncOption<?> ao = serverSocketSetterMap.get(s);
                    ServerSocketSetter setter = s;
                    if (ao != null && (val = listenerConfig.getOption(ao)) != null) {
                        setter.set(serverSocketChannel.socket(), val);
                    }
                }
            }.run();
        }
        int backlog = (Integer)listenerConfig.getOption(AsyncOption.SSO_BACKLOG);
        ListenerPortRange portRange = listenerConfig.getPortRange();
        InetAddress addr = portRange.getAddress();
        int portStart = portRange.getPortStart();
        int portEnd = portRange.getPortEnd();
        for (int port = portStart; port <= portEnd; ++port) {
            try {
                serverSocketChannel.socket().bind(new InetSocketAddress(addr, port), backlog);
                return serverSocketChannel;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        String msg = String.format("No free local address to bind for range %s", portRange);
        if (portStart == portEnd) {
            throw new BindException(msg);
        }
        throw new IOException(msg);
    }

    public static NetworkAddress getRemoteAddress(SocketChannel socketChannel) {
        Socket socket = socketChannel.socket();
        return new NetworkAddress(socket.getInetAddress(), socket.getPort());
    }

    public static NetworkAddress getLocalAddress(ServerSocketChannel serverSocketChannel) {
        ServerSocket serverSocket = serverSocketChannel.socket();
        return new NetworkAddress(serverSocket.getInetAddress(), serverSocket.getLocalPort());
    }

    private static void configureSocketChannel(final SocketChannel socketChannel, final EndpointConfig endpointConfig) throws IOException {
        socketChannel.configureBlocking(false);
        for (final SocketSetter<?> s : socketSetterMap.keySet()) {
            new SocketSetHelper(){

                @Override
                public <T> void run() throws IOException {
                    Object val;
                    AsyncOption<?> ao = socketSetterMap.get(s);
                    SocketSetter setter = s;
                    if (ao != null && (val = endpointConfig.getOption(ao)) != null) {
                        setter.set(socketChannel.socket(), val);
                    }
                }
            }.run();
        }
    }

    private static DataChannel getDataChannel(SocketChannel socketChannel, SSLControl sslControl, boolean isClient, String hostname, Logger logger) {
        if (sslControl == null) {
            return new SimpleDataChannel(socketChannel);
        }
        SSLEngine engine = sslControl.sslContext().createSSLEngine(hostname, socketChannel.socket().getPort());
        engine.setSSLParameters(sslControl.sslParameters());
        engine.setUseClientMode(isClient);
        if (!isClient && sslControl.peerAuthenticator() != null) {
            engine.setWantClientAuth(true);
        }
        return new SSLDataChannel(socketChannel, engine, hostname, sslControl.hostVerifier(), sslControl.peerAuthenticator(), new WrappedLogger(logger));
    }

    static {
        HashMap<Object, AsyncOption<Comparable<Boolean>>> mapping = new HashMap<Object, AsyncOption<Comparable<Boolean>>>();
        mapping.put(new SoKeepAlive(), AsyncOption.SO_KEEPALIVE);
        mapping.put(new SoLinger(), AsyncOption.SO_LINGER);
        mapping.put(new SoRcvBuf(), AsyncOption.SO_RCVBUF);
        mapping.put(new SoReuseAddr(), AsyncOption.SO_REUSEADDR);
        mapping.put(new SoSndBuf(), AsyncOption.SO_SNDBUF);
        mapping.put(new TcpNoDelay(), AsyncOption.TCP_NODELAY);
        socketSetterMap = Collections.unmodifiableMap(mapping);
        mapping = new HashMap();
        mapping.put(new SsoRcvBuf(), AsyncOption.SO_RCVBUF);
        mapping.put(new SsoReuseAddr(), AsyncOption.SO_REUSEADDR);
        serverSocketSetterMap = Collections.unmodifiableMap(mapping);
    }

    private static interface ServerSocketSetHelper {
        public <T> void run() throws IOException;
    }

    private static interface SocketSetHelper {
        public <T> void run() throws IOException;
    }

    private static class SsoReuseAddr
    implements ServerSocketSetter<Boolean> {
        private SsoReuseAddr() {
        }

        @Override
        public void set(ServerSocket ss, Boolean v) throws IOException {
            ss.setReuseAddress(v);
        }
    }

    private static class SsoRcvBuf
    implements ServerSocketSetter<Integer> {
        private SsoRcvBuf() {
        }

        @Override
        public void set(ServerSocket ss, Integer v) throws IOException {
            ss.setReceiveBufferSize(v);
        }
    }

    private static class TcpNoDelay
    implements SocketSetter<Boolean> {
        private TcpNoDelay() {
        }

        @Override
        public void set(Socket s, Boolean v) throws IOException {
            s.setTcpNoDelay(v);
        }
    }

    private static class SoSndBuf
    implements SocketSetter<Integer> {
        private SoSndBuf() {
        }

        @Override
        public void set(Socket s, Integer v) throws IOException {
            s.setSendBufferSize(v);
        }
    }

    private static class SoReuseAddr
    implements SocketSetter<Boolean> {
        private SoReuseAddr() {
        }

        @Override
        public void set(Socket s, Boolean v) throws IOException {
            s.setReuseAddress(v);
        }
    }

    private static class SoRcvBuf
    implements SocketSetter<Integer> {
        private SoRcvBuf() {
        }

        @Override
        public void set(Socket s, Integer v) throws IOException {
            s.setReceiveBufferSize(v);
        }
    }

    private static class SoLinger
    implements SocketSetter<Integer> {
        private SoLinger() {
        }

        @Override
        public void set(Socket s, Integer v) throws IOException {
            s.setSoLinger(true, v);
        }
    }

    private static class SoKeepAlive
    implements SocketSetter<Boolean> {
        private SoKeepAlive() {
        }

        @Override
        public void set(Socket s, Boolean v) throws IOException {
            s.setKeepAlive(v);
        }
    }

    private static interface ServerSocketSetter<T> {
        public void set(ServerSocket var1, T var2) throws IOException;
    }

    private static interface SocketSetter<T> {
        public void set(Socket var1, T var2) throws IOException;
    }

    private static class WrappedLogger
    implements InstanceLogger {
        private final Logger logger;

        WrappedLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void log(Level logLevel, String msg) {
            this.logger.log(logLevel, msg);
        }
    }
}

