/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Calendar;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.interfaces.Project;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedAddress;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmploymentPeriod;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedPhoneNumber;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class IsolatedEmployee
implements Serializable {
    public BigDecimal id;
    public String firstName = "";
    public String lastName = "";
    public String gender;
    public IsolatedEmploymentPeriod period;
    public ValueHolderInterface address = new ValueHolder();
    public ValueHolderInterface manager = new ValueHolder();
    public ValueHolderInterface managedEmployees = new ValueHolder(new Vector());
    public ValueHolderInterface phoneNumbers;
    public ValueHolderInterface projects = new ValueHolder(new Vector());
    public ValueHolderInterface responsibilitiesList = new ValueHolder(new Vector());
    public Time[] normalHours;
    public int salary;
    public boolean hasChanges = false;
    public static int getIdCallCount = 0;

    public IsolatedEmployee() {
        this.phoneNumbers = new ValueHolder(new Vector());
        this.normalHours = new Time[2];
        Calendar startTime = Calendar.getInstance();
        startTime.set(14, 0);
        startTime.set(1970, 0, 1, 9, 0, 0);
        this.normalHours[0] = new Time(startTime.getTime().getTime());
        Calendar endTime = Calendar.getInstance();
        endTime.set(14, 0);
        endTime.set(1970, 0, 1, 17, 0, 0);
        this.normalHours[1] = new Time(endTime.getTime().getTime());
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void clearChanges() {
        this.hasChanges = false;
    }

    public void setChanged() {
        this.hasChanges = true;
    }

    public static IsolatedEmployee buildEmployeeExample1() {
        IsolatedEmployee employee = new IsolatedEmployee();
        employee.setFirstName("Bob");
        employee.setLastName("Smith");
        employee.setMale();
        employee.setSalary(35000);
        employee.setPeriod(IsolatedEmploymentPeriod.EmploymentPeriodExample1());
        employee.setAddress(IsolatedAddress.AddressExample1());
        employee.addResponsibility("Make the coffee.");
        employee.addResponsibility("Clean the kitchen.");
        employee.addPhoneNumber(new IsolatedPhoneNumber("Home", "613", "555-9878"));
        return employee;
    }

    public static IsolatedEmployee buildEmployeeExample2() {
        IsolatedEmployee employee = new IsolatedEmployee();
        employee.setFirstName("Andy");
        employee.setLastName("McDurmont");
        employee.setMale();
        employee.setSalary(1500);
        employee.setPeriod(IsolatedEmploymentPeriod.EmploymentPeriodExample2());
        employee.setAddress(IsolatedAddress.AddressExample2());
        employee.addResponsibility("Shred reports");
        employee.addPhoneNumber(new IsolatedPhoneNumber("Home", "613", "555-9878"));
        return employee;
    }

    public void addManagedEmployee(IsolatedEmployee employee) {
        this.setChanged();
        this.getManagedEmployees().addElement(employee);
        employee.setManager(this);
    }

    public void addPhoneNumber(IsolatedPhoneNumber phoneNumber) {
        this.setChanged();
        this.getPhoneNumbers().addElement(phoneNumber);
        phoneNumber.setOwner(this);
    }

    public void addProject(Project project) {
        this.setChanged();
        this.getProjects().addElement(project);
    }

    public void addResponsibility(String responsibility) {
        this.setChanged();
        this.getResponsibilitiesList().addElement(responsibility);
    }

    public Time[] buildNormalHours(DataRecord row, Session session) {
        Time[] hours = new Time[]{(Time)session.getDatasourcePlatform().convertObject(row.get((Object)"START_TIME"), Time.class), (Time)session.getDatasourcePlatform().convertObject(row.get((Object)"END_TIME"), Time.class)};
        return hours;
    }

    public static TableDefinition buildIsolatedTableDefinition() {
        TableDefinition tabledefinition = new TableDefinition();
        tabledefinition.setName("ISOLATED_EMPLOYEE");
        FieldDefinition field = new FieldDefinition();
        field.setName("EMP_ID");
        field.setTypeName("NUMERIC");
        field.setSize(15);
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(true);
        field.setUnique(false);
        field.setIsIdentity(true);
        tabledefinition.addField(field);
        FieldDefinition field1 = new FieldDefinition();
        field1.setName("F_NAME");
        field1.setTypeName("VARCHAR");
        field1.setSize(40);
        field1.setShouldAllowNull(true);
        field1.setIsPrimaryKey(false);
        field1.setUnique(false);
        field1.setIsIdentity(false);
        tabledefinition.addField(field1);
        FieldDefinition field2 = new FieldDefinition();
        field2.setName("L_NAME");
        field2.setTypeName("VARCHAR");
        field2.setSize(40);
        field2.setShouldAllowNull(true);
        field2.setIsPrimaryKey(false);
        field2.setUnique(false);
        field2.setIsIdentity(false);
        tabledefinition.addField(field2);
        FieldDefinition field3 = new FieldDefinition();
        field3.setName("START_DATE");
        field3.setTypeName("DATE");
        field3.setShouldAllowNull(true);
        field3.setIsPrimaryKey(false);
        field3.setUnique(false);
        field3.setIsIdentity(false);
        tabledefinition.addField(field3);
        FieldDefinition field4 = new FieldDefinition();
        field4.setName("END_DATE");
        field4.setTypeName("DATE");
        field4.setShouldAllowNull(true);
        field4.setIsPrimaryKey(false);
        field4.setUnique(false);
        field4.setIsIdentity(false);
        tabledefinition.addField(field4);
        FieldDefinition field5 = new FieldDefinition();
        field5.setName("START_TIME");
        field5.setTypeName("DATE");
        field5.setShouldAllowNull(true);
        field5.setIsPrimaryKey(false);
        field5.setUnique(false);
        field5.setIsIdentity(false);
        tabledefinition.addField(field5);
        FieldDefinition field6 = new FieldDefinition();
        field6.setName("END_TIME");
        field6.setTypeName("DATE");
        field6.setShouldAllowNull(true);
        field6.setIsPrimaryKey(false);
        field6.setUnique(false);
        field6.setIsIdentity(false);
        tabledefinition.addField(field6);
        FieldDefinition field7 = new FieldDefinition();
        field7.setName("GENDER");
        field7.setTypeName("VARCHAR");
        field7.setSize(1);
        field7.setShouldAllowNull(true);
        field7.setIsPrimaryKey(false);
        field7.setUnique(false);
        field7.setIsIdentity(false);
        tabledefinition.addField(field7);
        FieldDefinition field8 = new FieldDefinition();
        field8.setName("ADDR_ID");
        field8.setTypeName("NUMERIC");
        field8.setSize(15);
        field8.setShouldAllowNull(true);
        field8.setIsPrimaryKey(false);
        field8.setUnique(false);
        field8.setIsIdentity(false);
        field8.setForeignKeyFieldName("ISOLATED_ADDRESS.ADDRESS_ID");
        tabledefinition.addField(field8);
        FieldDefinition field9 = new FieldDefinition();
        field9.setName("MANAGER_ID");
        field9.setTypeName("NUMERIC");
        field9.setSize(15);
        field9.setShouldAllowNull(true);
        field9.setIsPrimaryKey(false);
        field9.setUnique(false);
        field9.setIsIdentity(false);
        field9.setForeignKeyFieldName("ISOLATED_EMPLOYEE.EMP_ID");
        tabledefinition.addField(field9);
        FieldDefinition field10 = new FieldDefinition();
        field10.setName("VERSION");
        field10.setTypeName("NUMERIC");
        field10.setSize(15);
        field10.setShouldAllowNull(true);
        field10.setIsPrimaryKey(false);
        field10.setUnique(false);
        field10.setIsIdentity(false);
        tabledefinition.addField(field10);
        return tabledefinition;
    }

    public static TableDefinition buildISOLATEDRESPONSTable() {
        TableDefinition tabledefinition = new TableDefinition();
        tabledefinition.setName("ISOLATED_RESPONS");
        FieldDefinition field = new FieldDefinition();
        field.setName("EMP_ID");
        field.setTypeName("NUMERIC");
        field.setSize(15);
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(true);
        field.setUnique(false);
        field.setIsIdentity(false);
        field.setForeignKeyFieldName("EMPLOYEE.EMP_ID");
        tabledefinition.addField(field);
        FieldDefinition field1 = new FieldDefinition();
        field1.setName("DESCRIP");
        field1.setTypeName("VARCHAR");
        field1.setSize(200);
        field1.setShouldAllowNull(false);
        field1.setIsPrimaryKey(true);
        field1.setUnique(false);
        field1.setIsIdentity(false);
        tabledefinition.addField(field1);
        return tabledefinition;
    }

    public static TableDefinition buildISOLATEDSALARYTable() {
        TableDefinition tabledefinition = new TableDefinition();
        tabledefinition.setName("ISOLATED_SALARY");
        FieldDefinition field = new FieldDefinition();
        field.setName("EMP_ID");
        field.setTypeName("NUMERIC");
        field.setSize(15);
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(true);
        field.setUnique(false);
        field.setIsIdentity(false);
        field.setForeignKeyFieldName("EMPLOYEE.EMP_ID");
        tabledefinition.addField(field);
        FieldDefinition field1 = new FieldDefinition();
        field1.setName("SALARY");
        field1.setTypeName("NUMBER");
        field1.setSize(10);
        field1.setShouldAllowNull(true);
        field1.setIsPrimaryKey(false);
        field1.setUnique(false);
        field1.setIsIdentity(false);
        tabledefinition.addField(field1);
        return tabledefinition;
    }

    public IsolatedAddress getAddress() {
        return (IsolatedAddress)this.address.getValue();
    }

    public Time getEndTime() {
        return this.getNormalHours()[1];
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getGender() {
        return this.gender;
    }

    public static int getGetIdCallCount() {
        return getIdCallCount;
    }

    public BigDecimal getId() {
        ++getIdCallCount;
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Vector getManagedEmployees() {
        return (Vector)this.managedEmployees.getValue();
    }

    public IsolatedEmployee getManager() {
        return (IsolatedEmployee)this.manager.getValue();
    }

    public Time[] getNormalHours() {
        return this.normalHours;
    }

    public IsolatedEmploymentPeriod getPeriod() {
        return this.period;
    }

    public Vector getPhoneNumbers() {
        return (Vector)this.phoneNumbers.getValue();
    }

    public Vector getProjects() {
        return (Vector)this.projects.getValue();
    }

    public Vector getResponsibilitiesList() {
        return (Vector)this.responsibilitiesList.getValue();
    }

    public int getSalary() {
        return this.salary;
    }

    public Time getStartTime() {
        return this.getNormalHours()[0];
    }

    public void removeManagedEmployee(IsolatedEmployee employee) {
        this.setChanged();
        this.getManagedEmployees().removeElement(employee);
        employee.setManager(null);
    }

    public void removePhoneNumber(IsolatedPhoneNumber phoneNumber) {
        this.setChanged();
        this.getPhoneNumbers().removeElement(phoneNumber);
    }

    public void removeProject(Project project) {
        this.setChanged();
        this.getProjects().removeElement(project);
    }

    public void removeResponsibility(String responsibility) {
        this.setChanged();
        this.getResponsibilitiesList().removeElement(responsibility);
    }

    public void setAddress(IsolatedAddress address) {
        this.setChanged();
        this.address.setValue((Object)address);
    }

    public void setEndTime(Time endTime) {
        this.setChanged();
        this.getNormalHours()[1] = endTime;
    }

    public void setFemale() {
        this.setChanged();
        this.setGender("Female");
    }

    public void setFirstName(String firstName) {
        this.setChanged();
        this.firstName = firstName;
    }

    public void setGender(String gender) {
        this.setChanged();
        this.gender = gender;
    }

    public static void setGetIdCallCount(int value) {
        getIdCallCount = value;
    }

    public void setId(BigDecimal id) {
        this.setChanged();
        this.id = id;
    }

    public void setLastName(String lastName) {
        this.setChanged();
        this.lastName = lastName;
    }

    public void setMale() {
        this.setChanged();
        this.setGender("Male");
    }

    public void setManagedEmployees(Vector managedEmployees) {
        this.setChanged();
        this.managedEmployees.setValue((Object)managedEmployees);
    }

    public void setManager(IsolatedEmployee manager) {
        this.setChanged();
        this.manager.setValue((Object)manager);
    }

    public void setNormalHours(Time[] normalHours) {
        this.setChanged();
        this.normalHours = normalHours;
    }

    public void setPeriod(IsolatedEmploymentPeriod period) {
        this.setChanged();
        this.period = period;
    }

    public void setPhoneNumbers(Vector phoneNumbers) {
        this.setChanged();
        this.phoneNumbers.setValue((Object)phoneNumbers);
    }

    public void setProjects(Vector projects) {
        this.setChanged();
        this.projects.setValue((Object)projects);
    }

    public void setResponsibilitiesList(Vector responsibilitiesList) {
        this.setChanged();
        this.responsibilitiesList.setValue((Object)responsibilitiesList);
    }

    public void setSalary(int salary) {
        this.setChanged();
        this.salary = salary;
    }

    public void setStartTime(Time startTime) {
        this.setChanged();
        this.getNormalHours()[0] = startTime;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("IsolatedEmployee: ");
        writer.write(this.getFirstName());
        writer.write(" ");
        writer.write(this.getLastName());
        return writer.toString();
    }
}

