/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.Computer;
import org.eclipse.persistence.testing.models.inheritance.IBMPC;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class SelectSimpleBooleanTest
extends JPQLTestCase {
    private Exception caught = null;
    private IBMPC ibmpc = null;

    public static SelectSimpleBooleanTest getSimpleTrueTest() {
        SelectSimpleBooleanTest theTest = new SelectSimpleBooleanTest();
        Object ejbqlString = "SELECT OBJECT(ibmpc) FROM IBMPC ibmpc WHERE ";
        ejbqlString = (String)ejbqlString + "ibmpc.isClone = true";
        theTest.setEjbqlString((String)ejbqlString);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("isClone").equal((Object)true);
        theTest.setOriginalObjectExpression(whereClause);
        theTest.setName("SelectSimpleBooleanTest -> = TRUE test");
        return theTest;
    }

    public static SelectSimpleBooleanTest getSimpleFalseTest() {
        SelectSimpleBooleanTest theTest = new SelectSimpleBooleanTest();
        Object ejbqlString = "SELECT OBJECT(ibmpc) FROM IBMPC ibmpc WHERE ";
        ejbqlString = (String)ejbqlString + "ibmpc.isClone = false";
        theTest.setEjbqlString((String)ejbqlString);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("isClone").equal((Object)false);
        theTest.setOriginalObjectExpression(whereClause);
        theTest.setName("SelectSimpleBooleanTest -> = FALSE test");
        return theTest;
    }

    public static SelectSimpleBooleanTest getSimpleNotEqualsTrueTest() {
        SelectSimpleBooleanTest theTest = new SelectSimpleBooleanTest();
        Object ejbqlString = "SELECT OBJECT(ibmpc) FROM IBMPC ibmpc WHERE ";
        ejbqlString = (String)ejbqlString + "ibmpc.isClone <> true";
        theTest.setEjbqlString((String)ejbqlString);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("isClone").notEqual((Object)true);
        theTest.setOriginalObjectExpression(whereClause);
        theTest.setName("SelectSimpleBooleanTest -> <> TRUE test");
        return theTest;
    }

    public static SelectSimpleBooleanTest getSimpleNotEqualsFalseTest() {
        SelectSimpleBooleanTest theTest = new SelectSimpleBooleanTest();
        Object ejbqlString = "SELECT OBJECT(ibmpc) FROM IBMPC ibmpc WHERE ";
        ejbqlString = (String)ejbqlString + "ibmpc.isClone <> false";
        theTest.setEjbqlString((String)ejbqlString);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("isClone").notEqual((Object)false);
        theTest.setOriginalObjectExpression(whereClause);
        theTest.setName("SelectSimpleBooleanTest -> <> FALSE test");
        return theTest;
    }

    @Override
    public void test() {
        try {
            super.test();
        }
        catch (Exception e) {
            this.setCaught(e);
        }
    }

    @Override
    public void setup() {
        this.ibmpc = Computer.example3a();
        this.getDatabaseSession().writeObject((Object)this.ibmpc);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(IBMPC.class);
        raq.setSelectionCriteria(this.getOriginalObjectExpression());
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq));
        this.setReferenceClass(IBMPC.class);
        super.setup();
    }

    @Override
    public void reset() {
        this.getDatabaseSession().deleteObject((Object)this.ibmpc);
    }

    @Override
    public void verify() throws Exception {
        if (this.getCaught() != null) {
            throw new TestErrorException(this.getName() + " Verify Failed:" + this.getCaught().getMessage());
        }
    }

    private Exception getCaught() {
        return this.caught;
    }

    private void setCaught(Exception wasCaught) {
        this.caught = wasCaught;
    }
}

