/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class MultipleUnitOfWorkTest
extends WriteObjectTest {
    public Object firstUnitOfWorkWorkingCopy;
    public UnitOfWork firstUnitOfWork;
    public Object secondUnitOfWorkWorkingCopy;
    public UnitOfWork secondUnitOfWork;
    SessionEventListener listener;

    public MultipleUnitOfWorkTest() {
    }

    public MultipleUnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeFirstUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.firstUnitOfWorkWorkingCopy;
        employee.setNormalHours(new Time[3]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)2, (int)2, (int)2));
        employee.setEndTime(Helper.timeFromHourMinuteSecond((int)2, (int)2, (int)2));
        employee.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1903, (int)3, (int)3), Helper.dateFromYearMonthDate((int)1904, (int)4, (int)4)));
        employee.setPhoneNumbers(new Vector());
        employee.addPhoneNumber(new PhoneNumber("home", "514", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("office", "509", "8224599"));
    }

    protected void changeSecondUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.secondUnitOfWorkWorkingCopy;
        employee.setProjects(new Vector());
        employee.addProject((Project)this.secondUnitOfWork.readObject(SmallProject.class));
        employee.addProject((Project)this.secondUnitOfWork.readObject(LargeProject.class));
        employee.setResponsibilitiesList(new Vector());
        employee.addResponsibility("does not make cafee");
        employee.addResponsibility("does not buy donuts");
        employee.setAddress(new Address());
        employee.setManager((Employee)this.secondUnitOfWork.readObject(Employee.class));
    }

    public void reset() {
        super.reset();
        if (this.listener != null) {
            this.getAbstractSession().getParent().getEventManager().removeListener(this.listener);
            this.listener = null;
        }
    }

    protected void setup() {
        if (this.getSession().isClientSession()) {
            this.listener = this.checkTransactionIsolation();
        }
        if (this.getSession().isRemoteSession() && this.getSession().getDatasourcePlatform().isDerby()) {
            throw new TestWarningException("This test uses functionality that does not work over remote sessions in Apache Derby.");
        }
        super.setup();
        this.firstUnitOfWork = this.getSession().acquireUnitOfWork();
        this.firstUnitOfWorkWorkingCopy = this.firstUnitOfWork.registerObject(this.objectToBeWritten);
        this.changeFirstUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.secondUnitOfWork = this.getSession().acquireUnitOfWork();
        this.secondUnitOfWorkWorkingCopy = this.secondUnitOfWork.registerObject(this.objectToBeWritten);
        this.changeSecondUnitOfWorkWorkingCopy();
        if (!this.getAbstractSession().compareObjectsDontMatch(this.firstUnitOfWorkWorkingCopy, this.secondUnitOfWorkWorkingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.firstUnitOfWork.commit();
        try {
            this.secondUnitOfWork.commit();
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
    }
}

