/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TransactionIsolationMergeTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;
    Employee original;
    String originalFirstName;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        Employee clone = (Employee)this.unitOfWork.readObject((Object)this.original);
        clone.setFirstName(this.originalFirstName);
        this.unitOfWork.commit();
        this.unitOfWork = null;
        this.originalFirstName = null;
        this.original = null;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        Employee employeeClone;
        this.unitOfWork.beginEarlyTransaction();
        this.original = employeeClone = (Employee)this.unitOfWork.readObject(Employee.class);
        this.originalFirstName = this.original.getFirstName();
        employeeClone.setFirstName("elle");
        this.unitOfWork.commit();
        this.unitOfWork = null;
        ReadObjectQuery cacheQuery = new ReadObjectQuery(Employee.class);
        cacheQuery.checkCacheOnly();
        Employee newOriginal = (Employee)this.getSession().executeQuery((DatabaseQuery)cacheQuery);
        this.strongAssert(newOriginal != null, "There should be an original in the shared cache.");
        this.strongAssert(newOriginal != employeeClone, "commit placed a clone into the shared cache.");
    }
}

