/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Value;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.UserDataControl;

public class RequestValue
implements FastExternalizable {
    private final Value value;
    private final byte[] bytes;

    RequestValue(Value value) {
        ObjectUtil.checkNull("value", value);
        this.value = value;
        this.bytes = null;
    }

    public RequestValue(DataInput in, short serialVersion) throws IOException {
        this.value = null;
        this.bytes = Value.readFastExternal(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        if (this.value != null) {
            this.value.writeFastExternal(out, serialVersion);
        } else {
            Value.writeFastExternal(out, serialVersion, this.bytes);
        }
    }

    byte[] getBytes() {
        if (this.bytes == null) {
            return this.value.toByteArray();
        }
        return this.bytes;
    }

    public String toString() {
        return UserDataControl.displayValue(this.value, this.bytes);
    }
}

