/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.MethodHandler;
import oracle.kv.impl.security.MethodHandlerUtils;
import oracle.kv.impl.security.ProxyUtils;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginToken;

public final class ContextProxy<T>
implements InvocationHandler {
    private final Object proxyTo;
    private final Map<Method, MethodHandler> methodMap;
    private final LoginHandle loginHdl;
    private final int serialVersion;

    @Override
    public Object invoke(Object unusedProxy, Method method, Object[] args) throws Exception {
        MethodHandler handler = this.getHandler(method);
        if (handler == null) {
            throw new IllegalStateException("MethodHandler for method " + method + " was not found");
        }
        return handler.invoke(method, args);
    }

    public static <T> T create(T proxyTo, LoginHandle loginHdl, int serialVersion) {
        ContextProxy<T> proxyHandler = new ContextProxy<T>(proxyTo, loginHdl, serialVersion);
        Class[] remoteInterfaces = ProxyUtils.findRemoteInterfaces(proxyTo.getClass()).toArray(new Class[0]);
        return (T)Proxy.newProxyInstance(proxyTo.getClass().getClassLoader(), remoteInterfaces, proxyHandler);
    }

    private MethodHandler getHandler(Method method) {
        MethodHandler handler = this.methodMap.get(method);
        if (handler == null) {
            handler = this.makeHandler(method);
            this.methodMap.put(method, handler);
        }
        return handler;
    }

    private MethodHandler makeHandler(Method method) {
        Class<?>[] args = method.getParameterTypes();
        if (args.length < 2 || AuthContext.class != args[args.length - 2]) {
            return new MethodHandlerUtils.DirectHandler(this.proxyTo);
        }
        if (this.serialVersion < 4) {
            return new MethodHandlerUtils.StripAuthCtxHandler(this.proxyTo, method);
        }
        return new ContextMethodHandler();
    }

    private ContextProxy(Object proxyTo, LoginHandle loginHdl, int serialVersion) {
        this.proxyTo = proxyTo;
        this.loginHdl = loginHdl;
        this.methodMap = new ConcurrentHashMap<Method, MethodHandler>();
        this.serialVersion = serialVersion;
    }

    class ContextMethodHandler
    implements MethodHandler {
        private static final int MAX_RENEW_ATTEMPTS = 1;
        private static final int MAX_SAE_RETRIES = 5;

        ContextMethodHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Method method, Object[] args) throws Exception {
            AuthContext initialAuthContext = (AuthContext)args[args.length - 2];
            int maxRenewAttempts = ContextProxy.this.loginHdl == null || initialAuthContext != null ? 0 : 1;
            int renews = 0;
            int saeRetries = 0;
            while (true) {
                LoginToken token = null;
                if (initialAuthContext == null && ContextProxy.this.loginHdl != null && (token = ContextProxy.this.loginHdl.getLoginToken()) != null) {
                    args[args.length - 2] = new AuthContext(token);
                }
                try {
                    return MethodHandlerUtils.invokeMethod(ContextProxy.this.proxyTo, method, args);
                }
                catch (SessionAccessException sae) {
                    if (sae.getIsReturnSignal() || saeRetries++ >= 5) {
                        throw sae;
                    }
                    ++saeRetries;
                    continue;
                }
                catch (AuthenticationRequiredException are) {
                    if (are.getIsReturnSignal() || renews++ >= maxRenewAttempts) {
                        throw are;
                    }
                    LoginToken newToken = ContextProxy.this.loginHdl.renewToken(token);
                    if (newToken == null || newToken == token) throw are;
                    continue;
                }
                break;
            }
        }
    }
}

