/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=3)
public class Datacenter
extends Topology.Component<DatacenterId> {
    private static final long serialVersionUID = 1L;
    public static final int MASTER_AFFINITY = 10;
    public static final int NO_MASTER_AFFINITY = 1;
    private static final DatacenterType DEFAULT_DATACENTER_TYPE = DatacenterType.PRIMARY;
    private String name;
    private int repFactor;
    private boolean allowArbiters;
    private int affinityLevel;

    public static Datacenter newInstance(String name, int repFactor, DatacenterType datacenterType, boolean allowArbiters, boolean masterAffinity) {
        ObjectUtil.checkNull("datacenterType", datacenterType);
        return new DatacenterV2(name, repFactor, datacenterType, allowArbiters, masterAffinity);
    }

    static Datacenter readFastExternal(Topology topology, DatacenterId datacenterId, DataInput in, short serialVersion) throws IOException {
        return new DatacenterV2(topology, datacenterId, in, serialVersion);
    }

    private Datacenter(String name, int repFactor, boolean allowArbiters, boolean masterAffinity) {
        this.name = name;
        this.repFactor = repFactor;
        this.allowArbiters = allowArbiters;
        int minRepFactor = 1;
        if (allowArbiters) {
            minRepFactor = 0;
        }
        if (repFactor < minRepFactor) {
            throw new IllegalArgumentException("Replication factor must be greater than or equal to " + minRepFactor);
        }
        this.affinityLevel = this.masterConvertToLevel(masterAffinity);
    }

    private Datacenter(Datacenter datacenter) {
        super(datacenter);
        this.name = datacenter.name;
        this.repFactor = datacenter.repFactor;
        this.allowArbiters = datacenter.allowArbiters;
        this.affinityLevel = datacenter.affinityLevel;
    }

    private Datacenter() {
    }

    private Datacenter(Topology topology, DatacenterId datacenterId, DataInput in, short serialVersion) throws IOException {
        super(topology, datacenterId, in, serialVersion);
        this.name = SerializationUtil.readString(in, serialVersion);
        this.repFactor = SerializationUtil.readPackedInt(in);
        this.allowArbiters = in.readBoolean();
        this.affinityLevel = serialVersion < 16 ? 1 : SerializationUtil.readPackedInt(in);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.affinityLevel == 0) {
            this.affinityLevel = 1;
        }
    }

    private int masterConvertToLevel(boolean masterAffinity) {
        if (masterAffinity) {
            return 10;
        }
        return 1;
    }

    private boolean levelConvertToMaster(int level) {
        return level >= 10;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.name);
        SerializationUtil.writePackedInt(out, this.repFactor);
        out.writeBoolean(this.allowArbiters);
        if (serialVersion >= 16) {
            SerializationUtil.writePackedInt(out, this.affinityLevel);
        }
        this.getDatacenterType().writeFastExternal(out, serialVersion);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.DATACENTER;
    }

    public String getName() {
        return this.name;
    }

    public int getRepFactor() {
        return this.repFactor;
    }

    public void setRepFactor(int factor) {
        this.repFactor = factor;
    }

    public DatacenterType getDatacenterType() {
        return DEFAULT_DATACENTER_TYPE;
    }

    public boolean getAllowArbiters() {
        return this.allowArbiters;
    }

    public boolean getMasterAffinity() {
        return this.levelConvertToMaster(this.affinityLevel);
    }

    @Override
    public Datacenter clone() {
        return new Datacenter(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.getDatacenterType().hashCode();
        result = 31 * result + this.getRepFactor();
        result = 31 * result + (this.getAllowArbiters() ? 0 : 1);
        result = 31 * result + this.affinityLevel;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Datacenter)) {
            return false;
        }
        Datacenter other = (Datacenter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.repFactor == other.repFactor && this.getDatacenterType().equals(other.getDatacenterType()) && this.allowArbiters == other.allowArbiters && this.affinityLevel == other.affinityLevel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=" + this.getResourceId() + " name=" + this.name + " repFactor=" + this.repFactor + " type=" + this.getDatacenterType() + " allowArbiters=" + this.getAllowArbiters() + " masterAffinity=" + this.getMasterAffinity());
        return sb.toString();
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode top = JsonUtils.createObjectNode();
        top.put("resourceId", ((DatacenterId)this.getResourceId()).toString());
        top.put("name", this.name);
        top.put("repFactor", this.repFactor);
        top.put("type", this.getDatacenterType().toString());
        top.put("allowArbiters", this.getAllowArbiters());
        top.put("masterAffinity", this.getMasterAffinity());
        return top;
    }

    @Persistent
    private static class DatacenterV2
    extends Datacenter {
        private static final long serialVersionUID = 1L;
        private DatacenterType datacenterType;

        DatacenterV2(String name, int repFactor, DatacenterType datacenterType, boolean allowArbiters, boolean masterAffinity) {
            super(name, repFactor, allowArbiters, masterAffinity);
            ObjectUtil.checkNull("datacenterType", datacenterType);
            this.datacenterType = datacenterType;
        }

        private DatacenterV2(DatacenterV2 datacenter) {
            super(datacenter);
            this.datacenterType = datacenter.datacenterType;
        }

        private DatacenterV2(Topology topology, DatacenterId datacenterId, DataInput in, short serialVersion) throws IOException {
            super(topology, datacenterId, in, serialVersion);
            this.datacenterType = DatacenterType.readFastExternal(in, serialVersion);
        }

        private DatacenterV2() {
        }

        @Override
        public DatacenterType getDatacenterType() {
            return this.datacenterType;
        }

        @Override
        public DatacenterV2 clone() {
            return new DatacenterV2(this);
        }
    }
}

