/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import org.eclipse.persistence.internal.security.JCEEncryptor;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ConcurrentDecryptionTest
extends AutoVerifyTestCase {
    public boolean run;
    public Exception error;
    public int threadCount = 100;
    public String password = "test1";
    public int sleepTime = 8000;
    private JCEEncryptor encryptor;
    private String encryptedPassword;

    protected void setup() throws Throwable {
        this.encryptor = new JCEEncryptor();
        this.encryptedPassword = this.encryptor.encryptPassword(this.password);
    }

    protected void test() throws Throwable {
        this.run = true;
        this.error = null;
        try {
            int i;
            Thread[] thread = new Thread[this.threadCount];
            for (i = 0; i < this.threadCount; ++i) {
                thread[i] = new Thread(new Runner1(this));
            }
            for (i = 0; i < this.threadCount; ++i) {
                thread[i].start();
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.run = false;
        }
    }

    protected void verify() throws Throwable {
        if (this.error != null) {
            throw new TestErrorException("error encountered: " + this.error, (Throwable)this.error);
        }
    }

    class Runner1
    implements Runnable {
        protected ConcurrentDecryptionTest concurrentDecryptionTest;

        public Runner1(ConcurrentDecryptionTest concurrentDecryptionTest) {
            this.concurrentDecryptionTest = concurrentDecryptionTest;
        }

        @Override
        public void run() {
            try {
                while (this.concurrentDecryptionTest.run && this.concurrentDecryptionTest.error == null) {
                    this.concurrentDecryptionTest.encryptor.decryptPassword(this.concurrentDecryptionTest.encryptedPassword);
                }
            }
            catch (Exception e) {
                this.concurrentDecryptionTest.run = false;
                this.concurrentDecryptionTest.error = e;
            }
        }
    }
}

