/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class RuntimeCustomSQLQueriesTest
extends AutoVerifyTestCase {
    public static final String PROJECT_FILE = "CustomSQLQueriesProject.xml";
    public static final String INSERT_SQL = "INSERT TEST";
    public static final String READ_OBJECT_SQL = "READ OBJECT TEST";
    public static final String READ_ALL_SQL = "READ ALL TEST";
    public static final String UPDATE_SQL = "UPDATE TEST";
    public static final String DELETE_SQL = "DELETE TEST";

    public RuntimeCustomSQLQueriesTest() {
        this.setDescription("Validate custom defined SQL queries by reading from an XML project");
    }

    protected void setup() {
        EmployeeProject project = new EmployeeProject();
        ClassDescriptor addressDescriptor = (ClassDescriptor)project.getDescriptors().get(Address.class);
        addressDescriptor.getQueryManager().setInsertSQLString(INSERT_SQL);
        addressDescriptor.getQueryManager().setReadObjectSQLString(READ_OBJECT_SQL);
        addressDescriptor.getQueryManager().setReadAllSQLString(READ_ALL_SQL);
        addressDescriptor.getQueryManager().setUpdateSQLString(UPDATE_SQL);
        addressDescriptor.getQueryManager().setDeleteSQLString(DELETE_SQL);
        XMLProjectWriter.write((String)PROJECT_FILE, (Project)project);
    }

    protected void test() {
        Project project = XMLProjectReader.read((String)PROJECT_FILE, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ClassDescriptor addressDescriptor = (ClassDescriptor)project.getDescriptors().get(Address.class);
        if (!addressDescriptor.getQueryManager().getInsertSQLString().equals(INSERT_SQL)) {
            throw new TestErrorException("Custom insert SQL for Address is not equal to INSERT TEST");
        }
        if (!addressDescriptor.getQueryManager().getReadObjectSQLString().equals(READ_OBJECT_SQL)) {
            throw new TestErrorException("Custom read object SQL for Address is not equal to READ OBJECT TEST");
        }
        if (!addressDescriptor.getQueryManager().getReadAllSQLString().equals(READ_ALL_SQL)) {
            throw new TestErrorException("Custom read all SQL for Address is not equal to READ ALL TEST");
        }
        if (!addressDescriptor.getQueryManager().getUpdateSQLString().equals(UPDATE_SQL)) {
            throw new TestErrorException("Custom update SQL for Address is not equal to UPDATE TEST");
        }
        if (!addressDescriptor.getQueryManager().getDeleteSQLString().equals(DELETE_SQL)) {
            throw new TestErrorException("Custom delete SQL for Address is not equal to DELETE TEST");
        }
    }
}

