/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
// October 30, 2012
package org.eclipse.persistence.testing.jaxb.annotations.xmltransformation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;

import org.eclipse.persistence.testing.jaxb.JAXBWithJSONTestCases;

public class SimpleRootTestCases extends JAXBWithJSONTestCases{

    public SimpleRootTestCases(String name) throws Exception {
        super(name);
        setControlDocument("org/eclipse/persistence/testing/jaxb/annotations/xmltransformation/simpleRoot.xml");
        setControlJSON("org/eclipse/persistence/testing/jaxb/annotations/xmltransformation/simpleRoot.json");
        setClasses(new Class<?>[]{SimpleRoot.class});
    }

    @Override
    protected Object getControlObject() {
       SimpleRoot so = new SimpleRoot();
       return so;
    }

}
