/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.Vector;
import org.eclipse.persistence.testing.framework.PromptTestRunner;
import org.eclipse.persistence.testing.tests.TestRunModel;

public class BatchTestRunner {
    protected static final String PROPERTIES_FILE_FLAG = "pfile=";
    protected static final String BATCH_NAME_FLAG = "batchname=";
    protected static final String LIGHT_RUN_ALL = "lightrunall";
    protected static final String MEDIUM_RUN_ALL = "mediumrunall";
    protected static final String TEST_NOT_IN_LIGHT_RUN_ALL = "testnotinlightrunall";
    private String pFileName;
    private String batchName;
    private Vector<String> testList;

    public static void log(String str) {
        System.out.println(str);
    }

    public static void main(String[] args) {
        new BatchTestRunner().run(args);
    }

    private void run(String[] args) {
        if (args.length < 2) {
            this.printUsageAndExit();
        }
        for (int i = 0; i < args.length; ++i) {
            this.processArguments(args[i]);
        }
        long startTime = System.currentTimeMillis();
        BatchTestRunner.log("*** Beginning of running " + this.batchName + ", model by model. ***");
        PromptTestRunner ptr = new PromptTestRunner();
        for (int index = 0; index < this.testList.size(); ++index) {
            String arg1 = "testmodel=" + this.testList.elementAt(index);
            String arg2 = PROPERTIES_FILE_FLAG + this.pFileName;
            String[] a = new String[]{arg1, arg2};
            BatchTestRunner.log("*** Running " + this.testList.elementAt(index));
            ptr.run(a);
        }
        long endTime = System.currentTimeMillis();
        BatchTestRunner.log("*** End of running " + this.batchName + ", model by model. ***");
        BatchTestRunner.log("*** " + this.testList.size() + " test models. ");
        BatchTestRunner.log("*** Total running time is " + (endTime - startTime) / 60000L + "m " + (endTime - startTime) / 1000L % 60L + "s.");
        System.exit(0);
    }

    public void printUsageAndExit() {
        BatchTestRunner.log("Usage:\n\tBatchTestRunner pfile=<PropertiesFile> batchname=<BatchName>");
        BatchTestRunner.log("\n\tbatchname=<BatchName> The name could be lightrunallmediumrunall or testnotinlightrunall");
        BatchTestRunner.log("\n\tpfile=<PropertiesFile> The specified properties file name");
        BatchTestRunner.log("\n\t\tTemplate of properties file:");
        BatchTestRunner.log("\n\t\t\t# properties for DatabseSession");
        BatchTestRunner.log("\n\t\t\tsession.log=c:\\temp.txt");
        BatchTestRunner.log("\n\t\t\tsession.logMessages=false");
        BatchTestRunner.log("\n\n\t\t\t# properties for TestExecutor");
        BatchTestRunner.log("\n\t\t\texecutor.handleErrors=true");
        BatchTestRunner.log("\n\n\t\t\t# properties for DatabaseLogin");
        BatchTestRunner.log("\n\t\t\tlogin.databaseplatform=ORACLE");
        BatchTestRunner.log("\n\t\t\tlogin.driverClass=oracle.jdbc.OracleDriver");
        BatchTestRunner.log("\n\t\t\tlogin.databaseURL=jdbc:oracle:thin:@localhost:1521:ORCL");
        BatchTestRunner.log("\n\t\t\tlogin.username=scott");
        BatchTestRunner.log("\n\t\t\tlogin.password=tiger");
        BatchTestRunner.log("\n\tExample:  java org.eclipse.persistence.testing.Testframework.BatchTestRunner ");
        BatchTestRunner.log("\n\t\tbatchname=lightrunall");
        BatchTestRunner.log("\n\t\tpfile=C:\\titlcore.properties");
        System.exit(1);
    }

    private void processArguments(String arg) {
        if (arg.startsWith(PROPERTIES_FILE_FLAG)) {
            this.pFileName = arg.substring(PROPERTIES_FILE_FLAG.length());
        } else if (arg.startsWith(BATCH_NAME_FLAG)) {
            this.batchName = arg.substring(BATCH_NAME_FLAG.length());
            if (this.batchName.equalsIgnoreCase(LIGHT_RUN_ALL)) {
                this.testList = TestRunModel.buildLRGTestList();
            } else if (this.batchName.equalsIgnoreCase(MEDIUM_RUN_ALL)) {
                this.testList = TestRunModel.buildAllTestModelsList();
            } else if (this.batchName.equalsIgnoreCase(TEST_NOT_IN_LIGHT_RUN_ALL)) {
                this.testList = TestRunModel.buildNonLRGTestList();
            } else {
                BatchTestRunner.log("Invaild batch name.");
                BatchTestRunner.log("Correct batch name should be lightrunall, mediumrunall or testnotinlightrunall");
                System.exit(1);
            }
        }
    }
}

