/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.sessionconsole;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.tools.beans.MessageDialog;
import org.eclipse.persistence.tools.profiler.Profile;

public class ProfileBrowserPanel
extends JPanel {
    private List<Profile> fieldProfiles = new ArrayList<Profile>();
    private JScrollPane ivjProfileScrollPane = null;
    private JTable ivjProfilesTable = null;
    private JComboBox<String> ivjGroupByChoice = null;
    private JLabel ivjGroupByLabel = null;
    private JCheckBox ivjQualifyClassNameCheckbox = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public ProfileBrowserPanel() {
        this.initialize();
    }

    public ProfileBrowserPanel(LayoutManager layout) {
        super(layout);
    }

    public ProfileBrowserPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ProfileBrowserPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public static void browseProfiles(List<Profile> profiles) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame frame = new JFrame();
            ProfileBrowserPanel aProfileBrowserPanel = new ProfileBrowserPanel();
            frame.getContentPane().add("Center", aProfileBrowserPanel);
            frame.setSize(aProfileBrowserPanel.getSize());
            frame.setVisible(true);
            aProfileBrowserPanel.setProfiles(profiles);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    public List<Profile> buildProfileSummaryByClass() {
        Hashtable<Class<Void>, Profile> summaries = new Hashtable<Class<Void>, Profile>();
        for (Profile profile : this.getProfiles()) {
            Profile summary;
            Class<Void> domainClass = profile.getDomainClass();
            if (domainClass == null) {
                domainClass = Void.class;
            }
            if ((summary = (Profile)summaries.get(domainClass)) == null) {
                summary = new Profile();
                summary.setDomainClass(domainClass);
                summaries.put(domainClass, summary);
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            for (Map.Entry entry : profile.getOperationTimings().entrySet()) {
                String name = (String)entry.getKey();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)entry.getValue();
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        Vector<Profile> summary = new Vector<Profile>();
        Enumeration profilesEnum = summaries.elements();
        while (profilesEnum.hasMoreElements()) {
            summary.add((Profile)profilesEnum.nextElement());
        }
        return summary;
    }

    public List<Profile> buildProfileSummaryByQuery() {
        Hashtable<Class<Void>, Profile> summaries = new Hashtable<Class<Void>, Profile>();
        for (Profile profile : this.getProfiles()) {
            Profile summary;
            Class<Void> queryType = profile.getQueryClass();
            if (queryType == null) {
                queryType = Void.class;
            }
            if ((summary = (Profile)summaries.get(queryType)) == null) {
                summary = new Profile();
                summary.setQueryClass(queryType);
                summaries.put(queryType, summary);
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            for (Map.Entry entry : profile.getOperationTimings().entrySet()) {
                String name = (String)entry.getKey();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)entry.getValue();
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        Vector<Profile> summary = new Vector<Profile>();
        Enumeration profilesEnum = summaries.elements();
        while (profilesEnum.hasMoreElements()) {
            summary.add((Profile)profilesEnum.nextElement());
        }
        return summary;
    }

    public List<Profile> buildProfileSummaryByQueryAndClass() {
        Hashtable<Class, Map> summaries = new Hashtable<Class, Map>();
        for (Profile profile : this.getProfiles()) {
            Map summaryByQuery;
            Profile summary;
            Class<Void> queryType = profile.getQueryClass();
            Class<Void> queryClass = profile.getDomainClass();
            if (queryClass == null) {
                queryClass = Void.class;
            }
            if (queryType == null) {
                queryType = Void.class;
            }
            if ((summary = (Profile)(summaryByQuery = summaries.computeIfAbsent(queryType, k -> new Hashtable())).get(queryClass)) == null) {
                summary = new Profile();
                summary.setQueryClass(queryType);
                summary.setDomainClass(queryClass);
                summaryByQuery.put(queryClass, summary);
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            for (Map.Entry entry : profile.getOperationTimings().entrySet()) {
                String name = (String)entry.getKey();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)entry.getValue();
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        Vector<Profile> summary = new Vector<Profile>();
        for (Map m : summaries.values()) {
            summary.addAll(m.values());
        }
        return summary;
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.resetProfiles();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.resetProfiles();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JComboBox<String> getGroupByChoice() {
        if (this.ivjGroupByChoice == null) {
            try {
                this.ivjGroupByChoice = new JComboBox();
                this.ivjGroupByChoice.setName("GroupByChoice");
                this.ivjGroupByChoice.setBackground(SystemColor.window);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGroupByChoice;
    }

    private JLabel getGroupByLabel() {
        if (this.ivjGroupByLabel == null) {
            try {
                this.ivjGroupByLabel = new JLabel();
                this.ivjGroupByLabel.setName("GroupByLabel");
                this.ivjGroupByLabel.setText("Group By:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGroupByLabel;
    }

    public List<Profile> getProfiles() {
        return this.fieldProfiles;
    }

    private JScrollPane getProfileScrollPane() {
        if (this.ivjProfileScrollPane == null) {
            try {
                this.ivjProfileScrollPane = new JScrollPane();
                this.ivjProfileScrollPane.setName("ProfileScrollPane");
                this.ivjProfileScrollPane.setVerticalScrollBarPolicy(22);
                this.ivjProfileScrollPane.setHorizontalScrollBarPolicy(32);
                this.ivjProfileScrollPane.setBackground(SystemColor.window);
                this.getProfileScrollPane().setViewportView(this.getProfilesTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjProfileScrollPane;
    }

    private JTable getProfilesTable() {
        if (this.ivjProfilesTable == null) {
            try {
                this.ivjProfilesTable = new JTable();
                this.ivjProfilesTable.setName("ProfilesTable");
                this.getProfileScrollPane().setColumnHeaderView(this.ivjProfilesTable.getTableHeader());
                this.ivjProfilesTable.setCellSelectionEnabled(true);
                this.ivjProfilesTable.setColumnSelectionAllowed(true);
                this.ivjProfilesTable.setBounds(0, 0, 200, 200);
                this.ivjProfilesTable.setAutoCreateColumnsFromModel(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjProfilesTable;
    }

    private JCheckBox getQualifyClassNameCheckbox() {
        if (this.ivjQualifyClassNameCheckbox == null) {
            try {
                this.ivjQualifyClassNameCheckbox = new JCheckBox();
                this.ivjQualifyClassNameCheckbox.setName("QualifyClassNameCheckbox");
                this.ivjQualifyClassNameCheckbox.setText("Qualify Class Name");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjQualifyClassNameCheckbox;
    }

    private void handleException(Throwable exception) {
        MessageDialog.displayException(exception, this);
    }

    private void initConnections() {
        this.getQualifyClassNameCheckbox().addActionListener(this.ivjEventHandler);
        this.getGroupByChoice().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ProfileBrowserPanel");
            this.setLayout(new GridBagLayout());
            this.setBackground(SystemColor.control);
            this.setSize(808, 522);
            GridBagConstraints constraintsProfileScrollPane = new GridBagConstraints();
            constraintsProfileScrollPane.gridx = 0;
            constraintsProfileScrollPane.gridy = 2;
            constraintsProfileScrollPane.gridwidth = 6;
            constraintsProfileScrollPane.fill = 1;
            constraintsProfileScrollPane.weightx = 1.0;
            constraintsProfileScrollPane.weighty = 1.0;
            this.add((Component)this.getProfileScrollPane(), constraintsProfileScrollPane);
            GridBagConstraints constraintsQualifyClassNameCheckbox = new GridBagConstraints();
            constraintsQualifyClassNameCheckbox.gridx = 0;
            constraintsQualifyClassNameCheckbox.gridy = 1;
            constraintsQualifyClassNameCheckbox.insets = new Insets(0, 0, 2, 0);
            this.add((Component)this.getQualifyClassNameCheckbox(), constraintsQualifyClassNameCheckbox);
            GridBagConstraints constraintsGroupByLabel = new GridBagConstraints();
            constraintsGroupByLabel.gridx = 0;
            constraintsGroupByLabel.gridy = 0;
            constraintsGroupByLabel.anchor = 17;
            this.add((Component)this.getGroupByLabel(), constraintsGroupByLabel);
            GridBagConstraints constraintsGroupByChoice = new GridBagConstraints();
            constraintsGroupByChoice.gridx = 5;
            constraintsGroupByChoice.gridy = 0;
            constraintsGroupByChoice.anchor = 17;
            this.add(this.getGroupByChoice(), constraintsGroupByChoice);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void resetProfiles() {
        DefaultTableModel model = new DefaultTableModel();
        Vector<String> columns = new Vector<String>();
        columns.add("Query");
        columns.add("Class");
        columns.add("Total Time");
        columns.add("Local Time");
        columns.add("# of Objects");
        columns.add("Object/Second");
        columns.add("SQL Prepare");
        columns.add("SQL Execute");
        columns.add("Row Fetch");
        columns.add("Cache");
        columns.add("Object Building");
        columns.add("Query Prepare");
        columns.add("SQL Generation");
        model.setColumnIdentifiers(columns);
        List<Profile> profiles = this.getProfiles();
        if (this.getGroupByChoice().getModel().getSelectedItem().equals("Group By Query")) {
            profiles = this.buildProfileSummaryByQuery();
        } else if (this.getGroupByChoice().getModel().getSelectedItem().equals("Group By Class")) {
            profiles = this.buildProfileSummaryByClass();
        } else if (this.getGroupByChoice().getModel().getSelectedItem().equals("Group By Class and Query")) {
            profiles = this.buildProfileSummaryByQueryAndClass();
        }
        for (Profile profile : profiles) {
            Object[] items = new String[]{profile.getQueryClass() == null ? "" : Helper.getShortClassName((Class)profile.getQueryClass()), profile.getDomainClass() == null ? "" : (this.getQualifyClassNameCheckbox().getModel().isSelected() ? profile.getDomainClass().getName() : Helper.getShortClassName((Class)profile.getDomainClass())), Long.valueOf(profile.getTotalTime()).toString(), Long.valueOf(profile.getLocalTime()).toString(), Long.valueOf(profile.getNumberOfInstancesEffected()).toString(), Long.valueOf(profile.getObjectsPerSecond()).toString(), profile.getOperationTimings().containsKey("Timer:SqlPrepare") ? ((Long)profile.getOperationTimings().get("Timer:SqlPrepare")).toString() : "", profile.getOperationTimings().containsKey("Timer:StatementExecute") ? ((Long)profile.getOperationTimings().get("Timer:StatementExecute")).toString() : "", profile.getOperationTimings().containsKey("Timer:RowFetch") ? ((Long)profile.getOperationTimings().get("Timer:RowFetch")).toString() : "", profile.getOperationTimings().containsKey("Timer:Caching") ? ((Long)profile.getOperationTimings().get("Timer:Caching")).toString() : "", profile.getOperationTimings().containsKey("Timer:ObjectBuilding") ? ((Long)profile.getOperationTimings().get("Timer:ObjectBuilding")).toString() : "", profile.getOperationTimings().containsKey("Timer:QueryPreparation") ? ((Long)profile.getOperationTimings().get("Timer:QueryPreparation")).toString() : "", profile.getOperationTimings().containsKey("Timer:SqlGeneration") ? ((Long)profile.getOperationTimings().get("Timer:SqlGeneration")).toString() : ""};
            model.addRow(items);
        }
        this.getProfilesTable().setModel(model);
    }

    public void setProfiles(List<Profile> profiles) {
        List<Profile> oldValue = this.fieldProfiles;
        this.fieldProfiles = profiles;
        this.firePropertyChange("profiles", oldValue, profiles);
        this.resetProfiles();
    }

    protected void setup() {
        this.getGroupByChoice().addItem("None");
        this.getGroupByChoice().addItem("Group By Class");
        this.getGroupByChoice().addItem("Group By Query");
        this.getGroupByChoice().addItem("Group By Class and Query");
    }

    class IvjEventHandler
    implements ActionListener,
    ItemListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ProfileBrowserPanel.this.getQualifyClassNameCheckbox()) {
                ProfileBrowserPanel.this.connEtoC1(e);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == ProfileBrowserPanel.this.getGroupByChoice()) {
                ProfileBrowserPanel.this.connEtoC2(e);
            }
        }
    }
}

