/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.FastExternalizableException;
import oracle.kv.impl.util.SerializationUtil;

public class TableVersionException
extends FastExternalizableException {
    private final int requiredVersion;
    private static final long serialVersionUID = 1L;

    public TableVersionException(int requiredVersion) {
        super("Requires table version " + requiredVersion);
        this.requiredVersion = requiredVersion;
    }

    public int getRequiredVersion() {
        return this.requiredVersion;
    }

    public TableVersionException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.requiredVersion = SerializationUtil.readPackedInt(in);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.requiredVersion);
    }
}

