/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class FourPartialAttributeTestsWithJoinAttribute
extends TestCase {
    static String lastName = "PartialAttributeTest";
    Vector[] results = new Vector[4];

    public FourPartialAttributeTestsWithJoinAttribute() {
        this.setDescription("A partial attribute query where the partial attribute is also joined - 4 tests: all combinations of (inner join vs outer join) and (get(address) vs get(address).get(city)).");
    }

    public void setup() {
        this.cleanup();
        Employee empA = new Employee();
        empA.setLastName(lastName);
        empA.setFirstName("A");
        Address address = new Address();
        address.setCountry("Canada");
        address.setCity("Ottawa");
        address.setStreet("O'Connor");
        empA.setAddress(address);
        Employee empB = new Employee();
        empB.setLastName(lastName);
        empB.setFirstName("B");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerNewObject((Object)empA);
        uow.registerNewObject((Object)empB);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadAllQuery[] queries = new ReadAllQuery[]{this.createQuery(), this.createQuery(), this.createQuery(), this.createQuery()};
        queries[0].addPartialAttribute("address");
        queries[1].addPartialAttribute(queries[1].getExpressionBuilder().get("address").get("city"));
        queries[2].addPartialAttribute(queries[2].getExpressionBuilder().getAllowingNull("address"));
        queries[3].addPartialAttribute(queries[3].getExpressionBuilder().getAllowingNull("address").get("city"));
        for (int i = 0; i < 4; ++i) {
            this.results[i] = (Vector)this.getSession().executeQuery((DatabaseQuery)queries[i]);
        }
    }

    protected void verify() {
        Object errorMsg = "";
        for (int i = 0; i < 4; ++i) {
            Employee empA = null;
            if (this.results[i].size() >= 1) {
                empA = (Employee)this.results[i].elementAt(0);
            }
            Employee empB = null;
            if (this.results[i].size() >= 2) {
                empB = (Employee)this.results[i].elementAt(1);
            }
            if (empA == null) {
                errorMsg = (String)errorMsg + "query" + i + " hasn't returned Employee A; ";
            } else if (empA.getAddress() == null) {
                errorMsg = (String)errorMsg + "query" + i + " returned Employee A with null Address; ";
            }
            if (i == 0 || i == 1) {
                if (empB == null) continue;
                errorMsg = (String)errorMsg + "query" + i + " has returned Employee B; ";
                continue;
            }
            if (empB == null) {
                errorMsg = (String)errorMsg + "query" + i + " has not returned Employee B; ";
                continue;
            }
            if (i == 2) {
                if (empB.getAddress() == null) continue;
                errorMsg = (String)errorMsg + "query" + i + " has returned Employee B's address; ";
                continue;
            }
            if (empB.getAddress() == null) {
                errorMsg = (String)errorMsg + "query" + i + " has not returned Employee B's address; ";
                continue;
            }
            if (empB.getAddress().getCity() == null) continue;
            errorMsg = (String)errorMsg + "query" + i + " has returned Employee B's address with city != null; ";
        }
        if (((String)errorMsg).length() > 0) {
            throw new TestErrorException((String)errorMsg);
        }
    }

    public void reset() {
        this.cleanup();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected ReadAllQuery createQuery() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        query.setSelectionCriteria(query.getExpressionBuilder().get("lastName").equal((Object)lastName));
        query.addPartialAttribute("firstName");
        query.addPartialAttribute("lastName");
        query.addOrdering(query.getExpressionBuilder().get("firstName").ascending());
        return query;
    }

    protected void cleanup() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("lastName").equal((Object)lastName));
        Vector result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        if (!result.isEmpty()) {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            for (int i = 0; i < result.size(); ++i) {
                uow.deleteObject(result.elementAt(i));
            }
            uow.commit();
        }
    }
}

