/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class AppendLockTest
extends AutoVerifyTestCase {
    Employee emp = null;
    SmallProject project = null;
    Address address = null;

    protected void setup() throws Throwable {
        super.setup();
        this.getExecutor().swapServerSession();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.project = new SmallProject();
        uow.registerNewObject((Object)this.project);
        this.emp = new Employee();
        this.address = new Address();
        uow.registerNewObject((Object)this.address);
        uow.registerNewObject((Object)this.emp);
        uow.commit();
    }

    protected void test() throws Throwable {
        block4: {
            super.test();
            Thread locker = new Thread(new Locker(this.getSession(), this.address));
            Thread writer1 = new Thread(new Writer1(this.getSession(), this.emp, this.project, this.address));
            Thread writer2 = new Thread(new Writer2(this.getSession(), this.project));
            locker.start();
            writer1.start();
            writer2.start();
            writer2.join(60000L);
            try {
                if (!writer2.isAlive()) break block4;
                try {
                    writer2.interrupt();
                    writer1.interrupt();
                    locker.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AppendLockTest.fail((String)"Bug 9484687 - deadlock occured.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reset() throws Throwable {
        super.reset();
        this.getExecutor().resetSession();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.project = (SmallProject)uow.refreshObject((Object)this.project);
        this.emp = (Employee)uow.refreshObject((Object)this.emp);
        uow.deleteObject((Object)this.project);
        uow.deleteObject((Object)this.emp);
        uow.commit();
    }

    public static class Locker
    implements Runnable {
        protected Address address;
        protected Session session;

        public Locker(Session session, Address address) {
            this.session = session;
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheKey cacheKey = null;
            Session session = this.session;
            synchronized (session) {
                try {
                    this.session.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                cacheKey = ((AbstractSession)this.session).getIdentityMapAccessorInstance().acquireLock((Object)this.address.getId(), this.address.getClass(), this.session.getClassDescriptor((Object)this.address), false);
                session = this.session;
                synchronized (session) {
                    this.session.notifyAll();
                    try {
                        this.session.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                cacheKey.release();
            }
        }
    }

    public static class Writer1
    implements Runnable {
        protected Project project;
        protected Employee emp;
        protected Session session;
        protected Address address;

        public Writer1(Session session, Employee emp, Project project, Address address) {
            this.session = session;
            this.project = project;
            this.emp = emp;
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UnitOfWork uow = this.session.acquireUnitOfWork();
            Project p = (Project)uow.readObject((Object)this.project);
            Address address = (Address)uow.readObject((Object)this.address);
            Employee emp = (Employee)uow.readObject((Object)this.emp);
            emp.setAddress(address);
            p.setDescription("SomeBigLongDescription");
            ((AbstractSession)this.session).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.project).setObject(null);
            ((UnitOfWorkImpl)uow).getCloneToOriginals().remove(p);
            Session session = this.session;
            synchronized (session) {
                try {
                    this.session.notifyAll();
                    this.session.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            uow.commit();
            session = this.session;
            synchronized (session) {
                this.session.notifyAll();
            }
        }
    }

    public static class Writer2
    implements Runnable {
        protected Session session;
        protected Project project;

        public Writer2(Session session, Project project) {
            this.session = session;
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session session = this.session;
            synchronized (session) {
                try {
                    this.session.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            session = this.session;
            synchronized (session) {
                try {
                    this.session.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            session = this.session;
            synchronized (session) {
                try {
                    this.session.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            UnitOfWork uow = this.session.acquireUnitOfWork();
            try {
                this.project = (Project)uow.refreshObject((Object)this.project);
                Session e = this.session;
                synchronized (e) {
                    this.session.notifyAll();
                }
                uow.release();
            }
            catch (Exception ex) {
                System.out.println("Thread was interrupted");
            }
        }
    }
}

