/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class IllegalTableNameInMultipleTableForeignKeyTest_Target
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;

    public IllegalTableNameInMultipleTableForeignKeyTest_Target() {
        this.setDescription("This tests Illegal Table Name In Multiply Table Foreign Key (Target) (TL-ERROR 135)");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.expectedException = DescriptorException.illegalTableNameInMultipleTableForeignKeyField(null, null);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.descriptor().preInitialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addTableName("SALARY");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("SALARY_BAD.EMP_ID", "EMPLOYEE.EMP_ID");
        return descriptor;
    }
}

