/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

public class DiscriminatorClassMetadata
extends ORMetadata {
    private Class m_value;
    private String m_valueName;
    private String m_discriminator;

    public DiscriminatorClassMetadata() {
        super("<discriminator-class>");
    }

    public DiscriminatorClassMetadata(Annotation discriminatorClass, MetadataAccessibleObject accessibleObject) {
        super(discriminatorClass, accessibleObject);
        this.setDiscriminator((String)MetadataHelper.invokeMethod("discriminator", discriminatorClass));
        this.setValue((Class)MetadataHelper.invokeMethod("value", discriminatorClass));
    }

    public String getDiscriminator() {
        return this.m_discriminator;
    }

    public Class getValue() {
        return this.m_value;
    }

    public String getValueName() {
        return this.m_valueName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.m_value = this.initXMLClassName(this.m_valueName);
    }

    public void process(VariableOneToOneMapping mapping) {
        if (mapping.getTypeIndicatorNameTranslation().containsValue(this.m_discriminator)) {
            throw ValidationException.multipleClassesForTheSameDiscriminator(this.m_discriminator, mapping.getAttributeName());
        }
        mapping.addClassNameIndicator(this.m_value.getName(), this.m_discriminator);
    }

    public void setDiscriminator(String discriminator) {
        this.m_discriminator = discriminator;
    }

    public void setValue(Class value) {
        this.m_value = value;
    }

    public void setValueName(String valueName) {
        this.m_valueName = valueName;
    }
}

