/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsMappingProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.xml.sax.SAXException;

public class XMLEntityMappingsReader {
    public static final String ORM_1_0_XSD = "org/eclipse/persistence/jpa/orm_1_0.xsd";
    public static final String ORM_1_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ECLIPSELINK_ORM_XSD_VERSION = "1.1";
    public static final String ECLIPSELINK_ORM_XSD_NAME = "eclipselink_orm_1_1.xsd";
    public static final String ECLIPSELINK_ORM_XSD = "xsd/eclipselink_orm_1_1.xsd";
    public static final String ECLIPSELINK_ORM_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static XMLContext m_orm1_0Project;
    private static XMLContext m_eclipseLinkOrmProject;

    protected static XMLEntityMappings read(URL mappingFileUrl, Reader reader1, Reader reader2, ClassLoader classLoader, Properties properties) {
        XMLEntityMappings xmlEntityMappings;
        boolean validateORMSchema = XMLEntityMappingsReader.isORMSchemaValidationPerformed(properties);
        if (m_orm1_0Project == null) {
            m_orm1_0Project = new XMLContext(new XMLEntityMappingsMappingProject(ORM_1_0_NAMESPACE, ORM_1_0_XSD));
            m_eclipseLinkOrmProject = new XMLContext(new XMLEntityMappingsMappingProject(ECLIPSELINK_ORM_NAMESPACE, ECLIPSELINK_ORM_XSD));
        }
        try {
            XMLUnmarshaller unmarshaller = m_orm1_0Project.createUnmarshaller();
            XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, ORM_1_0_XSD, validateORMSchema);
            xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader1);
        }
        catch (Exception e) {
            try {
                XMLUnmarshaller unmarshaller = m_eclipseLinkOrmProject.createUnmarshaller();
                XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, ECLIPSELINK_ORM_XSD, validateORMSchema);
                xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader2);
            }
            catch (Exception ee) {
                throw ValidationException.errorParsingMappingFile(mappingFileUrl, ee);
            }
        }
        return xmlEntityMappings;
    }

    private static InputStreamReader getInputStreamReader(URL url) throws IOException {
        URLConnection cnx1 = url.openConnection();
        cnx1.setUseCaches(false);
        return new InputStreamReader(cnx1.getInputStream(), "UTF-8");
    }

    public static XMLEntityMappings read(URL url, ClassLoader classLoader) throws IOException {
        return XMLEntityMappingsReader.read(url, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEntityMappings read(URL url, ClassLoader classLoader, Properties properties) throws IOException {
        InputStreamReader reader1 = null;
        InputStreamReader reader2 = null;
        try {
            try {
                reader1 = XMLEntityMappingsReader.getInputStreamReader(url);
                reader2 = XMLEntityMappingsReader.getInputStreamReader(url);
            }
            catch (UnsupportedEncodingException exception) {
                throw ValidationException.fatalErrorOccurred(exception);
            }
            XMLEntityMappings entityMappings = XMLEntityMappingsReader.read(url, reader1, reader2, classLoader, properties);
            entityMappings.setMappingFile(url);
            XMLEntityMappings xMLEntityMappings = entityMappings;
            return xMLEntityMappings;
        }
        finally {
            try {
                if (reader1 != null) {
                    reader1.close();
                }
                if (reader2 != null) {
                    reader2.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useLocalSchemaForUnmarshaller(XMLUnmarshaller unmarshaller, String schemaName, boolean validateORMSchema) throws IOException, SAXException {
        URL url = XMLEntityMappingsReader.class.getClassLoader().getResource(schemaName);
        InputStream schemaStream = url.openStream();
        StreamSource source = new StreamSource(url.openStream());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(source);
        try {
            if (validateORMSchema) {
                unmarshaller.setSchema(schema);
            }
        }
        catch (UnsupportedOperationException ex) {
            if (validateORMSchema) {
                unmarshaller.setValidationMode(3);
            } else {
                unmarshaller.setValidationMode(0);
            }
        }
        finally {
            schemaStream.close();
        }
    }

    private static boolean isORMSchemaValidationPerformed(Properties properties) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.orm.validate.schema", properties, "false");
        return null != value && value.equalsIgnoreCase("true");
    }
}

