/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInsideJarURLArchive
implements Archive {
    private JarFile jarFile;
    private URL rootURL;
    private String relativeRootPath;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public DirectoryInsideJarURLArchive(URL url) throws IOException {
        this(url, Logger.global);
    }

    public DirectoryInsideJarURLArchive(URL url, Logger logger) throws IOException {
        logger.entering("DirectoryInsideJarURLArchive", "DirectoryInsideJarURLArchive", new Object[]{url});
        this.logger = logger;
        assert (url.getProtocol().equals("jar"));
        this.rootURL = url;
        JarURLConnection conn = (JarURLConnection)JarURLConnection.class.cast(url.openConnection());
        this.jarFile = conn.getJarFile();
        logger.logp(Level.FINER, "DirectoryInsideJarURLArchive", "DirectoryInsideJarURLArchive", "jarFile = {0}", this.jarFile);
        this.relativeRootPath = conn.getEntryName();
        this.init();
    }

    private void init() {
        Enumeration<JarEntry> jarEntries = this.jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            String jarEntryName = jarEntry.getName();
            if (this.relativeRootPath == null) {
                this.entries.add(jarEntryName);
                continue;
            }
            if (!jarEntryName.startsWith(this.relativeRootPath)) continue;
            this.entries.add(jarEntryName.substring(this.relativeRootPath.length()));
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        InputStream is = this.entries.contains(entryPath) ? this.jarFile.getInputStream(this.jarFile.getEntry(this.relativeRootPath + entryPath)) : null;
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        URL result = this.entries.contains(entryPath) ? new URL("jar:" + this.rootURL + "!/" + this.relativeRootPath + entryPath) : null;
        return result;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

