/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;

public class OneToOneAccessor
extends ObjectAccessor {
    private String m_mappedBy;

    public OneToOneAccessor() {
        super("<one-to-one>");
    }

    public OneToOneAccessor(MetadataAnnotation oneToOne, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(oneToOne, accessibleObject, classAccessor);
        if (oneToOne != null) {
            this.m_mappedBy = (String)oneToOne.getAttribute("mappedBy");
            this.setOrphanRemoval((Boolean)oneToOne.getAttribute("orphanRemoval"));
        }
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_one_reference_class";
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    protected boolean hasMappedBy() {
        return this.m_mappedBy != null && !this.m_mappedBy.equals("");
    }

    public boolean isOneToOne() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process() {
        OneToOneMapping mapping = this.initOneToOneMapping();
        this.setMapping((DatabaseMapping)mapping);
        if (this.hasMappedBy()) {
            DatabaseMapping owningMapping = this.getOwningMapping(this.getMappedBy());
            if (!owningMapping.isOneToOneMapping()) throw ValidationException.invalidMapping((Object)this.getJavaClass(), (Object)this.getReferenceClass());
            OneToOneMapping ownerMapping = (OneToOneMapping)owningMapping;
            if (ownerMapping.hasRelationTableMechanism()) {
                mapping.setRelationTableMechanism(new RelationTableMechanism());
                this.processMappedByRelationTable(ownerMapping.getRelationTableMechanism(), mapping.getRelationTableMechanism());
                return;
            } else {
                HashMap<DatabaseField, DatabaseField> sourceToTargetKeyFields;
                HashMap<DatabaseField, DatabaseField> targetToSourceKeyFields;
                if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
                    targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>();
                    sourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>();
                    for (DatabaseField fkField : ownerMapping.getSourceToTargetKeyFields().keySet()) {
                        DatabaseField pkField = (DatabaseField)((DatabaseField)ownerMapping.getSourceToTargetKeyFields().get(fkField)).clone();
                        pkField.setTable(this.getDescriptor().getPrimaryTable());
                        sourceToTargetKeyFields.put(fkField, pkField);
                        targetToSourceKeyFields.put(pkField, fkField);
                    }
                } else {
                    targetToSourceKeyFields = ownerMapping.getTargetToSourceKeyFields();
                    sourceToTargetKeyFields = ownerMapping.getSourceToTargetKeyFields();
                }
                mapping.setSourceToTargetKeyFields(targetToSourceKeyFields);
                mapping.setTargetToSourceKeyFields(sourceToTargetKeyFields);
            }
            return;
        } else {
            this.processOwningMappingKeys(mapping);
        }
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }
}

