/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsMappingProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.SAXException;

public class XMLEntityMappingsReader {
    public static final String ORM_1_0_XSD = "org/eclipse/persistence/jpa/orm_1_0.xsd";
    public static final String ORM_1_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ORM_2_0_XSD = "org/eclipse/persistence/jpa/orm_2_0.xsd";
    public static final String ORM_2_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ECLIPSELINK_ORM_XSD = "xsd/eclipselink_orm_2_0.xsd";
    public static final String ECLIPSELINK_ORM_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static XMLContext m_orm1_0Project;
    private static XMLContext m_orm2_0Project;
    private static XMLContext m_eclipseLinkOrmProject;
    private static Schema m_orm1_0Schema;
    private static Schema m_orm2_0Schema;
    private static Schema m_eclipseLinkOrmSchema;

    protected static XMLEntityMappings read(String mappingFile, Reader reader1, Reader reader2, Reader reader3, ClassLoader classLoader, Properties properties) {
        XMLEntityMappings xmlEntityMappings;
        boolean validateORMSchema = XMLEntityMappingsReader.isORMSchemaValidationPerformed(properties);
        try {
            XMLUnmarshaller unmarshaller = XMLEntityMappingsReader.getOrm2Project().createUnmarshaller();
            if (validateORMSchema) {
                XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, XMLEntityMappingsReader.getOrm2_0Schema());
            }
            xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader1);
        }
        catch (Exception orm2Error) {
            try {
                XMLUnmarshaller unmarshaller = XMLEntityMappingsReader.getOrm1Project().createUnmarshaller();
                if (validateORMSchema) {
                    XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, XMLEntityMappingsReader.getOrm1_0Schema());
                }
                xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader2);
            }
            catch (Exception orm1Error) {
                try {
                    XMLUnmarshaller unmarshaller = XMLEntityMappingsReader.getEclipseLinkOrmProject().createUnmarshaller();
                    if (validateORMSchema) {
                        XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(unmarshaller, XMLEntityMappingsReader.getEclipseLinkOrmSchema());
                    }
                    xmlEntityMappings = (XMLEntityMappings)unmarshaller.unmarshal(reader3);
                }
                catch (Exception eclipselinkError) {
                    throw ValidationException.errorParsingMappingFile((String)mappingFile, (Exception)orm2Error, (Exception)orm1Error, (Exception)eclipselinkError);
                }
            }
        }
        if (xmlEntityMappings != null) {
            xmlEntityMappings.setMappingFile(mappingFile);
        }
        return xmlEntityMappings;
    }

    private static InputStreamReader getInputStreamReader(URL url) throws IOException {
        URLConnection cnx1 = url.openConnection();
        cnx1.setUseCaches(false);
        return new InputStreamReader(cnx1.getInputStream(), "UTF-8");
    }

    public static XMLEntityMappings read(URL url, ClassLoader classLoader) throws IOException {
        return XMLEntityMappingsReader.read(url, classLoader, null);
    }

    public static XMLEntityMappings read(URL url, ClassLoader classLoader, Properties properties) throws IOException {
        InputStreamReader reader1 = null;
        InputStreamReader reader2 = null;
        InputStreamReader reader3 = null;
        try {
            reader1 = XMLEntityMappingsReader.getInputStreamReader(url);
            reader2 = XMLEntityMappingsReader.getInputStreamReader(url);
            reader3 = XMLEntityMappingsReader.getInputStreamReader(url);
            XMLEntityMappings xMLEntityMappings = XMLEntityMappingsReader.read(url.toString(), reader1, reader2, reader3, classLoader, properties);
            return xMLEntityMappings;
        }
        catch (UnsupportedEncodingException exception) {
            throw ValidationException.fatalErrorOccurred((Exception)exception);
        }
        finally {
            try {
                if (reader1 != null) {
                    reader1.close();
                }
                if (reader2 != null) {
                    reader2.close();
                }
                if (reader3 != null) {
                    reader3.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
    }

    private static void useLocalSchemaForUnmarshaller(XMLUnmarshaller unmarshaller, Schema schema) {
        try {
            unmarshaller.setSchema(schema);
        }
        catch (UnsupportedOperationException ex) {
            unmarshaller.setValidationMode(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema loadLocalSchema(String schemaName) throws IOException, SAXException {
        URL url = XMLEntityMappingsReader.class.getClassLoader().getResource(schemaName);
        InputStream schemaStream = url.openStream();
        try {
            Schema schema;
            StreamSource source = new StreamSource(url.openStream());
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema2 = schema = schemaFactory.newSchema(source);
            return schema2;
        }
        finally {
            schemaStream.close();
        }
    }

    private static boolean isORMSchemaValidationPerformed(Properties properties) {
        String value = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.orm.validate.schema", properties, "false");
        return null != value && value.equalsIgnoreCase("true");
    }

    public static XMLContext getOrm1Project() {
        if (m_orm1_0Project == null) {
            m_orm1_0Project = new XMLContext((Project)new XMLEntityMappingsMappingProject("http://java.sun.com/xml/ns/persistence/orm", ORM_1_0_XSD));
        }
        return m_orm1_0Project;
    }

    public static XMLContext getOrm2Project() {
        if (m_orm2_0Project == null) {
            m_orm2_0Project = new XMLContext((Project)new XMLEntityMappingsMappingProject("http://java.sun.com/xml/ns/persistence/orm", ORM_2_0_XSD));
        }
        return m_orm2_0Project;
    }

    public static XMLContext getEclipseLinkOrmProject() {
        if (m_eclipseLinkOrmProject == null) {
            m_eclipseLinkOrmProject = new XMLContext((Project)new XMLEntityMappingsMappingProject(ECLIPSELINK_ORM_NAMESPACE, ECLIPSELINK_ORM_XSD));
        }
        return m_eclipseLinkOrmProject;
    }

    public static Schema getOrm1_0Schema() throws IOException, SAXException {
        if (m_orm1_0Schema == null) {
            m_orm1_0Schema = XMLEntityMappingsReader.loadLocalSchema(ORM_1_0_XSD);
        }
        return m_orm1_0Schema;
    }

    public static Schema getOrm2_0Schema() throws IOException, SAXException {
        if (m_orm2_0Schema == null) {
            m_orm2_0Schema = XMLEntityMappingsReader.loadLocalSchema(ORM_2_0_XSD);
        }
        return m_orm2_0Schema;
    }

    public static Schema getEclipseLinkOrmSchema() throws IOException, SAXException {
        if (m_eclipseLinkOrmSchema == null) {
            m_eclipseLinkOrmSchema = XMLEntityMappingsReader.loadLocalSchema(ECLIPSELINK_ORM_XSD);
        }
        return m_eclipseLinkOrmSchema;
    }
}

