/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.IOException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.QuerySequence;
import org.eclipse.persistence.sequencing.Sequence;

public class DatasourcePlatform
implements Platform {
    protected String tableQualifier = "";
    protected transient ConversionManager conversionManager;
    protected ValueReadQuery timestampQuery;
    protected transient Map platformOperators;
    protected Hashtable dataTypesConvertedFromAClass;
    protected Hashtable dataTypesConvertedToAClass;
    protected Sequence defaultSequence;
    protected Map sequences;
    protected String startDelimiter = "";
    protected String endDelimiter = "";

    protected void addOperator(ExpressionOperator operator) {
        this.platformOperators.put(new Integer(operator.getSelector()), operator);
    }

    public void appendParameter(Call call, Writer writer, Object parameter) {
        String parameterValue = (String)this.getConversionManager().convertObject(parameter, ClassConstants.STRING);
        if (parameterValue == null) {
            parameterValue = "";
        }
        try {
            writer.write(parameterValue);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        return value;
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        return false;
    }

    public Object clone() {
        try {
            DatasourcePlatform clone = (DatasourcePlatform)super.clone();
            clone.sequencesAfterCloneCleanup();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void sequencesAfterCloneCleanup() {
        Sequence defaultSequenceClone = null;
        if (this.hasDefaultSequence()) {
            defaultSequenceClone = (Sequence)this.getDefaultSequence().clone();
            this.setDefaultSequence(defaultSequenceClone);
        }
        HashMap<String, Sequence> sequencesDeepClone = null;
        if (this.getSequences() != null) {
            sequencesDeepClone = new HashMap<String, Sequence>(this.getSequences().size());
            for (Sequence sequence : this.getSequences().values()) {
                if (defaultSequenceClone != null && sequence == this.getDefaultSequence()) {
                    sequencesDeepClone.put(defaultSequenceClone.getName(), defaultSequenceClone);
                    continue;
                }
                Sequence sequenceClone = (Sequence)sequence.clone();
                if (sequenceClone instanceof DefaultSequence && !((DefaultSequence)sequenceClone).hasPreallocationSize()) continue;
                sequencesDeepClone.put(sequenceClone.getName(), sequenceClone);
            }
            this.setSequences(sequencesDeepClone);
        }
    }

    public Object convertObject(Object sourceObject, Class javaClass) throws ConversionException {
        return this.getConversionManager().convertObject(sourceObject, javaClass);
    }

    public void copyInto(Platform platform) {
        if (!(platform instanceof DatasourcePlatform)) {
            return;
        }
        DatasourcePlatform datasourcePlatform = (DatasourcePlatform)platform;
        datasourcePlatform.setTableQualifier(this.getTableQualifier());
        datasourcePlatform.setTimestampQuery(this.timestampQuery);
        datasourcePlatform.setConversionManager(this.getConversionManager());
        if (this.hasDefaultSequence()) {
            datasourcePlatform.setDefaultSequence(this.getDefaultSequence());
        }
        datasourcePlatform.setSequences(this.getSequences());
        datasourcePlatform.sequencesAfterCloneCleanup();
    }

    public ConversionManager getConversionManager() {
        if (this.conversionManager == null) {
            this.conversionManager = (ConversionManager)ConversionManager.getDefaultManager().clone();
        }
        return this.conversionManager;
    }

    public void setConversionManager(ConversionManager conversionManager) {
        this.conversionManager = conversionManager;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    public ExpressionOperator getOperator(int selector) {
        return (ExpressionOperator)this.getPlatformOperators().get(new Integer(selector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPlatformOperators() {
        if (this.platformOperators == null) {
            DatasourcePlatform datasourcePlatform = this;
            synchronized (datasourcePlatform) {
                if (this.platformOperators == null) {
                    this.initializePlatformOperators();
                }
            }
        }
        return this.platformOperators;
    }

    public ValueReadQuery getSelectSequenceQuery() {
        if (this.getDefaultSequence() instanceof QuerySequence) {
            return ((QuerySequence)this.getDefaultSequence()).getSelectQuery();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getSelectQuery");
    }

    public int getSequencePreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
    }

    public String getTableQualifier() {
        return this.tableQualifier;
    }

    public Timestamp getTimestampFromServer(AbstractSession session, String sessionName) {
        if (this.getTimestampQuery() == null) {
            return new Timestamp(System.currentTimeMillis());
        }
        this.getTimestampQuery().setSessionName(sessionName);
        return (Timestamp)session.executeQuery(this.getTimestampQuery());
    }

    public ValueReadQuery getTimestampQuery() {
        return this.timestampQuery;
    }

    public DataModifyQuery getUpdateSequenceQuery() {
        if (this.getDefaultSequence() instanceof QuerySequence) {
            return ((QuerySequence)this.getDefaultSequence()).getUpdateQuery();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getUpdateQuery");
    }

    protected void initializePlatformOperators() {
        this.platformOperators = new HashMap();
        this.addOperator(ExpressionOperator.equalOuterJoin());
        this.addOperator(ExpressionOperator.toUpperCase());
        this.addOperator(ExpressionOperator.toLowerCase());
        this.addOperator(ExpressionOperator.chr());
        this.addOperator(ExpressionOperator.concat());
        this.addOperator(ExpressionOperator.hexToRaw());
        this.addOperator(ExpressionOperator.initcap());
        this.addOperator(ExpressionOperator.instring());
        this.addOperator(ExpressionOperator.soundex());
        this.addOperator(ExpressionOperator.leftPad());
        this.addOperator(ExpressionOperator.leftTrim());
        this.addOperator(ExpressionOperator.leftTrim2());
        this.addOperator(ExpressionOperator.replace());
        this.addOperator(ExpressionOperator.rightPad());
        this.addOperator(ExpressionOperator.rightTrim());
        this.addOperator(ExpressionOperator.rightTrim2());
        this.addOperator(ExpressionOperator.substring());
        this.addOperator(ExpressionOperator.substringSingleArg());
        this.addOperator(ExpressionOperator.toNumber());
        this.addOperator(ExpressionOperator.toChar());
        this.addOperator(ExpressionOperator.toCharWithFormat());
        this.addOperator(ExpressionOperator.translate());
        this.addOperator(ExpressionOperator.trim());
        this.addOperator(ExpressionOperator.trim2());
        this.addOperator(ExpressionOperator.ascii());
        this.addOperator(ExpressionOperator.length());
        this.addOperator(ExpressionOperator.locate());
        this.addOperator(ExpressionOperator.locate2());
        this.addOperator(ExpressionOperator.nullIf());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(ExpressionOperator.addMonths());
        this.addOperator(ExpressionOperator.dateToString());
        this.addOperator(ExpressionOperator.lastDay());
        this.addOperator(ExpressionOperator.monthsBetween());
        this.addOperator(ExpressionOperator.nextDay());
        this.addOperator(ExpressionOperator.roundDate());
        this.addOperator(ExpressionOperator.toDate());
        this.addOperator(ExpressionOperator.today());
        this.addOperator(ExpressionOperator.currentDate());
        this.addOperator(ExpressionOperator.currentTime());
        this.addOperator(ExpressionOperator.simpleMath(78, "+"));
        this.addOperator(ExpressionOperator.simpleMath(79, "-"));
        this.addOperator(ExpressionOperator.simpleMath(81, "*"));
        this.addOperator(ExpressionOperator.simpleMath(80, "/"));
        this.addOperator(ExpressionOperator.negate());
        this.addOperator(ExpressionOperator.ceil());
        this.addOperator(ExpressionOperator.cos());
        this.addOperator(ExpressionOperator.cosh());
        this.addOperator(ExpressionOperator.abs());
        this.addOperator(ExpressionOperator.acos());
        this.addOperator(ExpressionOperator.asin());
        this.addOperator(ExpressionOperator.atan());
        this.addOperator(ExpressionOperator.exp());
        this.addOperator(ExpressionOperator.sqrt());
        this.addOperator(ExpressionOperator.floor());
        this.addOperator(ExpressionOperator.ln());
        this.addOperator(ExpressionOperator.log());
        this.addOperator(ExpressionOperator.mod());
        this.addOperator(ExpressionOperator.power());
        this.addOperator(ExpressionOperator.round());
        this.addOperator(ExpressionOperator.sign());
        this.addOperator(ExpressionOperator.sin());
        this.addOperator(ExpressionOperator.sinh());
        this.addOperator(ExpressionOperator.tan());
        this.addOperator(ExpressionOperator.tanh());
        this.addOperator(ExpressionOperator.trunc());
        this.addOperator(ExpressionOperator.greatest());
        this.addOperator(ExpressionOperator.least());
        this.addOperator(ExpressionOperator.standardDeviation());
        this.addOperator(ExpressionOperator.deref());
        this.addOperator(ExpressionOperator.ref());
        this.addOperator(ExpressionOperator.refToHex());
        this.addOperator(ExpressionOperator.value());
        this.addOperator(ExpressionOperator.coalesce());
        this.addOperator(ExpressionOperator.caseStatement());
    }

    public boolean isAccess() {
        return false;
    }

    public boolean isAttunity() {
        return false;
    }

    public boolean isCloudscape() {
        return false;
    }

    public boolean isDerby() {
        return false;
    }

    public boolean isDB2() {
        return false;
    }

    public boolean isH2() {
        return false;
    }

    public boolean isDBase() {
        return false;
    }

    public boolean isHSQL() {
        return false;
    }

    public boolean isInformix() {
        return false;
    }

    public boolean isMySQL() {
        return false;
    }

    public boolean isODBC() {
        return false;
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isOracle9() {
        return false;
    }

    public boolean isPostgreSQL() {
        return false;
    }

    public boolean isPointBase() {
        return false;
    }

    public boolean isSQLAnywhere() {
        return false;
    }

    public boolean isSQLServer() {
        return false;
    }

    public boolean isSybase() {
        return false;
    }

    public boolean isTimesTen() {
        return false;
    }

    public boolean isTimesTen7() {
        return false;
    }

    public void initialize() {
    }

    public void setSelectSequenceNumberQuery(ValueReadQuery seqQuery) {
        if (!(this.getDefaultSequence() instanceof QuerySequence)) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setSelectQuery");
        }
        ((QuerySequence)this.getDefaultSequence()).setSelectQuery(seqQuery);
    }

    public void setSequencePreallocationSize(int size) {
        this.getDefaultSequence().setPreallocationSize(size);
    }

    public void setTableQualifier(String qualifier) {
        this.tableQualifier = qualifier;
    }

    public void setTimestampQuery(ValueReadQuery tsQuery) {
        this.timestampQuery = tsQuery;
    }

    public void setUpdateSequenceQuery(DataModifyQuery updateSequenceNumberQuery) {
        if (!(this.getDefaultSequence() instanceof QuerySequence)) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setUpdateQuery");
        }
        ((QuerySequence)this.getDefaultSequence()).setUpdateQuery(updateSequenceNumberQuery);
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass());
    }

    public Vector getDataTypesConvertedFrom(Class javaClass) {
        return this.getConversionManager().getDataTypesConvertedFrom(javaClass);
    }

    public Vector getDataTypesConvertedTo(Class javaClass) {
        return this.getConversionManager().getDataTypesConvertedTo(javaClass);
    }

    public Sequence getDefaultSequence() {
        if (!this.hasDefaultSequence()) {
            this.setDefaultSequence(this.createPlatformDefaultSequence());
        }
        return this.defaultSequence;
    }

    public boolean hasDefaultSequence() {
        return this.defaultSequence != null;
    }

    public void setDefaultSequence(Sequence sequence) {
        if (sequence instanceof DefaultSequence) {
            Sequence platformDefaultSequence = this.createPlatformDefaultSequence();
            if (platformDefaultSequence != null) {
                platformDefaultSequence.setName(sequence.getName());
                if (((DefaultSequence)sequence).hasPreallocationSize()) {
                    platformDefaultSequence.setPreallocationSize(sequence.getPreallocationSize());
                }
            }
            this.defaultSequence = platformDefaultSequence;
        } else {
            this.defaultSequence = sequence;
        }
    }

    public void addSequence(Sequence sequence) {
        if (this.getSequences() == null) {
            this.createSequences();
        }
        this.getSequences().put(sequence.getName(), sequence);
    }

    public Sequence getSequence(String seqName) {
        if (seqName == null) {
            return this.getDefaultSequence();
        }
        if (this.getSequences() != null) {
            return (Sequence)this.getSequences().get(seqName);
        }
        return null;
    }

    protected Sequence createPlatformDefaultSequence() {
        throw ValidationException.createPlatformDefaultSequenceUndefined(Helper.getShortClassName(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSequences() {
        if (this.getSequences() == null) {
            DatasourcePlatform datasourcePlatform = this;
            synchronized (datasourcePlatform) {
                if (this.getSequences() == null) {
                    this.setSequences(new HashMap());
                }
            }
        }
    }

    public Sequence removeSequence(String seqName) {
        if (this.getSequences() != null) {
            return (Sequence)this.getSequences().remove(seqName);
        }
        return null;
    }

    public void removeAllSequences() {
        this.sequences = null;
    }

    public Map getSequences() {
        return this.sequences;
    }

    public Map getSequencesToWrite() {
        if (this.getSequences() == null || this.getSequences().isEmpty()) {
            return null;
        }
        HashMap<String, Sequence> sequencesToWrite = new HashMap<String, Sequence>();
        for (Sequence sequence : this.getSequences().values()) {
            if (sequence instanceof DefaultSequence && !((DefaultSequence)sequence).hasPreallocationSize()) continue;
            sequencesToWrite.put(sequence.getName(), sequence);
        }
        return sequencesToWrite;
    }

    public Sequence getDefaultSequenceToWrite() {
        if (this.usesPlatformDefaultSequence()) {
            return null;
        }
        return this.getDefaultSequence();
    }

    public void setSequences(Map sequences) {
        this.sequences = sequences;
    }

    public boolean usesPlatformDefaultSequence() {
        if (!this.hasDefaultSequence()) {
            return true;
        }
        return this.getDefaultSequence().equals(this.createPlatformDefaultSequence());
    }

    public String getIdentifierQuoteCharacter() {
        return "";
    }

    public ConnectionCustomizer createConnectionCustomizer(Accessor accessor, AbstractSession session) {
        return null;
    }
}

